/*
 * Decompiled with CFR 0.152.
 */
package com.impinj.octane;

import com.impinj.octane.OctaneSdkException;
import com.impinj.octane.TagFilterStateUnawareActionPair;

public enum TagFilterStateUnawareAction {
    Select,
    Unselect,
    DoNothing;


    static int convertToC1G2StateUnawareAction(TagFilterStateUnawareAction matchingAction, TagFilterStateUnawareAction nonMatchingAction) throws OctaneSdkException {
        int result;
        if (matchingAction == Select && nonMatchingAction == Unselect) {
            result = 0;
        } else if (matchingAction == Select && nonMatchingAction == DoNothing) {
            result = 1;
        } else if (matchingAction == DoNothing && nonMatchingAction == Unselect) {
            result = 2;
        } else if (matchingAction == Unselect && nonMatchingAction == DoNothing) {
            result = 3;
        } else if (matchingAction == Unselect && nonMatchingAction == Select) {
            result = 4;
        } else if (matchingAction == DoNothing && nonMatchingAction == Select) {
            result = 5;
        } else {
            throw new OctaneSdkException("Error converting to C1G2StateUnawareAction. Invalid combination of matching and nonMatching action. The matching action can not be the same as the non matching action.");
        }
        return result;
    }

    static TagFilterStateUnawareActionPair convertFromC1G2StateUnawareAction(int c1g2StateUnawareAction) throws OctaneSdkException {
        TagFilterStateUnawareActionPair result = new TagFilterStateUnawareActionPair();
        if (c1g2StateUnawareAction == 0) {
            result.matchingAction = Select;
            result.nonMatchingAction = Unselect;
        } else if (c1g2StateUnawareAction == 1) {
            result.matchingAction = Select;
            result.nonMatchingAction = DoNothing;
        } else if (c1g2StateUnawareAction == 2) {
            result.matchingAction = DoNothing;
            result.nonMatchingAction = Unselect;
        } else if (c1g2StateUnawareAction == 3) {
            result.matchingAction = Unselect;
            result.nonMatchingAction = DoNothing;
        } else if (c1g2StateUnawareAction == 4) {
            result.matchingAction = Unselect;
            result.nonMatchingAction = Select;
        } else if (c1g2StateUnawareAction == 5) {
            result.matchingAction = DoNothing;
            result.nonMatchingAction = Select;
        } else {
            throw new OctaneSdkException("Error converting to TagFilterStateUnawareAction. Unknown C1G2StateUnawareAction.");
        }
        return result;
    }
}

