/*
 * Decompiled with CFR 0.152.
 */
package com.impinj.octane;

import com.impinj.octane.DirectionFieldOfView;
import com.impinj.octane.DirectionMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DirectionConfig {
    static final short DEFAULT_TAG_AGE_INTERVAL_SECONDS = 2;
    static final short DEFAULT_UPDATE_INTERVAL_SECONDS = 2;
    static final DirectionFieldOfView DEFAULT_FIELD_OF_VIEW = DirectionFieldOfView.READER_SELECTED;
    private List<Short> enabledSectors = new ArrayList<Short>();
    private short userTagPopulationLimit;
    private boolean isMaxTxPower = true;
    private double txPowerinDbm;
    private short tagAgeIntervalSeconds = (short)2;
    private short updateIntervalSeconds = (short)2;
    private boolean updateReportEnabled = true;
    private boolean entryReportEnabled = true;
    private boolean exitReportEnabled = true;
    private boolean diagnosticReportEnabled = false;
    private DirectionFieldOfView fieldOfView = DEFAULT_FIELD_OF_VIEW;
    private DirectionMode mode = DirectionMode.HighPerformance;

    public void enableSector(short sector) {
        if (!this.enabledSectors.contains(sector)) {
            this.enabledSectors.add(sector);
        }
    }

    public void removeSector(short sector) {
        this.enabledSectors.remove((Object)sector);
    }

    public void removeAllSectors() {
        this.enabledSectors.clear();
    }

    public boolean isSectorEnabled(short sector) {
        return this.enabledSectors.contains(sector);
    }

    @Deprecated
    public boolean isSectorConfigurationValid() {
        if (this.enabledSectors.isEmpty()) {
            return false;
        }
        int MIN_SECTOR_NUMBER = 2;
        int MAX_SECTOR_NUMBER = 9;
        if (this.enabledSectors.contains((short)2) && this.enabledSectors.contains((short)9)) {
            return false;
        }
        Collections.sort(this.enabledSectors);
        for (int i = 1; i < this.enabledSectors.size(); ++i) {
            if (this.enabledSectors.get(i) != this.enabledSectors.get(i - 1) + 1) continue;
            return false;
        }
        return true;
    }

    public Short[] getEnabledSectors() {
        Short[] enabledSectorsArray = this.enabledSectors.toArray(new Short[0]);
        return enabledSectorsArray;
    }

    public short getUserTagPopulationLimit() {
        return this.userTagPopulationLimit;
    }

    public void setUserTagPopulationLimit(short userTagPopulationLimit) {
        this.userTagPopulationLimit = userTagPopulationLimit;
    }

    public boolean getIsMaxTxPower() {
        return this.isMaxTxPower;
    }

    public void setIsMaxTxPower(boolean maxTxPower) {
        this.isMaxTxPower = maxTxPower;
    }

    public double getTxPowerinDbm() {
        return this.txPowerinDbm;
    }

    public void setTxPowerinDbm(double txPowerinDbm) {
        this.setIsMaxTxPower(false);
        this.txPowerinDbm = txPowerinDbm;
    }

    public short getTagAgeIntervalSeconds() {
        return this.tagAgeIntervalSeconds;
    }

    public void setTagAgeIntervalSeconds(short tagAgeIntervalSeconds) {
        this.tagAgeIntervalSeconds = tagAgeIntervalSeconds < 1 ? (short)1 : tagAgeIntervalSeconds;
    }

    public short getUpdateIntervalSeconds() {
        return this.updateIntervalSeconds;
    }

    public void setUpdateIntervalSeconds(short updateIntervalSeconds) {
        this.updateIntervalSeconds = updateIntervalSeconds < 1 ? (short)1 : updateIntervalSeconds;
    }

    public boolean isUpdateReportEnabled() {
        return this.updateReportEnabled;
    }

    public void setUpdateReportEnabled(boolean updateReportEnabled) {
        this.updateReportEnabled = updateReportEnabled;
    }

    public boolean isEntryReportEnabled() {
        return this.entryReportEnabled;
    }

    public void setEntryReportEnabled(boolean entryReportEnabled) {
        this.entryReportEnabled = entryReportEnabled;
    }

    public boolean isExitReportEnabled() {
        return this.exitReportEnabled;
    }

    public void setExitReportEnabled(boolean exitReportEnabled) {
        this.exitReportEnabled = exitReportEnabled;
    }

    public boolean isDiagnosticReportEnabled() {
        return this.diagnosticReportEnabled;
    }

    public void setDiagnosticReportEnabled(boolean diagnosticReportEnabled) {
        this.diagnosticReportEnabled = diagnosticReportEnabled;
    }

    public DirectionFieldOfView getFieldOfView() {
        return this.fieldOfView;
    }

    public void setFieldOfView(DirectionFieldOfView fieldOfView) {
        this.fieldOfView = fieldOfView;
    }

    public DirectionMode getMode() {
        return this.mode;
    }

    public void setMode(DirectionMode mode) {
        this.mode = mode;
    }
}

