/*
 * Decompiled with CFR 0.152.
 */
package com.impinj.octane;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.impinj.octane.AntennaConfig;
import com.impinj.octane.AntennaConfigGroup;
import com.impinj.octane.AutoStartConfig;
import com.impinj.octane.AutoStartMode;
import com.impinj.octane.AutoStopConfig;
import com.impinj.octane.AutoStopMode;
import com.impinj.octane.FilterSettings;
import com.impinj.octane.GpiConfig;
import com.impinj.octane.GpiConfigGroup;
import com.impinj.octane.GpoConfig;
import com.impinj.octane.GpoConfigGroup;
import com.impinj.octane.GpoMode;
import com.impinj.octane.KeepaliveConfig;
import com.impinj.octane.LowDutyCycleSettings;
import com.impinj.octane.MemoryBank;
import com.impinj.octane.OctaneSdkException;
import com.impinj.octane.ReaderMode;
import com.impinj.octane.ReportConfig;
import com.impinj.octane.ReportMode;
import com.impinj.octane.SearchMode;
import com.impinj.octane.SpatialConfig;
import com.impinj.octane.TagFilterMode;
import com.impinj.octane.TagFilterStateUnawareAction;
import com.impinj.octane.TagFilterStateUnawareActionPair;
import com.impinj.octane.TagSelectFilter;
import com.impinj.octane.TruncatedReplySettings;
import com.impinj.octane.XArrayConfig;
import com.impinj.octane.XArrayMode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.llrp.ltk.generated.parameters.C1G2Filter;

public class Settings {
    private AutoStartConfig autoStart;
    private AutoStopConfig autoStop;
    @Deprecated
    private ReaderMode readerMode;
    private Integer rfMode;
    private SearchMode searchMode;
    private int session;
    private int tagPopulationEstimate;
    private LowDutyCycleSettings lowDutyCycle;
    private FilterSettings filters;
    private TruncatedReplySettings truncatedReply;
    private ReportConfig report;
    private AntennaConfigGroup antennas;
    private GpiConfigGroup gpis;
    private GpoConfigGroup gpos;
    private KeepaliveConfig keepalives;
    private Boolean holdReportsOnDisconnect;
    private ArrayList<Double> txFrequenciesInMhz;
    private ArrayList<Double> reducedPowerFrequenciesInMhz;
    private XArrayConfig xArray;

    Settings() {
        this.initVars();
    }

    Settings(long numberOfAntennas, int numberOfGpis, int numberOfGpos, String firmwareVersion) {
        this.initVars();
        this.setConfigDefaults(numberOfAntennas, numberOfGpis, numberOfGpos, firmwareVersion);
    }

    public static Settings load(String path) throws IOException {
        Gson gson = new Gson();
        BufferedReader br = new BufferedReader(new FileReader(path));
        Settings settingsObject = (Settings)gson.fromJson((Reader)br, Settings.class);
        return settingsObject;
    }

    private void setConfigDefaults(long numberOfAntennas, int numberOfGpis, int numberOfGpos, String firmwareVersion) {
        this.antennas = new AntennaConfigGroup(numberOfAntennas);
        for (AntennaConfig antenna : this.antennas) {
            antenna.setEnabled(true);
            antenna.setIsMaxRxSensitivity(true);
            antenna.setIsMaxTxPower(true);
        }
        this.gpis = new GpiConfigGroup(numberOfGpis);
        int i = 1;
        for (GpiConfig gpi : this.gpis) {
            gpi.setIsEnabled(true);
            gpi.setDebounceInMs(0L);
            gpi.setPortNumber(i);
            ++i;
        }
        this.gpos = new GpoConfigGroup(numberOfGpos);
        i = 1;
        for (GpoConfig gpo : this.gpos) {
            gpo.setGpoPulseDurationMsec(0L);
            gpo.setMode(GpoMode.Normal);
            gpo.setPortNumber(i);
            ++i;
        }
        this.autoStart.setMode(AutoStartMode.None);
        this.autoStop.setMode(AutoStopMode.None);
        this.readerMode = ReaderMode.AutoSetDenseReaderDeepScan;
        this.rfMode = null;
        this.searchMode = SearchMode.DualTarget;
        this.session = 2;
        this.tagPopulationEstimate = 32;
        this.report.setIncludeAntennaPortNumber(false);
        this.report.setIncludeChannel(false);
        this.report.setIncludeFirstSeenTime(false);
        this.report.setIncludeLastSeenTime(false);
        this.report.setIncludePeakRssi(false);
        this.report.setIncludeSeenCount(false);
        this.report.setIncludeFastId(false);
        this.report.setIncludePhaseAngle(false);
        this.report.setIncludeDopplerFrequency(false);
        this.report.setIncludeGpsCoordinates(false);
        this.report.setIncludePcBits(false);
        this.report.setIncludeCrc(false);
        this.report.setMode(ReportMode.Individual);
        this.keepalives.setEnabled(false);
        this.keepalives.setEnableLinkMonitorMode(false);
        this.lowDutyCycle.setIsEnabled(false);
        this.truncatedReply.setIsEnabled(false);
        this.truncatedReply.setGen2v2TagsOnly(false);
        this.truncatedReply.setEpcLengthInWords((byte)0);
        this.truncatedReply.setTagMask("");
        this.truncatedReply.setBitPointer((short)32);
        this.filters.setMode(TagFilterMode.None);
        this.filters.getTagFilter1().setBitCount(0L);
        this.filters.getTagFilter2().setBitCount(0L);
        this.txFrequenciesInMhz.clear();
        this.reducedPowerFrequenciesInMhz.clear();
        this.holdReportsOnDisconnect = false;
        this.xArray.setMode(XArrayMode.WideAreaMonitor);
        this.xArray.getPlacement().setHeightCm((short)400);
        this.xArray.getPlacement().setFacilityXLocationCm(0);
        this.xArray.getPlacement().setFacilityYLocationCm(0);
        this.xArray.getPlacement().setOrientationDegrees((short)0);
        this.xArray.getLocation().setEntryReportEnabled(true);
        this.xArray.getLocation().setExitReportEnabled(true);
        this.xArray.getLocation().setUpdateReportEnabled(true);
        this.xArray.getLocation().setDiagnosticReportEnabled(false);
        this.xArray.getLocation().setComputeWindowSeconds((short)10);
        this.xArray.getLocation().setUpdateIntervalSeconds((short)5);
        this.xArray.getLocation().setTagAgeIntervalSeconds((short)20);
    }

    public AutoStartConfig getAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(AutoStartConfig autoStart) {
        this.autoStart = autoStart;
    }

    public AutoStopConfig getAutoStop() {
        return this.autoStop;
    }

    public void setAutoStop(AutoStopConfig autoStop) {
        this.autoStop = autoStop;
    }

    @Deprecated
    public ReaderMode getReaderMode() {
        return this.readerMode;
    }

    @Deprecated
    public void setReaderMode(ReaderMode readerMode) {
        this.readerMode = readerMode;
        this.rfMode = null;
    }

    public Integer getRfMode() {
        return this.rfMode;
    }

    public void setRfMode(Integer rfMode) {
        this.rfMode = rfMode;
    }

    public SearchMode getSearchMode() {
        return this.searchMode;
    }

    public void setSearchMode(SearchMode searchMode) {
        this.searchMode = searchMode;
    }

    public int getSession() {
        return this.session;
    }

    public void setSession(int session) {
        this.session = session;
    }

    public int getTagPopulationEstimate() {
        return this.tagPopulationEstimate;
    }

    public void setTagPopulationEstimate(int tagPopulationEstimate) {
        this.tagPopulationEstimate = tagPopulationEstimate;
    }

    public LowDutyCycleSettings getLowDutyCycle() {
        return this.lowDutyCycle;
    }

    public void setLowDutyCycle(LowDutyCycleSettings lowDutyCycle) {
        this.lowDutyCycle = lowDutyCycle;
    }

    public FilterSettings getFilters() {
        return this.filters;
    }

    public void setFilters(FilterSettings filters) {
        this.filters = filters;
    }

    public TruncatedReplySettings getTruncatedReply() {
        return this.truncatedReply;
    }

    public void setTruncatedReply(TruncatedReplySettings truncatedReply) {
        this.truncatedReply = truncatedReply;
    }

    void loadFilterData(List<C1G2Filter> filters) throws OctaneSdkException {
        if (filters != null && filters.size() > 0) {
            this.getFilters().getTagFilter1().setMemoryBank(MemoryBank.valueOf(filters.get(0).getC1G2TagInventoryMask().getMB().intValue()));
            this.getFilters().getTagFilter1().setBitPointer(filters.get(0).getC1G2TagInventoryMask().getPointer().intValue());
            this.getFilters().getTagFilter1().setTagMask(filters.get(0).getC1G2TagInventoryMask().getTagMask().toString());
            if (filters.size() == 1) {
                this.getFilters().setMode(TagFilterMode.OnlyFilter1);
            }
            if (filters.size() == 2) {
                this.getFilters().getTagFilter2().setMemoryBank(MemoryBank.valueOf(filters.get(1).getC1G2TagInventoryMask().getMB().intValue()));
                this.getFilters().getTagFilter2().setBitPointer(filters.get(1).getC1G2TagInventoryMask().getPointer().intValue());
                this.getFilters().getTagFilter2().setTagMask(filters.get(1).getC1G2TagInventoryMask().getTagMask().toString());
                if (filters.get(1).getC1G2TagInventoryStateUnawareFilterAction().getAction().intValue() == 2) {
                    this.getFilters().setMode(TagFilterMode.Filter1AndFilter2);
                } else {
                    this.getFilters().setMode(TagFilterMode.Filter1OrFilter2);
                }
            }
            if (filters.size() > 2) {
                this.getFilters().setMode(TagFilterMode.UseTagSelectFilters);
            }
            List<TagSelectFilter> tagSelectFilterList = this.getFilters().getTagSelectFilterList();
            tagSelectFilterList.clear();
            for (C1G2Filter filter : filters) {
                TagSelectFilter tagSelectFilter = new TagSelectFilter();
                tagSelectFilter.setTagMask(filter.getC1G2TagInventoryMask().getTagMask().toString());
                tagSelectFilter.setBitPointer(filter.getC1G2TagInventoryMask().getPointer().intValue());
                tagSelectFilter.setMemoryBank(MemoryBank.valueOf(filter.getC1G2TagInventoryMask().getMB().intValue()));
                int c1g2StateUnawareAction = filter.getC1G2TagInventoryStateUnawareFilterAction().getAction().intValue();
                TagFilterStateUnawareActionPair tagFilterStateUnawareActions = TagFilterStateUnawareAction.convertFromC1G2StateUnawareAction(c1g2StateUnawareAction);
                tagSelectFilter.setMatchingAction(tagFilterStateUnawareActions.matchingAction);
                tagSelectFilter.setNonMatchingAction(tagFilterStateUnawareActions.nonMatchingAction);
                tagSelectFilterList.add(tagSelectFilter);
            }
        } else {
            this.getFilters().setMode(TagFilterMode.None);
        }
    }

    public ReportConfig getReport() {
        return this.report;
    }

    public void setReport(ReportConfig report) {
        this.report = report;
    }

    public AntennaConfigGroup getAntennas() {
        return this.antennas;
    }

    public void setAntennas(AntennaConfigGroup antennas) {
        this.antennas = antennas;
    }

    public GpiConfigGroup getGpis() {
        return this.gpis;
    }

    public void setGpis(GpiConfigGroup gpis) {
        this.gpis = gpis;
    }

    public GpoConfigGroup getGpos() {
        return this.gpos;
    }

    public void setGpos(GpoConfigGroup gpos) {
        this.gpos = gpos;
    }

    public KeepaliveConfig getKeepalives() {
        return this.keepalives;
    }

    public void setKeepalives(KeepaliveConfig keepalives) {
        this.keepalives = keepalives;
    }

    public Boolean getHoldReportsOnDisconnect() {
        return this.holdReportsOnDisconnect;
    }

    public void setHoldReportsOnDisconnect(Boolean holdReportsOnDisconnect) {
        this.holdReportsOnDisconnect = holdReportsOnDisconnect;
    }

    public ArrayList<Double> getTxFrequenciesInMhz() {
        return this.txFrequenciesInMhz;
    }

    public void setTxFrequenciesInMhz(ArrayList<Double> txFrequenciesInMhz) {
        this.txFrequenciesInMhz = txFrequenciesInMhz;
    }

    public ArrayList<Double> getReducedPowerFrequenciesInMhz() {
        return this.reducedPowerFrequenciesInMhz;
    }

    public void setReducedPowerFrequenciesInMhz(ArrayList<Double> reducedPowerFrequenciesInMhz) {
        this.reducedPowerFrequenciesInMhz = reducedPowerFrequenciesInMhz;
    }

    @Deprecated
    public XArrayConfig getXArray() {
        return this.xArray;
    }

    @Deprecated
    public void setXArray(XArrayConfig xArray) {
        this.xArray = xArray;
    }

    public SpatialConfig getSpatialConfig() {
        return this.xArray.getSpatialConfig();
    }

    public void setSpatialConfig(SpatialConfig spatialConfig) {
        this.xArray.setSpatialConfig(spatialConfig);
    }

    private void initVars() {
        this.autoStart = new AutoStartConfig();
        this.autoStop = new AutoStopConfig();
        this.lowDutyCycle = new LowDutyCycleSettings();
        this.truncatedReply = new TruncatedReplySettings();
        this.filters = new FilterSettings();
        this.report = new ReportConfig();
        this.keepalives = new KeepaliveConfig();
        this.txFrequenciesInMhz = new ArrayList();
        this.reducedPowerFrequenciesInMhz = new ArrayList();
        this.xArray = new XArrayConfig();
    }

    public void save(String path) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String output = gson.toJson((Object)this);
        File file = new File(path);
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        out.write(output);
        out.close();
    }
}

