/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.custom.parameters.ImpinjC1G2DirectionConfig;
import org.llrp.ltk.generated.custom.parameters.ImpinjDirectionConfig;
import org.llrp.ltk.generated.custom.parameters.ImpinjDirectionReporting;
import org.llrp.ltk.generated.custom.parameters.ImpinjDirectionSectors;
import org.llrp.ltk.generated.interfaces.SpecParameter;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class ImpinjDISpec
extends Custom
implements SpecParameter {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(1567);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjDISpec.class);
    private ImpinjDirectionSectors impinjDirectionSectors;
    private ImpinjDirectionConfig impinjDirectionConfig;
    private ImpinjC1G2DirectionConfig impinjC1G2DirectionConfig;
    private ImpinjDirectionReporting impinjDirectionReporting;
    private List<Custom> customList = new LinkedList<Custom>();

    public ImpinjDISpec() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjDISpec(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjDISpec(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(1567);
        this.decodeXML(element);
    }

    public ImpinjDISpec(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn(" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.impinjDirectionSectors == null) {
            LOGGER.warn(" impinjDirectionSectors not set");
        }
        resultBits.append(this.impinjDirectionSectors.encodeBinary());
        if (this.impinjDirectionConfig != null) {
            LOGGER.info(" impinjDirectionConfig not set");
            resultBits.append(this.impinjDirectionConfig.encodeBinary());
        }
        if (this.impinjC1G2DirectionConfig != null) {
            LOGGER.info(" impinjC1G2DirectionConfig not set");
            resultBits.append(this.impinjC1G2DirectionConfig.encodeBinary());
        }
        if (this.impinjDirectionReporting != null) {
            LOGGER.info(" impinjDirectionReporting not set");
            resultBits.append(this.impinjDirectionReporting.encodeBinary());
        }
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom field : this.customList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.42");
        Element element = new Element(name, ns);
        if (this.impinjDirectionSectors == null) {
            LOGGER.info("impinjDirectionSectors not set");
            throw new MissingParameterException("impinjDirectionSectors not set");
        }
        element.addContent(this.impinjDirectionSectors.encodeXML(this.impinjDirectionSectors.getClass().getSimpleName(), ns));
        if (this.impinjDirectionConfig == null) {
            LOGGER.info("impinjDirectionConfig not set");
        } else {
            element.addContent(this.impinjDirectionConfig.encodeXML(this.impinjDirectionConfig.getClass().getSimpleName(), ns));
        }
        if (this.impinjC1G2DirectionConfig == null) {
            LOGGER.info("impinjC1G2DirectionConfig not set");
        } else {
            element.addContent(this.impinjC1G2DirectionConfig.encodeXML(this.impinjC1G2DirectionConfig.getClass().getSimpleName(), ns));
        }
        if (this.impinjDirectionReporting == null) {
            LOGGER.info("impinjDirectionReporting not set");
        } else {
            element.addContent(this.impinjDirectionReporting.encodeXML(this.impinjDirectionReporting.getClass().getSimpleName(), ns));
        }
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom field : this.customList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        UnsignedInteger subType;
        UnsignedInteger vendor;
        short tempByteLength;
        SignedShort _type;
        int position = 0;
        int tempLength = 0;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-.");
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + ".");
        }
        if (binary.get(position)) {
            _type = new SignedShort(binary.subList(position + 1, 7));
        } else {
            _type = new SignedShort(binary.subList(position + 6, 10));
            tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
            tempLength = 8 * tempByteLength;
        }
        if (Custom.TYPENUM.equals(_type)) {
            vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
            subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
            if (vendor.equals(ImpinjDirectionSectors.VENDOR_ID) && subType.equals(ImpinjDirectionSectors.PARAMETER_SUBTYPE)) {
                this.impinjDirectionSectors = new ImpinjDirectionSectors(binary.subList(position, tempLength));
                position += tempLength;
            }
        }
        if (position < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjDirectionConfig.VENDOR_ID) && subType.equals(ImpinjDirectionConfig.PARAMETER_SUBTYPE)) {
                    this.impinjDirectionConfig = new ImpinjDirectionConfig(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        if (position < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjC1G2DirectionConfig.VENDOR_ID) && subType.equals(ImpinjC1G2DirectionConfig.PARAMETER_SUBTYPE)) {
                    this.impinjC1G2DirectionConfig = new ImpinjC1G2DirectionConfig(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        if (position < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjDirectionReporting.VENDOR_ID) && subType.equals(ImpinjDirectionReporting.PARAMETER_SUBTYPE)) {
                    this.impinjDirectionReporting = new ImpinjDirectionReporting(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        this.customList = new LinkedList<Custom>();
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            _type = new SignedShort(binary.subList(position + 6, 10));
            tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (_type == null || !_type.equals(Custom.TYPENUM)) continue;
            Custom cus = new Custom(binary.subList(position, tempLength));
            this.customList.add(cus);
            position += tempLength;
            atLeastOnce = true;
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Namespace llrpns;
        Element temp = null;
        List tempList = null;
        boolean atLeastOnce = false;
        temp = element.getChild("ImpinjDirectionSectors", element.getNamespace());
        if (temp == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjDirectionSectors", llrpns);
        }
        if (temp == null) {
            LOGGER.warn("ImpinjDISpec misses non optional parameter of type impinjDirectionSectors");
            throw new MissingParameterException("ImpinjDISpec misses non optional parameter of type impinjDirectionSectors");
        }
        this.impinjDirectionSectors = new ImpinjDirectionSectors(temp);
        LOGGER.info("setting parameter impinjDirectionSectors for parameter ImpinjDISpec");
        temp = element.getChild("ImpinjDirectionConfig", element.getNamespace());
        if (temp == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjDirectionConfig", llrpns);
        }
        if (temp != null) {
            this.impinjDirectionConfig = new ImpinjDirectionConfig(temp);
            LOGGER.info("setting parameter impinjDirectionConfig for parameter ImpinjDISpec");
        } else {
            LOGGER.info("ImpinjDISpec misses non optional parameter of type impinjDirectionConfig");
        }
        temp = element.getChild("ImpinjC1G2DirectionConfig", element.getNamespace());
        if (temp == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjC1G2DirectionConfig", llrpns);
        }
        if (temp != null) {
            this.impinjC1G2DirectionConfig = new ImpinjC1G2DirectionConfig(temp);
            LOGGER.info("setting parameter impinjC1G2DirectionConfig for parameter ImpinjDISpec");
        } else {
            LOGGER.info("ImpinjDISpec misses non optional parameter of type impinjC1G2DirectionConfig");
        }
        temp = element.getChild("ImpinjDirectionReporting", element.getNamespace());
        if (temp == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjDirectionReporting", llrpns);
        }
        if (temp != null) {
            this.impinjDirectionReporting = new ImpinjDirectionReporting(temp);
            LOGGER.info("setting parameter impinjDirectionReporting for parameter ImpinjDISpec");
        } else {
            LOGGER.info("ImpinjDISpec misses non optional parameter of type impinjDirectionReporting");
        }
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("Custom", llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjDISpec misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug("adding Custom to customList ");
            }
        }
    }

    public void setImpinjDirectionSectors(ImpinjDirectionSectors impinjDirectionSectors) {
        this.impinjDirectionSectors = impinjDirectionSectors;
    }

    public void setImpinjDirectionConfig(ImpinjDirectionConfig impinjDirectionConfig) {
        this.impinjDirectionConfig = impinjDirectionConfig;
    }

    public void setImpinjC1G2DirectionConfig(ImpinjC1G2DirectionConfig impinjC1G2DirectionConfig) {
        this.impinjC1G2DirectionConfig = impinjC1G2DirectionConfig;
    }

    public void setImpinjDirectionReporting(ImpinjDirectionReporting impinjDirectionReporting) {
        this.impinjDirectionReporting = impinjDirectionReporting;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public ImpinjDirectionSectors getImpinjDirectionSectors() {
        return this.impinjDirectionSectors;
    }

    public ImpinjDirectionConfig getImpinjDirectionConfig() {
        return this.impinjDirectionConfig;
    }

    public ImpinjC1G2DirectionConfig getImpinjC1G2DirectionConfig() {
        return this.impinjC1G2DirectionConfig;
    }

    public ImpinjDirectionReporting getImpinjDirectionReporting() {
        return this.impinjDirectionReporting;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

