/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.custom.parameters.ImpinjArrayVersion;
import org.llrp.ltk.generated.custom.parameters.ImpinjBLEVersion;
import org.llrp.ltk.generated.custom.parameters.ImpinjHubVersions;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UTF8String;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class ImpinjDetailedVersion
extends Custom {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(29);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjDetailedVersion.class);
    protected UTF8String modelName;
    protected UTF8String serialNumber;
    protected UTF8String softwareVersion;
    protected UTF8String firmwareVersion;
    protected UTF8String fPGAVersion;
    protected UTF8String pCBAVersion;
    private ImpinjHubVersions impinjHubVersions;
    private ImpinjArrayVersion impinjArrayVersion;
    private ImpinjBLEVersion impinjBLEVersion;
    private List<Custom> customList = new LinkedList<Custom>();

    public ImpinjDetailedVersion() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjDetailedVersion(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjDetailedVersion(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(29);
        this.decodeXML(element);
    }

    public ImpinjDetailedVersion(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn(" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.modelName == null) {
            LOGGER.warn(" modelName not set");
        }
        resultBits.append(this.modelName.encodeBinary());
        if (this.serialNumber == null) {
            LOGGER.warn(" serialNumber not set");
        }
        resultBits.append(this.serialNumber.encodeBinary());
        if (this.softwareVersion == null) {
            LOGGER.warn(" softwareVersion not set");
        }
        resultBits.append(this.softwareVersion.encodeBinary());
        if (this.firmwareVersion == null) {
            LOGGER.warn(" firmwareVersion not set");
        }
        resultBits.append(this.firmwareVersion.encodeBinary());
        if (this.fPGAVersion == null) {
            LOGGER.warn(" fPGAVersion not set");
        }
        resultBits.append(this.fPGAVersion.encodeBinary());
        if (this.pCBAVersion == null) {
            LOGGER.warn(" pCBAVersion not set");
        }
        resultBits.append(this.pCBAVersion.encodeBinary());
        if (this.impinjHubVersions != null) {
            LOGGER.info(" impinjHubVersions not set");
            resultBits.append(this.impinjHubVersions.encodeBinary());
        }
        if (this.impinjArrayVersion != null) {
            LOGGER.info(" impinjArrayVersion not set");
            resultBits.append(this.impinjArrayVersion.encodeBinary());
        }
        if (this.impinjBLEVersion != null) {
            LOGGER.info(" impinjBLEVersion not set");
            resultBits.append(this.impinjBLEVersion.encodeBinary());
        }
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom field : this.customList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.42");
        Element element = new Element(name, ns);
        if (this.modelName == null) {
            LOGGER.warn(" modelName not set");
            throw new MissingParameterException(" modelName not set");
        }
        element.addContent(this.modelName.encodeXML("ModelName", ns));
        if (this.serialNumber == null) {
            LOGGER.warn(" serialNumber not set");
            throw new MissingParameterException(" serialNumber not set");
        }
        element.addContent(this.serialNumber.encodeXML("SerialNumber", ns));
        if (this.softwareVersion == null) {
            LOGGER.warn(" softwareVersion not set");
            throw new MissingParameterException(" softwareVersion not set");
        }
        element.addContent(this.softwareVersion.encodeXML("SoftwareVersion", ns));
        if (this.firmwareVersion == null) {
            LOGGER.warn(" firmwareVersion not set");
            throw new MissingParameterException(" firmwareVersion not set");
        }
        element.addContent(this.firmwareVersion.encodeXML("FirmwareVersion", ns));
        if (this.fPGAVersion == null) {
            LOGGER.warn(" fPGAVersion not set");
            throw new MissingParameterException(" fPGAVersion not set");
        }
        element.addContent(this.fPGAVersion.encodeXML("FPGAVersion", ns));
        if (this.pCBAVersion == null) {
            LOGGER.warn(" pCBAVersion not set");
            throw new MissingParameterException(" pCBAVersion not set");
        }
        element.addContent(this.pCBAVersion.encodeXML("PCBAVersion", ns));
        if (this.impinjHubVersions == null) {
            LOGGER.info("impinjHubVersions not set");
        } else {
            element.addContent(this.impinjHubVersions.encodeXML(this.impinjHubVersions.getClass().getSimpleName(), ns));
        }
        if (this.impinjArrayVersion == null) {
            LOGGER.info("impinjArrayVersion not set");
        } else {
            element.addContent(this.impinjArrayVersion.encodeXML(this.impinjArrayVersion.getClass().getSimpleName(), ns));
        }
        if (this.impinjBLEVersion == null) {
            LOGGER.info("impinjBLEVersion not set");
        } else {
            element.addContent(this.impinjBLEVersion.encodeXML(this.impinjBLEVersion.getClass().getSimpleName(), ns));
        }
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom field : this.customList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        UnsignedInteger subType;
        UnsignedInteger vendor;
        short tempByteLength;
        SignedShort _type;
        int position = 0;
        int tempLength = 0;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-.");
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + ".");
        }
        short fieldCount = binary.subList(position, UnsignedShort.length()).toShort();
        tempLength = UTF8String.length() * fieldCount + UnsignedShort.length();
        this.modelName = new UTF8String(binary.subList(position, tempLength));
        position += tempLength;
        if (tempLength % 8 > 0) {
            position += 8 - tempLength % 8;
        }
        fieldCount = binary.subList(position, UnsignedShort.length()).toShort();
        tempLength = UTF8String.length() * fieldCount + UnsignedShort.length();
        this.serialNumber = new UTF8String(binary.subList(position, tempLength));
        position += tempLength;
        if (tempLength % 8 > 0) {
            position += 8 - tempLength % 8;
        }
        fieldCount = binary.subList(position, UnsignedShort.length()).toShort();
        tempLength = UTF8String.length() * fieldCount + UnsignedShort.length();
        this.softwareVersion = new UTF8String(binary.subList(position, tempLength));
        position += tempLength;
        if (tempLength % 8 > 0) {
            position += 8 - tempLength % 8;
        }
        fieldCount = binary.subList(position, UnsignedShort.length()).toShort();
        tempLength = UTF8String.length() * fieldCount + UnsignedShort.length();
        this.firmwareVersion = new UTF8String(binary.subList(position, tempLength));
        position += tempLength;
        if (tempLength % 8 > 0) {
            position += 8 - tempLength % 8;
        }
        fieldCount = binary.subList(position, UnsignedShort.length()).toShort();
        tempLength = UTF8String.length() * fieldCount + UnsignedShort.length();
        this.fPGAVersion = new UTF8String(binary.subList(position, tempLength));
        position += tempLength;
        if (tempLength % 8 > 0) {
            position += 8 - tempLength % 8;
        }
        fieldCount = binary.subList(position, UnsignedShort.length()).toShort();
        tempLength = UTF8String.length() * fieldCount + UnsignedShort.length();
        this.pCBAVersion = new UTF8String(binary.subList(position, tempLength));
        position += tempLength;
        if (tempLength % 8 > 0) {
            position += 8 - tempLength % 8;
        }
        if (position < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjHubVersions.VENDOR_ID) && subType.equals(ImpinjHubVersions.PARAMETER_SUBTYPE)) {
                    this.impinjHubVersions = new ImpinjHubVersions(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        if (position < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjArrayVersion.VENDOR_ID) && subType.equals(ImpinjArrayVersion.PARAMETER_SUBTYPE)) {
                    this.impinjArrayVersion = new ImpinjArrayVersion(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        if (position < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjBLEVersion.VENDOR_ID) && subType.equals(ImpinjBLEVersion.PARAMETER_SUBTYPE)) {
                    this.impinjBLEVersion = new ImpinjBLEVersion(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        this.customList = new LinkedList<Custom>();
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            _type = new SignedShort(binary.subList(position + 6, 10));
            tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (_type == null || !_type.equals(Custom.TYPENUM)) continue;
            Custom cus = new Custom(binary.subList(position, tempLength));
            this.customList.add(cus);
            position += tempLength;
            atLeastOnce = true;
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Namespace llrpns;
        Element temp = null;
        List tempList = null;
        boolean atLeastOnce = false;
        temp = element.getChild("ModelName", element.getNamespace());
        if (temp != null) {
            this.modelName = new UTF8String(temp);
        }
        if ((temp = element.getChild("SerialNumber", element.getNamespace())) != null) {
            this.serialNumber = new UTF8String(temp);
        }
        if ((temp = element.getChild("SoftwareVersion", element.getNamespace())) != null) {
            this.softwareVersion = new UTF8String(temp);
        }
        if ((temp = element.getChild("FirmwareVersion", element.getNamespace())) != null) {
            this.firmwareVersion = new UTF8String(temp);
        }
        if ((temp = element.getChild("FPGAVersion", element.getNamespace())) != null) {
            this.fPGAVersion = new UTF8String(temp);
        }
        if ((temp = element.getChild("PCBAVersion", element.getNamespace())) != null) {
            this.pCBAVersion = new UTF8String(temp);
        }
        if ((temp = element.getChild("ImpinjHubVersions", element.getNamespace())) == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjHubVersions", llrpns);
        }
        if (temp != null) {
            this.impinjHubVersions = new ImpinjHubVersions(temp);
            LOGGER.info("setting parameter impinjHubVersions for parameter ImpinjDetailedVersion");
        } else {
            LOGGER.info("ImpinjDetailedVersion misses non optional parameter of type impinjHubVersions");
        }
        temp = element.getChild("ImpinjArrayVersion", element.getNamespace());
        if (temp == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjArrayVersion", llrpns);
        }
        if (temp != null) {
            this.impinjArrayVersion = new ImpinjArrayVersion(temp);
            LOGGER.info("setting parameter impinjArrayVersion for parameter ImpinjDetailedVersion");
        } else {
            LOGGER.info("ImpinjDetailedVersion misses non optional parameter of type impinjArrayVersion");
        }
        temp = element.getChild("ImpinjBLEVersion", element.getNamespace());
        if (temp == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjBLEVersion", llrpns);
        }
        if (temp != null) {
            this.impinjBLEVersion = new ImpinjBLEVersion(temp);
            LOGGER.info("setting parameter impinjBLEVersion for parameter ImpinjDetailedVersion");
        } else {
            LOGGER.info("ImpinjDetailedVersion misses non optional parameter of type impinjBLEVersion");
        }
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("Custom", llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjDetailedVersion misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug("adding Custom to customList ");
            }
        }
    }

    public void setModelName(UTF8String modelName) {
        this.modelName = modelName;
    }

    public void setSerialNumber(UTF8String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void setSoftwareVersion(UTF8String softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public void setFirmwareVersion(UTF8String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    public void setFPGAVersion(UTF8String fPGAVersion) {
        this.fPGAVersion = fPGAVersion;
    }

    public void setPCBAVersion(UTF8String pCBAVersion) {
        this.pCBAVersion = pCBAVersion;
    }

    public void setImpinjHubVersions(ImpinjHubVersions impinjHubVersions) {
        this.impinjHubVersions = impinjHubVersions;
    }

    public void setImpinjArrayVersion(ImpinjArrayVersion impinjArrayVersion) {
        this.impinjArrayVersion = impinjArrayVersion;
    }

    public void setImpinjBLEVersion(ImpinjBLEVersion impinjBLEVersion) {
        this.impinjBLEVersion = impinjBLEVersion;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public UTF8String getModelName() {
        return this.modelName;
    }

    public UTF8String getSerialNumber() {
        return this.serialNumber;
    }

    public UTF8String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public UTF8String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public UTF8String getFPGAVersion() {
        return this.fPGAVersion;
    }

    public UTF8String getPCBAVersion() {
        return this.pCBAVersion;
    }

    public ImpinjHubVersions getImpinjHubVersions() {
        return this.impinjHubVersions;
    }

    public ImpinjArrayVersion getImpinjArrayVersion() {
        return this.impinjArrayVersion;
    }

    public ImpinjBLEVersion getImpinjBLEVersion() {
        return this.impinjBLEVersion;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

