/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.custom.enumerations.ImpinjHubConnectedType;
import org.llrp.ltk.generated.custom.enumerations.ImpinjHubFaultType;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class ImpinjHubConfiguration
extends Custom {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(1538);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjHubConfiguration.class);
    protected UnsignedShort hubID;
    protected ImpinjHubConnectedType connected;
    protected ImpinjHubFaultType fault;
    private List<Custom> customList = new LinkedList<Custom>();

    public ImpinjHubConfiguration() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjHubConfiguration(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjHubConfiguration(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(1538);
        this.decodeXML(element);
    }

    public ImpinjHubConfiguration(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn(" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.hubID == null) {
            LOGGER.warn(" hubID not set");
        }
        resultBits.append(this.hubID.encodeBinary());
        if (this.connected == null) {
            LOGGER.warn(" connected not set");
        }
        resultBits.append(this.connected.encodeBinary());
        if (this.fault == null) {
            LOGGER.warn(" fault not set");
        }
        resultBits.append(this.fault.encodeBinary());
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom field : this.customList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.42");
        Element element = new Element(name, ns);
        if (this.hubID == null) {
            LOGGER.warn(" hubID not set");
            throw new MissingParameterException(" hubID not set");
        }
        element.addContent(this.hubID.encodeXML("HubID", ns));
        if (this.connected == null) {
            LOGGER.warn(" connected not set");
            throw new MissingParameterException(" connected not set");
        }
        element.addContent(this.connected.encodeXML("Connected", ns));
        if (this.fault == null) {
            LOGGER.warn(" fault not set");
            throw new MissingParameterException(" fault not set");
        }
        element.addContent(this.fault.encodeXML("Fault", ns));
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom field : this.customList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-.");
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + ".");
        }
        this.hubID = new UnsignedShort(binary.subList(position, UnsignedShort.length()));
        this.connected = new ImpinjHubConnectedType(binary.subList(position += UnsignedShort.length(), ImpinjHubConnectedType.length()));
        this.fault = new ImpinjHubFaultType(binary.subList(position += ImpinjHubConnectedType.length(), ImpinjHubFaultType.length()));
        position += ImpinjHubFaultType.length();
        this.customList = new LinkedList<Custom>();
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            SignedShort _type = new SignedShort(binary.subList(position + 6, 10));
            short tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (_type == null || !_type.equals(Custom.TYPENUM)) continue;
            Custom cus = new Custom(binary.subList(position, tempLength));
            this.customList.add(cus);
            position += tempLength;
            atLeastOnce = true;
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Element temp = null;
        List tempList = null;
        boolean atLeastOnce = false;
        temp = element.getChild("HubID", element.getNamespace());
        if (temp != null) {
            this.hubID = new UnsignedShort(temp);
        }
        if ((temp = element.getChild("Connected", element.getNamespace())) != null) {
            this.connected = new ImpinjHubConnectedType(temp);
        }
        if ((temp = element.getChild("Fault", element.getNamespace())) != null) {
            this.fault = new ImpinjHubFaultType(temp);
        }
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            Namespace llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("Custom", llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjHubConfiguration misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug("adding Custom to customList ");
            }
        }
    }

    public void setHubID(UnsignedShort hubID) {
        this.hubID = hubID;
    }

    public void setConnected(ImpinjHubConnectedType connected) {
        this.connected = connected;
    }

    public void setFault(ImpinjHubFaultType fault) {
        this.fault = fault;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public UnsignedShort getHubID() {
        return this.hubID;
    }

    public ImpinjHubConnectedType getConnected() {
        return this.connected;
    }

    public ImpinjHubFaultType getFault() {
        return this.fault;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

