/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.generated.custom.parameters.ImpinjC1G2LocationConfig;
import org.llrp.ltk.generated.custom.parameters.ImpinjLocationConfig;
import org.llrp.ltk.generated.custom.parameters.ImpinjLocationReporting;
import org.llrp.ltk.generated.interfaces.SpecParameter;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class ImpinjLISpec
extends Custom
implements SpecParameter {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(1541);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjLISpec.class);
    private ImpinjLocationConfig impinjLocationConfig;
    private ImpinjC1G2LocationConfig impinjC1G2LocationConfig;
    private ImpinjLocationReporting impinjLocationReporting;
    private List<Custom> customList = new LinkedList<Custom>();

    public ImpinjLISpec() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjLISpec(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjLISpec(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(1541);
        this.decodeXML(element);
    }

    public ImpinjLISpec(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn(" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.impinjLocationConfig != null) {
            LOGGER.info(" impinjLocationConfig not set");
            resultBits.append(this.impinjLocationConfig.encodeBinary());
        }
        if (this.impinjC1G2LocationConfig != null) {
            LOGGER.info(" impinjC1G2LocationConfig not set");
            resultBits.append(this.impinjC1G2LocationConfig.encodeBinary());
        }
        if (this.impinjLocationReporting != null) {
            LOGGER.info(" impinjLocationReporting not set");
            resultBits.append(this.impinjLocationReporting.encodeBinary());
        }
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom field : this.customList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.42");
        Element element = new Element(name, ns);
        if (this.impinjLocationConfig == null) {
            LOGGER.info("impinjLocationConfig not set");
        } else {
            element.addContent(this.impinjLocationConfig.encodeXML(this.impinjLocationConfig.getClass().getSimpleName(), ns));
        }
        if (this.impinjC1G2LocationConfig == null) {
            LOGGER.info("impinjC1G2LocationConfig not set");
        } else {
            element.addContent(this.impinjC1G2LocationConfig.encodeXML(this.impinjC1G2LocationConfig.getClass().getSimpleName(), ns));
        }
        if (this.impinjLocationReporting == null) {
            LOGGER.info("impinjLocationReporting not set");
        } else {
            element.addContent(this.impinjLocationReporting.encodeXML(this.impinjLocationReporting.getClass().getSimpleName(), ns));
        }
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom field : this.customList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        UnsignedInteger subType;
        UnsignedInteger vendor;
        short tempByteLength;
        SignedShort _type;
        int position = 0;
        int tempLength = 0;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-.");
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + ".");
        }
        if (position < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjLocationConfig.VENDOR_ID) && subType.equals(ImpinjLocationConfig.PARAMETER_SUBTYPE)) {
                    this.impinjLocationConfig = new ImpinjLocationConfig(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        if (position < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjC1G2LocationConfig.VENDOR_ID) && subType.equals(ImpinjC1G2LocationConfig.PARAMETER_SUBTYPE)) {
                    this.impinjC1G2LocationConfig = new ImpinjC1G2LocationConfig(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        if (position < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjLocationReporting.VENDOR_ID) && subType.equals(ImpinjLocationReporting.PARAMETER_SUBTYPE)) {
                    this.impinjLocationReporting = new ImpinjLocationReporting(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        this.customList = new LinkedList<Custom>();
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            _type = new SignedShort(binary.subList(position + 6, 10));
            tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (_type == null || !_type.equals(Custom.TYPENUM)) continue;
            Custom cus = new Custom(binary.subList(position, tempLength));
            this.customList.add(cus);
            position += tempLength;
            atLeastOnce = true;
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Namespace llrpns;
        Element temp = null;
        List tempList = null;
        boolean atLeastOnce = false;
        temp = element.getChild("ImpinjLocationConfig", element.getNamespace());
        if (temp == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjLocationConfig", llrpns);
        }
        if (temp != null) {
            this.impinjLocationConfig = new ImpinjLocationConfig(temp);
            LOGGER.info("setting parameter impinjLocationConfig for parameter ImpinjLISpec");
        } else {
            LOGGER.info("ImpinjLISpec misses non optional parameter of type impinjLocationConfig");
        }
        temp = element.getChild("ImpinjC1G2LocationConfig", element.getNamespace());
        if (temp == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjC1G2LocationConfig", llrpns);
        }
        if (temp != null) {
            this.impinjC1G2LocationConfig = new ImpinjC1G2LocationConfig(temp);
            LOGGER.info("setting parameter impinjC1G2LocationConfig for parameter ImpinjLISpec");
        } else {
            LOGGER.info("ImpinjLISpec misses non optional parameter of type impinjC1G2LocationConfig");
        }
        temp = element.getChild("ImpinjLocationReporting", element.getNamespace());
        if (temp == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjLocationReporting", llrpns);
        }
        if (temp != null) {
            this.impinjLocationReporting = new ImpinjLocationReporting(temp);
            LOGGER.info("setting parameter impinjLocationReporting for parameter ImpinjLISpec");
        } else {
            LOGGER.info("ImpinjLISpec misses non optional parameter of type impinjLocationReporting");
        }
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("Custom", llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjLISpec misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug("adding Custom to customList ");
            }
        }
    }

    public void setImpinjLocationConfig(ImpinjLocationConfig impinjLocationConfig) {
        this.impinjLocationConfig = impinjLocationConfig;
    }

    public void setImpinjC1G2LocationConfig(ImpinjC1G2LocationConfig impinjC1G2LocationConfig) {
        this.impinjC1G2LocationConfig = impinjC1G2LocationConfig;
    }

    public void setImpinjLocationReporting(ImpinjLocationReporting impinjLocationReporting) {
        this.impinjLocationReporting = impinjLocationReporting;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public ImpinjLocationConfig getImpinjLocationConfig() {
        return this.impinjLocationConfig;
    }

    public ImpinjC1G2LocationConfig getImpinjC1G2LocationConfig() {
        return this.impinjC1G2LocationConfig;
    }

    public ImpinjLocationReporting getImpinjLocationReporting() {
        return this.impinjLocationReporting;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

