/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.messages;

import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.parameters.TagReportData;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPMessage;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class CLIENT_REQUEST_OP
extends LLRPMessage {
    public static final SignedShort TYPENUM = new SignedShort(45);
    private static final Logger LOGGER = Logger.getLogger(CLIENT_REQUEST_OP.class);
    public static final String RESPONSETYPE = "CLIENT_REQUEST_OP_RESPONSE";
    protected TagReportData tagReportData;

    public CLIENT_REQUEST_OP() {
        this.setVersion(new BitList(0, 0, 1));
    }

    public CLIENT_REQUEST_OP(LLRPBitList list) throws InvalidLLRPMessageException {
        this.decodeBinary(list);
    }

    public CLIENT_REQUEST_OP(byte[] byteArray) throws InvalidLLRPMessageException {
        this.decodeBinary(byteArray);
    }

    public CLIENT_REQUEST_OP(Document document) throws InvalidLLRPMessageException {
        this.decodeXML(document);
    }

    @Override
    protected LLRPBitList encodeBinarySpecific() throws InvalidLLRPMessageException {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.tagReportData == null) {
            LOGGER.warn(" tagReportData not set");
            throw new InvalidLLRPMessageException(" tagReportData not set");
        }
        resultBits.append(this.tagReportData.encodeBinary());
        return resultBits;
    }

    @Override
    public Document encodeXML() throws InvalidLLRPMessageException {
        try {
            Namespace ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            Element root = new Element("CLIENT_REQUEST_OP", ns);
            root.addNamespaceDeclaration(Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0"));
            root.addNamespaceDeclaration(Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.42"));
            if (this.version == null) {
                throw new InvalidLLRPMessageException("Version not set");
            }
            root.setAttribute("Version", this.version.toInteger().toString());
            if (this.messageID == null) {
                throw new InvalidLLRPMessageException("MessageID not set");
            }
            root.setAttribute("MessageID", this.messageID.toString(10));
            if (this.tagReportData == null) {
                LOGGER.info("tagReportData not set");
                throw new MissingParameterException("tagReportData not set");
            }
            root.addContent(this.tagReportData.encodeXML(this.tagReportData.getClass().getSimpleName(), ns));
            Document doc = new Document(root);
            if (this.isValidXMLMessage(doc, "org/llrp/ltk/llrp-1x0.xsd")) {
                return doc;
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) throws InvalidLLRPMessageException {
        int position = 0;
        int tempLength = 0;
        SignedShort type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.warn("CLIENT_REQUEST_OP misses non optional parameter of type TagReportData");
            throw new InvalidLLRPMessageException("CLIENT_REQUEST_OP misses non optional parameter of type TagReportData");
        }
        if (binary.get(position)) {
            CLIENT_REQUEST_OP cLIENT_REQUEST_OP = this;
            tempLength = cLIENT_REQUEST_OP.tagReportData.length();
        }
        if (type != null && type.equals(TagReportData.TYPENUM)) {
            this.tagReportData = new TagReportData(binary, position, tempLength);
            position += tempLength;
        } else {
            LOGGER.warn("CLIENT_REQUEST_OP misses non optional parameter of type TagReportData");
            throw new InvalidLLRPMessageException("CLIENT_REQUEST_OP misses non optional parameter of type TagReportData");
        }
        LOGGER.trace(" tagReportData is instantiated with TagReportData with length" + tempLength);
    }

    @Override
    public void decodeXML(Document document) throws InvalidLLRPMessageException {
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        try {
            this.isValidXMLMessage(document, "org/llrp/ltk/llrp-1x0.xsd");
            Element root = (Element)document.getRootElement().clone();
            Object tempList = null;
            String versionAttribute = root.getAttributeValue("Version");
            if (versionAttribute != null) {
                this.version = new BitList(3);
                this.version.setValue(new Integer(versionAttribute.trim()));
            } else {
                this.version = new BitList(0, 0, 1);
            }
            this.messageID = new UnsignedInteger(root.getAttributeValue("MessageID").trim());
            temp = root.getChild("TagReportData", ns);
            if (temp == null) {
                LOGGER.warn("CLIENT_REQUEST_OP misses non optional parameter of type tagReportData");
                throw new MissingParameterException("CLIENT_REQUEST_OP misses non optional parameter of type tagReportData");
            }
            this.tagReportData = new TagReportData(temp);
            LOGGER.info("setting parameter tagReportData for parameter CLIENT_REQUEST_OP");
            root.removeChild("TagReportData", ns);
            if (root.getChildren().size() > 0) {
                String message = "CLIENT_REQUEST_OP has unknown element " + ((Element)root.getChildren().get(0)).getName();
                throw new InvalidLLRPMessageException(message);
            }
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
    }

    public void setTagReportData(TagReportData tagReportData) {
        this.tagReportData = tagReportData;
    }

    public TagReportData getTagReportData() {
        return this.tagReportData;
    }

    @Override
    public String getResponseType() {
        return RESPONSETYPE;
    }

    @Override
    public String getName() {
        return "CLIENT_REQUEST_OP";
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }
}

