/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.messages;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.custom.parameters.ImpinjDiagnosticReport;
import org.llrp.ltk.generated.custom.parameters.ImpinjExtendedTagInformation;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.generated.parameters.RFSurveyReportData;
import org.llrp.ltk.generated.parameters.TagReportData;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPMessage;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class RO_ACCESS_REPORT
extends LLRPMessage {
    public static final SignedShort TYPENUM = new SignedShort(61);
    private static final Logger LOGGER = Logger.getLogger(RO_ACCESS_REPORT.class);
    public static final String RESPONSETYPE = "";
    protected List<TagReportData> tagReportDataList = new LinkedList<TagReportData>();
    protected List<RFSurveyReportData> rFSurveyReportDataList = new LinkedList<RFSurveyReportData>();
    protected List<Custom> customList = new LinkedList<Custom>();

    public RO_ACCESS_REPORT() {
        this.setVersion(new BitList(0, 0, 1));
    }

    public RO_ACCESS_REPORT(LLRPBitList list) throws InvalidLLRPMessageException {
        this.decodeBinary(list);
    }

    public RO_ACCESS_REPORT(byte[] byteArray) throws InvalidLLRPMessageException {
        this.decodeBinary(byteArray);
    }

    public RO_ACCESS_REPORT(Document document) throws InvalidLLRPMessageException {
        this.decodeXML(document);
    }

    @Override
    protected LLRPBitList encodeBinarySpecific() throws InvalidLLRPMessageException {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.tagReportDataList == null) {
            LOGGER.info(" tagReportDataList not set");
        } else {
            for (TagReportData tagReportData : this.tagReportDataList) {
                resultBits.append(tagReportData.encodeBinary());
            }
        }
        if (this.rFSurveyReportDataList == null) {
            LOGGER.info(" rFSurveyReportDataList not set");
        } else {
            for (RFSurveyReportData rFSurveyReportData : this.rFSurveyReportDataList) {
                resultBits.append(rFSurveyReportData.encodeBinary());
            }
        }
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom custom : this.customList) {
                resultBits.append(custom.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Document encodeXML() throws InvalidLLRPMessageException {
        try {
            Namespace ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            Element root = new Element("RO_ACCESS_REPORT", ns);
            root.addNamespaceDeclaration(Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0"));
            root.addNamespaceDeclaration(Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.42"));
            if (this.version == null) {
                throw new InvalidLLRPMessageException("Version not set");
            }
            root.setAttribute("Version", this.version.toInteger().toString());
            if (this.messageID == null) {
                throw new InvalidLLRPMessageException("MessageID not set");
            }
            root.setAttribute("MessageID", this.messageID.toString(10));
            if (this.tagReportDataList == null) {
                LOGGER.info("tagReportDataList not set");
            } else {
                for (TagReportData tagReportData : this.tagReportDataList) {
                    root.addContent(tagReportData.encodeXML(tagReportData.getClass().getName().replaceAll(tagReportData.getClass().getPackage().getName() + ".", RESPONSETYPE), ns));
                }
            }
            if (this.rFSurveyReportDataList == null) {
                LOGGER.info("rFSurveyReportDataList not set");
            } else {
                for (RFSurveyReportData rFSurveyReportData : this.rFSurveyReportDataList) {
                    root.addContent(rFSurveyReportData.encodeXML(rFSurveyReportData.getClass().getName().replaceAll(rFSurveyReportData.getClass().getPackage().getName() + ".", RESPONSETYPE), ns));
                }
            }
            if (this.customList == null) {
                LOGGER.info("customList not set");
            } else {
                for (Custom custom : this.customList) {
                    root.addContent(custom.encodeXML(custom.getClass().getName().replaceAll(custom.getClass().getPackage().getName() + ".", RESPONSETYPE), ns));
                }
            }
            Document doc = new Document(root);
            if (this.isValidXMLMessage(doc, "org/llrp/ltk/llrp-1x0.xsd")) {
                return doc;
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) throws InvalidLLRPMessageException {
        short tempByteLength;
        SignedShort type;
        boolean atLeastOnce;
        int position = 0;
        int tempLength = 0;
        this.tagReportDataList = new LinkedList<TagReportData>();
        LOGGER.trace("decoding parameter tagReportDataList ");
        while (position < binary.length()) {
            atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(TagReportData.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = TagReportData.length();
                }
                this.tagReportDataList.add(new TagReportData(binary, position, tempLength));
                LOGGER.trace("adding TagReportData to tagReportDataList ");
                atLeastOnce = true;
                position += tempLength;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.tagReportDataList.isEmpty()) {
            LOGGER.trace("RO_ACCESS_REPORT misses optional parameter of type TagReportData");
        }
        this.rFSurveyReportDataList = new LinkedList<RFSurveyReportData>();
        LOGGER.trace("decoding parameter rFSurveyReportDataList ");
        while (position < binary.length()) {
            atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(RFSurveyReportData.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = RFSurveyReportData.length();
                }
                this.rFSurveyReportDataList.add(new RFSurveyReportData(binary, position, tempLength));
                LOGGER.trace("adding RFSurveyReportData to rFSurveyReportDataList ");
                atLeastOnce = true;
                position += tempLength;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.rFSurveyReportDataList.isEmpty()) {
            LOGGER.trace("RO_ACCESS_REPORT misses optional parameter of type RFSurveyReportData");
        }
        this.customList = new LinkedList<Custom>();
        LOGGER.trace("decoding parameter customList ");
        while (position < binary.length()) {
            atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(Custom.TYPENUM)) {
                Custom cus = new Custom(binary, position, tempLength);
                if (cus.getParameterSubtype().equals(new ImpinjDiagnosticReport().getParameterSubtype())) {
                    this.customList.add(new ImpinjDiagnosticReport(cus));
                    atLeastOnce = true;
                    LOGGER.trace("adding ImpinjDiagnosticReport to customList ");
                    position += tempLength;
                    atLeastOnce = true;
                    continue;
                }
                if (cus.getParameterSubtype().equals(new ImpinjExtendedTagInformation().getParameterSubtype())) {
                    this.customList.add(new ImpinjExtendedTagInformation(cus));
                    atLeastOnce = true;
                    LOGGER.trace("adding ImpinjExtendedTagInformation to customList ");
                    position += tempLength;
                    atLeastOnce = true;
                    continue;
                }
                this.customList.add(cus);
                position += tempLength;
                atLeastOnce = true;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.customList.isEmpty()) {
            LOGGER.trace("RO_ACCESS_REPORT misses optional parameter of type Custom");
        }
    }

    @Override
    public void decodeXML(Document document) throws InvalidLLRPMessageException {
        Object temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        try {
            this.isValidXMLMessage(document, "org/llrp/ltk/llrp-1x0.xsd");
            Element root = (Element)document.getRootElement().clone();
            List tempList = null;
            String versionAttribute = root.getAttributeValue("Version");
            if (versionAttribute != null) {
                this.version = new BitList(3);
                this.version.setValue(new Integer(versionAttribute.trim()));
            } else {
                this.version = new BitList(0, 0, 1);
            }
            this.messageID = new UnsignedInteger(root.getAttributeValue("MessageID").trim());
            this.tagReportDataList = new LinkedList<TagReportData>();
            tempList = root.getChildren("TagReportData", ns);
            if (tempList == null || tempList.isEmpty()) {
                LOGGER.trace("RO_ACCESS_REPORT misses optional parameter of type tagReportDataList");
            } else {
                for (Object e : tempList) {
                    this.tagReportDataList.add(new TagReportData((Element)e));
                    LOGGER.trace("adding TagReportData to tagReportDataList ");
                }
            }
            root.removeChildren("TagReportData", ns);
            this.rFSurveyReportDataList = new LinkedList<RFSurveyReportData>();
            tempList = root.getChildren("RFSurveyReportData", ns);
            if (tempList == null || tempList.isEmpty()) {
                LOGGER.trace("RO_ACCESS_REPORT misses optional parameter of type rFSurveyReportDataList");
            } else {
                for (Object e : tempList) {
                    this.rFSurveyReportDataList.add(new RFSurveyReportData((Element)e));
                    LOGGER.trace("adding RFSurveyReportData to rFSurveyReportDataList ");
                }
            }
            root.removeChildren("RFSurveyReportData", ns);
            this.customList = new LinkedList<Custom>();
            tempList = root.getChildren("Custom", ns);
            if (tempList == null || tempList.isEmpty()) {
                LOGGER.trace("RO_ACCESS_REPORT misses optional parameter of type customList");
            } else {
                for (Object e : tempList) {
                    this.customList.add(new Custom((Element)e));
                    LOGGER.trace("adding Custom to customList ");
                }
            }
            root.removeChildren("Custom", ns);
            Namespace nsImpinjDiagnosticReport = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.42");
            tempList = root.getChildren("ImpinjDiagnosticReport", nsImpinjDiagnosticReport);
            for (Object e : tempList) {
                this.customList.add(new ImpinjDiagnosticReport((Element)e));
                LOGGER.trace("adding ImpinjDiagnosticReport to customList ");
            }
            root.removeChildren("ImpinjDiagnosticReport", nsImpinjDiagnosticReport);
            Namespace nsImpinjExtendedTagInformation = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.42");
            tempList = root.getChildren("ImpinjExtendedTagInformation", nsImpinjExtendedTagInformation);
            for (Element e : tempList) {
                this.customList.add(new ImpinjExtendedTagInformation(e));
                LOGGER.trace("adding ImpinjExtendedTagInformation to customList ");
            }
            root.removeChildren("ImpinjExtendedTagInformation", nsImpinjExtendedTagInformation);
            if (root.getChildren().size() > 0) {
                String message = "RO_ACCESS_REPORT has unknown element " + ((Element)root.getChildren().get(0)).getName();
                throw new InvalidLLRPMessageException(message);
            }
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
    }

    public void setTagReportDataList(List<TagReportData> tagReportDataList) {
        this.tagReportDataList = tagReportDataList;
    }

    public void setRFSurveyReportDataList(List<RFSurveyReportData> rFSurveyReportDataList) {
        this.rFSurveyReportDataList = rFSurveyReportDataList;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public List<TagReportData> getTagReportDataList() {
        return this.tagReportDataList;
    }

    public List<RFSurveyReportData> getRFSurveyReportDataList() {
        return this.rFSurveyReportDataList;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToTagReportDataList(TagReportData tagReportData) {
        if (this.tagReportDataList == null) {
            this.tagReportDataList = new LinkedList<TagReportData>();
        }
        this.tagReportDataList.add(tagReportData);
    }

    public void addToRFSurveyReportDataList(RFSurveyReportData rFSurveyReportData) {
        if (this.rFSurveyReportDataList == null) {
            this.rFSurveyReportDataList = new LinkedList<RFSurveyReportData>();
        }
        this.rFSurveyReportDataList.add(rFSurveyReportData);
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    @Override
    public String getResponseType() {
        return RESPONSETYPE;
    }

    @Override
    public String getName() {
        return "RO_ACCESS_REPORT";
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }
}

