/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.custom.parameters.ImpinjAccessSpecConfiguration;
import org.llrp.ltk.generated.enumerations.AccessSpecState;
import org.llrp.ltk.generated.enumerations.AirProtocols;
import org.llrp.ltk.generated.parameters.AccessCommand;
import org.llrp.ltk.generated.parameters.AccessReportSpec;
import org.llrp.ltk.generated.parameters.AccessSpecStopTrigger;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class AccessSpec
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(207);
    private static final Logger LOGGER = Logger.getLogger(AccessSpec.class);
    protected UnsignedInteger accessSpecID;
    protected UnsignedShort antennaID;
    protected AirProtocols protocolID;
    protected AccessSpecState currentState;
    protected BitList reserved0 = new BitList(7);
    protected UnsignedInteger rOSpecID;
    protected AccessSpecStopTrigger accessSpecStopTrigger;
    protected AccessCommand accessCommand;
    protected AccessReportSpec accessReportSpec;
    protected List<Custom> customList = new LinkedList<Custom>();

    public AccessSpec() {
    }

    public AccessSpec(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public AccessSpec(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public AccessSpec(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.accessSpecID == null) {
            LOGGER.warn(" accessSpecID not set");
            throw new MissingParameterException(" accessSpecID not set  for Parameter of Type AccessSpec");
        }
        resultBits.append(this.accessSpecID.encodeBinary());
        if (this.antennaID == null) {
            LOGGER.warn(" antennaID not set");
            throw new MissingParameterException(" antennaID not set  for Parameter of Type AccessSpec");
        }
        resultBits.append(this.antennaID.encodeBinary());
        if (this.protocolID == null) {
            LOGGER.warn(" protocolID not set");
            throw new MissingParameterException(" protocolID not set  for Parameter of Type AccessSpec");
        }
        resultBits.append(this.protocolID.encodeBinary());
        if (this.currentState == null) {
            LOGGER.warn(" currentState not set");
            throw new MissingParameterException(" currentState not set  for Parameter of Type AccessSpec");
        }
        resultBits.append(this.currentState.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        if (this.rOSpecID == null) {
            LOGGER.warn(" rOSpecID not set");
            throw new MissingParameterException(" rOSpecID not set  for Parameter of Type AccessSpec");
        }
        resultBits.append(this.rOSpecID.encodeBinary());
        if (this.accessSpecStopTrigger == null) {
            LOGGER.warn(" accessSpecStopTrigger not set");
            throw new MissingParameterException(" accessSpecStopTrigger not set");
        }
        resultBits.append(this.accessSpecStopTrigger.encodeBinary());
        if (this.accessCommand == null) {
            LOGGER.warn(" accessCommand not set");
            throw new MissingParameterException(" accessCommand not set");
        }
        resultBits.append(this.accessCommand.encodeBinary());
        if (this.accessReportSpec == null) {
            LOGGER.info(" accessReportSpec not set");
        } else {
            resultBits.append(this.accessReportSpec.encodeBinary());
        }
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom field : this.customList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.accessSpecID == null) {
            LOGGER.warn(" accessSpecID not set");
            throw new MissingParameterException(" accessSpecID not set");
        }
        element.addContent(this.accessSpecID.encodeXML("AccessSpecID", ns));
        if (this.antennaID == null) {
            LOGGER.warn(" antennaID not set");
            throw new MissingParameterException(" antennaID not set");
        }
        element.addContent(this.antennaID.encodeXML("AntennaID", ns));
        if (this.protocolID == null) {
            LOGGER.warn(" protocolID not set");
            throw new MissingParameterException(" protocolID not set");
        }
        element.addContent(this.protocolID.encodeXML("ProtocolID", ns));
        if (this.currentState == null) {
            LOGGER.warn(" currentState not set");
            throw new MissingParameterException(" currentState not set");
        }
        element.addContent(this.currentState.encodeXML("CurrentState", ns));
        if (this.rOSpecID == null) {
            LOGGER.warn(" rOSpecID not set");
            throw new MissingParameterException(" rOSpecID not set");
        }
        element.addContent(this.rOSpecID.encodeXML("ROSpecID", ns));
        if (this.accessSpecStopTrigger == null) {
            LOGGER.info("accessSpecStopTrigger not set");
            throw new MissingParameterException("accessSpecStopTrigger not set");
        }
        element.addContent(this.accessSpecStopTrigger.encodeXML(this.accessSpecStopTrigger.getClass().getSimpleName(), ns));
        if (this.accessCommand == null) {
            LOGGER.info("accessCommand not set");
            throw new MissingParameterException("accessCommand not set");
        }
        element.addContent(this.accessCommand.encodeXML(this.accessCommand.getClass().getSimpleName(), ns));
        if (this.accessReportSpec == null) {
            LOGGER.info("accessReportSpec not set");
        } else {
            element.addContent(this.accessReportSpec.encodeXML(this.accessReportSpec.getClass().getSimpleName(), ns));
        }
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom field : this.customList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.accessSpecID = new UnsignedInteger(binary, position, UnsignedInteger.length());
        this.antennaID = new UnsignedShort(binary, position += UnsignedInteger.length(), UnsignedShort.length());
        this.protocolID = new AirProtocols(binary, position += UnsignedShort.length(), AirProtocols.length());
        this.currentState = new AccessSpecState(binary, position += AirProtocols.length(), AccessSpecState.length());
        position += AccessSpecState.length();
        this.rOSpecID = new UnsignedInteger(binary, position += this.reserved0.length(), UnsignedInteger.length());
        position += UnsignedInteger.length();
        SignedShort type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.warn("AccessSpec misses non optional parameter of type AccessSpecStopTrigger");
            throw new MissingParameterException("AccessSpec misses non optional parameter of type AccessSpecStopTrigger");
        }
        if (binary.get(position)) {
            AccessSpec accessSpec = this;
            tempLength = accessSpec.accessSpecStopTrigger.length();
        }
        if (type != null && type.equals(AccessSpecStopTrigger.TYPENUM)) {
            this.accessSpecStopTrigger = new AccessSpecStopTrigger(binary, position, tempLength);
            position += tempLength;
        } else {
            LOGGER.warn("AccessSpec misses non optional parameter of type AccessSpecStopTrigger");
            throw new MissingParameterException("AccessSpec misses non optional parameter of type AccessSpecStopTrigger");
        }
        LOGGER.trace(" accessSpecStopTrigger is instantiated with AccessSpecStopTrigger with length" + tempLength);
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.warn("AccessSpec misses non optional parameter of type AccessCommand");
            throw new MissingParameterException("AccessSpec misses non optional parameter of type AccessCommand");
        }
        if (binary.get(position)) {
            AccessSpec accessSpec = this;
            tempLength = accessSpec.accessCommand.length();
        }
        if (type != null && type.equals(AccessCommand.TYPENUM)) {
            this.accessCommand = new AccessCommand(binary, position, tempLength);
            position += tempLength;
        } else {
            LOGGER.warn("AccessSpec misses non optional parameter of type AccessCommand");
            throw new MissingParameterException("AccessSpec misses non optional parameter of type AccessCommand");
        }
        LOGGER.trace(" accessCommand is instantiated with AccessCommand with length" + tempLength);
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace("AccessSpec misses optional parameter of type AccessReportSpec");
        }
        if (binary.get(position)) {
            AccessSpec accessSpec = this;
            tempLength = accessSpec.accessReportSpec.length();
        }
        if (type != null && type.equals(AccessReportSpec.TYPENUM)) {
            this.accessReportSpec = new AccessReportSpec(binary, position, tempLength);
            position += tempLength;
            LOGGER.trace(" accessReportSpec is instantiated with AccessReportSpec with length" + tempLength);
        } else {
            LOGGER.trace("AccessSpec misses optional parameter of type AccessReportSpec");
        }
        this.customList = new LinkedList<Custom>();
        LOGGER.trace("decoding parameter customList ");
        while (position < binary.length()) {
            boolean foundOne = false;
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(Custom.TYPENUM)) {
                Custom cus = new Custom(binary, position, tempLength);
                if (cus.getParameterSubtype().equals(ImpinjAccessSpecConfiguration.PARAMETER_SUBTYPE)) {
                    this.customList.add(new ImpinjAccessSpecConfiguration(cus));
                    LOGGER.trace("adding ImpinjAccessSpecConfiguration to customList ");
                    position += tempLength;
                    foundOne = true;
                    continue;
                }
                this.customList.add(cus);
                position += tempLength;
                foundOne = true;
            }
            if (foundOne) continue;
            break;
        }
        if (this.customList.isEmpty()) {
            LOGGER.trace("AccessSpec misses optional parameter of type Custom");
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        List tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("AccessSpecID", ns);
        if (temp != null) {
            this.accessSpecID = new UnsignedInteger(temp);
        }
        element.removeChild("AccessSpecID", ns);
        temp = element.getChild("AntennaID", ns);
        if (temp != null) {
            this.antennaID = new UnsignedShort(temp);
        }
        element.removeChild("AntennaID", ns);
        temp = element.getChild("ProtocolID", ns);
        if (temp != null) {
            this.protocolID = new AirProtocols(temp);
        }
        element.removeChild("ProtocolID", ns);
        temp = element.getChild("CurrentState", ns);
        if (temp != null) {
            this.currentState = new AccessSpecState(temp);
        }
        element.removeChild("CurrentState", ns);
        temp = element.getChild("ROSpecID", ns);
        if (temp != null) {
            this.rOSpecID = new UnsignedInteger(temp);
        }
        element.removeChild("ROSpecID", ns);
        temp = element.getChild("AccessSpecStopTrigger", ns);
        if (temp != null) {
            this.accessSpecStopTrigger = new AccessSpecStopTrigger(temp);
            LOGGER.info("setting parameter accessSpecStopTrigger for parameter AccessSpec");
        }
        if (temp == null) {
            LOGGER.warn("AccessSpec misses non optional parameter of type accessSpecStopTrigger");
            throw new MissingParameterException("AccessSpec misses non optional parameter of type accessSpecStopTrigger");
        }
        element.removeChild("AccessSpecStopTrigger", ns);
        temp = element.getChild("AccessCommand", ns);
        if (temp != null) {
            this.accessCommand = new AccessCommand(temp);
            LOGGER.info("setting parameter accessCommand for parameter AccessSpec");
        }
        if (temp == null) {
            LOGGER.warn("AccessSpec misses non optional parameter of type accessCommand");
            throw new MissingParameterException("AccessSpec misses non optional parameter of type accessCommand");
        }
        element.removeChild("AccessCommand", ns);
        temp = element.getChild("AccessReportSpec", ns);
        if (temp != null) {
            this.accessReportSpec = new AccessReportSpec(temp);
            LOGGER.info("setting parameter accessReportSpec for parameter AccessSpec");
        }
        if (temp == null) {
            LOGGER.trace("AccessSpec misses optional parameter of type accessReportSpec");
        }
        element.removeChild("AccessReportSpec", ns);
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", ns);
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.trace("AccessSpec misses optional parameter of type customList");
        } else {
            for (Iterator e : tempList) {
                this.customList.add(new Custom((Element)((Object)e)));
                LOGGER.trace("adding Custom to customList ");
            }
        }
        element.removeChildren("Custom", ns);
        Namespace nsImpinjAccessSpecConfiguration = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.42");
        tempList = element.getChildren("ImpinjAccessSpecConfiguration", nsImpinjAccessSpecConfiguration);
        for (Element e : tempList) {
            this.customList.add(new ImpinjAccessSpecConfiguration(e));
            LOGGER.trace("adding ImpinjAccessSpecConfiguration to customList ");
        }
        element.removeChildren("ImpinjAccessSpecConfiguration", nsImpinjAccessSpecConfiguration);
        tempList = element.getChildren("Custom", ns);
        for (Element e : tempList) {
            this.customList.add(new Custom(e));
            atLeastOnce = true;
            LOGGER.trace("adding custom parameter");
        }
        element.removeChildren("Custom", ns);
        if (element.getChildren().size() > 0) {
            String message = "AccessSpec has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setAccessSpecID(UnsignedInteger accessSpecID) {
        this.accessSpecID = accessSpecID;
    }

    public void setAntennaID(UnsignedShort antennaID) {
        this.antennaID = antennaID;
    }

    public void setProtocolID(AirProtocols protocolID) {
        this.protocolID = protocolID;
    }

    public void setCurrentState(AccessSpecState currentState) {
        this.currentState = currentState;
    }

    public void setROSpecID(UnsignedInteger rOSpecID) {
        this.rOSpecID = rOSpecID;
    }

    public void setAccessSpecStopTrigger(AccessSpecStopTrigger accessSpecStopTrigger) {
        this.accessSpecStopTrigger = accessSpecStopTrigger;
    }

    public void setAccessCommand(AccessCommand accessCommand) {
        this.accessCommand = accessCommand;
    }

    public void setAccessReportSpec(AccessReportSpec accessReportSpec) {
        this.accessReportSpec = accessReportSpec;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public UnsignedInteger getAccessSpecID() {
        return this.accessSpecID;
    }

    public UnsignedShort getAntennaID() {
        return this.antennaID;
    }

    public AirProtocols getProtocolID() {
        return this.protocolID;
    }

    public AccessSpecState getCurrentState() {
        return this.currentState;
    }

    public UnsignedInteger getROSpecID() {
        return this.rOSpecID;
    }

    public AccessSpecStopTrigger getAccessSpecStopTrigger() {
        return this.accessSpecStopTrigger;
    }

    public AccessCommand getAccessCommand() {
        return this.accessCommand;
    }

    public AccessReportSpec getAccessReportSpec() {
        return this.accessReportSpec;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "AccessSpec";
    }

    public String toString() {
        String result = "AccessSpec: ";
        result = result + ", accessSpecID: ";
        result = result + this.accessSpecID;
        result = result + ", antennaID: ";
        result = result + this.antennaID;
        result = result + ", protocolID: ";
        result = result + this.protocolID;
        result = result + ", currentState: ";
        result = result + this.currentState;
        result = result + ", rOSpecID: ";
        result = result + this.rOSpecID;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

