/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.generated.custom.parameters.ImpinjAntennaEventConfiguration;
import org.llrp.ltk.generated.custom.parameters.ImpinjAntennaEventHysteresis;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class ImpinjAntennaConfiguration
extends Custom {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(1524);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjAntennaConfiguration.class);
    private ImpinjAntennaEventHysteresis impinjAntennaEventHysteresis;
    private ImpinjAntennaEventConfiguration impinjAntennaEventConfiguration;
    private List<Custom> customList = new LinkedList<Custom>();

    public ImpinjAntennaConfiguration() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjAntennaConfiguration(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjAntennaConfiguration(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(1524);
        this.decodeXML(element);
    }

    public ImpinjAntennaConfiguration(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn(" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.impinjAntennaEventHysteresis != null) {
            LOGGER.info(" impinjAntennaEventHysteresis not set");
            resultBits.append(this.impinjAntennaEventHysteresis.encodeBinary());
        }
        if (this.impinjAntennaEventConfiguration != null) {
            LOGGER.info(" impinjAntennaEventConfiguration not set");
            resultBits.append(this.impinjAntennaEventConfiguration.encodeBinary());
        }
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom field : this.customList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.42");
        Element element = new Element(name, ns);
        if (this.impinjAntennaEventHysteresis == null) {
            LOGGER.info("impinjAntennaEventHysteresis not set");
        } else {
            element.addContent(this.impinjAntennaEventHysteresis.encodeXML(this.impinjAntennaEventHysteresis.getClass().getSimpleName(), ns));
        }
        if (this.impinjAntennaEventConfiguration == null) {
            LOGGER.info("impinjAntennaEventConfiguration not set");
        } else {
            element.addContent(this.impinjAntennaEventConfiguration.encodeXML(this.impinjAntennaEventConfiguration.getClass().getSimpleName(), ns));
        }
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom field : this.customList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        UnsignedInteger subType;
        UnsignedInteger vendor;
        short tempByteLength;
        SignedShort _type;
        int position = 0;
        int tempLength = 0;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-.");
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + ".");
        }
        if (position < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjAntennaEventHysteresis.VENDOR_ID) && subType.equals(ImpinjAntennaEventHysteresis.PARAMETER_SUBTYPE)) {
                    this.impinjAntennaEventHysteresis = new ImpinjAntennaEventHysteresis(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        if (position < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjAntennaEventConfiguration.VENDOR_ID) && subType.equals(ImpinjAntennaEventConfiguration.PARAMETER_SUBTYPE)) {
                    this.impinjAntennaEventConfiguration = new ImpinjAntennaEventConfiguration(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        this.customList = new LinkedList<Custom>();
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            _type = new SignedShort(binary.subList(position + 6, 10));
            tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (_type == null || !_type.equals(Custom.TYPENUM)) continue;
            Custom cus = new Custom(binary.subList(position, tempLength));
            this.customList.add(cus);
            position += tempLength;
            atLeastOnce = true;
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Namespace llrpns;
        Element temp = null;
        List tempList = null;
        boolean atLeastOnce = false;
        temp = element.getChild("ImpinjAntennaEventHysteresis", element.getNamespace());
        if (temp == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjAntennaEventHysteresis", llrpns);
        }
        if (temp != null) {
            this.impinjAntennaEventHysteresis = new ImpinjAntennaEventHysteresis(temp);
            LOGGER.info("setting parameter impinjAntennaEventHysteresis for parameter ImpinjAntennaConfiguration");
        } else {
            LOGGER.info("ImpinjAntennaConfiguration misses non optional parameter of type impinjAntennaEventHysteresis");
        }
        temp = element.getChild("ImpinjAntennaEventConfiguration", element.getNamespace());
        if (temp == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjAntennaEventConfiguration", llrpns);
        }
        if (temp != null) {
            this.impinjAntennaEventConfiguration = new ImpinjAntennaEventConfiguration(temp);
            LOGGER.info("setting parameter impinjAntennaEventConfiguration for parameter ImpinjAntennaConfiguration");
        } else {
            LOGGER.info("ImpinjAntennaConfiguration misses non optional parameter of type impinjAntennaEventConfiguration");
        }
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("Custom", llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjAntennaConfiguration misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug("adding Custom to customList ");
            }
        }
    }

    public void setImpinjAntennaEventHysteresis(ImpinjAntennaEventHysteresis impinjAntennaEventHysteresis) {
        this.impinjAntennaEventHysteresis = impinjAntennaEventHysteresis;
    }

    public void setImpinjAntennaEventConfiguration(ImpinjAntennaEventConfiguration impinjAntennaEventConfiguration) {
        this.impinjAntennaEventConfiguration = impinjAntennaEventConfiguration;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public ImpinjAntennaEventHysteresis getImpinjAntennaEventHysteresis() {
        return this.impinjAntennaEventHysteresis;
    }

    public ImpinjAntennaEventConfiguration getImpinjAntennaEventConfiguration() {
        return this.impinjAntennaEventConfiguration;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

