/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.custom.enumerations.ImpinjDirectionDiagnosticReportLevel;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;

public class ImpinjDirectionReporting
extends Custom {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(1572);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjDirectionReporting.class);
    protected Bit enableUpdateReport;
    protected Bit enableEntryReport;
    protected Bit enableExitReport;
    protected Bit enableDiagnosticReport;
    private BitList reserved0 = new BitList(4);
    protected ImpinjDirectionDiagnosticReportLevel diagnosticReportLevel;
    private List<Custom> customList = new LinkedList<Custom>();

    public ImpinjDirectionReporting() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjDirectionReporting(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjDirectionReporting(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(1572);
        this.decodeXML(element);
    }

    public ImpinjDirectionReporting(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn(" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.enableUpdateReport == null) {
            LOGGER.warn(" enableUpdateReport not set");
        }
        resultBits.append(this.enableUpdateReport.encodeBinary());
        if (this.enableEntryReport == null) {
            LOGGER.warn(" enableEntryReport not set");
        }
        resultBits.append(this.enableEntryReport.encodeBinary());
        if (this.enableExitReport == null) {
            LOGGER.warn(" enableExitReport not set");
        }
        resultBits.append(this.enableExitReport.encodeBinary());
        if (this.enableDiagnosticReport == null) {
            LOGGER.warn(" enableDiagnosticReport not set");
        }
        resultBits.append(this.enableDiagnosticReport.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        if (this.diagnosticReportLevel == null) {
            LOGGER.warn(" diagnosticReportLevel not set");
        }
        resultBits.append(this.diagnosticReportLevel.encodeBinary());
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom field : this.customList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.42");
        Element element = new Element(name, ns);
        if (this.enableUpdateReport == null) {
            LOGGER.warn(" enableUpdateReport not set");
            throw new MissingParameterException(" enableUpdateReport not set");
        }
        element.addContent(this.enableUpdateReport.encodeXML("EnableUpdateReport", ns));
        if (this.enableEntryReport == null) {
            LOGGER.warn(" enableEntryReport not set");
            throw new MissingParameterException(" enableEntryReport not set");
        }
        element.addContent(this.enableEntryReport.encodeXML("EnableEntryReport", ns));
        if (this.enableExitReport == null) {
            LOGGER.warn(" enableExitReport not set");
            throw new MissingParameterException(" enableExitReport not set");
        }
        element.addContent(this.enableExitReport.encodeXML("EnableExitReport", ns));
        if (this.enableDiagnosticReport == null) {
            LOGGER.warn(" enableDiagnosticReport not set");
            throw new MissingParameterException(" enableDiagnosticReport not set");
        }
        element.addContent(this.enableDiagnosticReport.encodeXML("EnableDiagnosticReport", ns));
        if (this.diagnosticReportLevel == null) {
            LOGGER.warn(" diagnosticReportLevel not set");
            throw new MissingParameterException(" diagnosticReportLevel not set");
        }
        element.addContent(this.diagnosticReportLevel.encodeXML("DiagnosticReportLevel", ns));
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom field : this.customList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-.");
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + ".");
        }
        this.enableUpdateReport = new Bit(binary.subList(position, Bit.length()));
        this.enableEntryReport = new Bit(binary.subList(position += Bit.length(), Bit.length()));
        this.enableExitReport = new Bit(binary.subList(position += Bit.length(), Bit.length()));
        this.enableDiagnosticReport = new Bit(binary.subList(position += Bit.length(), Bit.length()));
        position += Bit.length();
        this.diagnosticReportLevel = new ImpinjDirectionDiagnosticReportLevel(binary.subList(position += this.reserved0.length(), ImpinjDirectionDiagnosticReportLevel.length()));
        position += ImpinjDirectionDiagnosticReportLevel.length();
        this.customList = new LinkedList<Custom>();
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            SignedShort _type = new SignedShort(binary.subList(position + 6, 10));
            short tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (_type == null || !_type.equals(Custom.TYPENUM)) continue;
            Custom cus = new Custom(binary.subList(position, tempLength));
            this.customList.add(cus);
            position += tempLength;
            atLeastOnce = true;
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Element temp = null;
        List tempList = null;
        boolean atLeastOnce = false;
        temp = element.getChild("EnableUpdateReport", element.getNamespace());
        if (temp != null) {
            this.enableUpdateReport = new Bit(temp);
        }
        if ((temp = element.getChild("EnableEntryReport", element.getNamespace())) != null) {
            this.enableEntryReport = new Bit(temp);
        }
        if ((temp = element.getChild("EnableExitReport", element.getNamespace())) != null) {
            this.enableExitReport = new Bit(temp);
        }
        if ((temp = element.getChild("EnableDiagnosticReport", element.getNamespace())) != null) {
            this.enableDiagnosticReport = new Bit(temp);
        }
        if ((temp = element.getChild("DiagnosticReportLevel", element.getNamespace())) != null) {
            this.diagnosticReportLevel = new ImpinjDirectionDiagnosticReportLevel(temp);
        }
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            Namespace llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("Custom", llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjDirectionReporting misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug("adding Custom to customList ");
            }
        }
    }

    public void setEnableUpdateReport(Bit enableUpdateReport) {
        this.enableUpdateReport = enableUpdateReport;
    }

    public void setEnableEntryReport(Bit enableEntryReport) {
        this.enableEntryReport = enableEntryReport;
    }

    public void setEnableExitReport(Bit enableExitReport) {
        this.enableExitReport = enableExitReport;
    }

    public void setEnableDiagnosticReport(Bit enableDiagnosticReport) {
        this.enableDiagnosticReport = enableDiagnosticReport;
    }

    public void setDiagnosticReportLevel(ImpinjDirectionDiagnosticReportLevel diagnosticReportLevel) {
        this.diagnosticReportLevel = diagnosticReportLevel;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public Bit getEnableUpdateReport() {
        return this.enableUpdateReport;
    }

    public Bit getEnableEntryReport() {
        return this.enableEntryReport;
    }

    public Bit getEnableExitReport() {
        return this.enableExitReport;
    }

    public Bit getEnableDiagnosticReport() {
        return this.enableDiagnosticReport;
    }

    public ImpinjDirectionDiagnosticReportLevel getDiagnosticReportLevel() {
        return this.diagnosticReportLevel;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

