/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TVParameter;
import org.llrp.ltk.types.UnsignedInteger;

public class ROSpecID
extends TVParameter {
    public static final SignedShort TYPENUM = new SignedShort(9);
    private static final Logger LOGGER = Logger.getLogger(ROSpecID.class);
    protected UnsignedInteger rOSpecID;

    public ROSpecID() {
    }

    public ROSpecID(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ROSpecID(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public ROSpecID(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.rOSpecID == null) {
            LOGGER.warn(" rOSpecID not set");
            throw new MissingParameterException(" rOSpecID not set  for Parameter of Type ROSpecID");
        }
        resultBits.append(this.rOSpecID.encodeBinary());
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.rOSpecID == null) {
            LOGGER.warn(" rOSpecID not set");
            throw new MissingParameterException(" rOSpecID not set");
        }
        element.addContent(this.rOSpecID.encodeXML("ROSpecID", ns));
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.rOSpecID = new UnsignedInteger(binary, position, UnsignedInteger.length());
        position += UnsignedInteger.length();
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("ROSpecID", ns);
        if (temp != null) {
            this.rOSpecID = new UnsignedInteger(temp);
        }
        element.removeChild("ROSpecID", ns);
        if (element.getChildren().size() > 0) {
            String message = "ROSpecID has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setROSpecID(UnsignedInteger rOSpecID) {
        this.rOSpecID = rOSpecID;
    }

    public UnsignedInteger getROSpecID() {
        return this.rOSpecID;
    }

    public static Integer length() {
        int tempLength = 8;
        return tempLength += UnsignedInteger.length();
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "ROSpecID";
    }

    public String toString() {
        String result = "ROSpecID: ";
        result = result + ", rOSpecID: ";
        result = result + this.rOSpecID;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

