/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class TagSeenCount
extends TVParameter {
    public static final SignedShort TYPENUM = new SignedShort(8);
    private static final Logger LOGGER = Logger.getLogger(TagSeenCount.class);
    protected UnsignedShort tagCount;

    public TagSeenCount() {
    }

    public TagSeenCount(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public TagSeenCount(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public TagSeenCount(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.tagCount == null) {
            LOGGER.warn(" tagCount not set");
            throw new MissingParameterException(" tagCount not set  for Parameter of Type TagSeenCount");
        }
        resultBits.append(this.tagCount.encodeBinary());
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.tagCount == null) {
            LOGGER.warn(" tagCount not set");
            throw new MissingParameterException(" tagCount not set");
        }
        element.addContent(this.tagCount.encodeXML("TagCount", ns));
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.tagCount = new UnsignedShort(binary, position, UnsignedShort.length());
        position += UnsignedShort.length();
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("TagCount", ns);
        if (temp != null) {
            this.tagCount = new UnsignedShort(temp);
        }
        element.removeChild("TagCount", ns);
        if (element.getChildren().size() > 0) {
            String message = "TagSeenCount has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setTagCount(UnsignedShort tagCount) {
        this.tagCount = tagCount;
    }

    public UnsignedShort getTagCount() {
        return this.tagCount;
    }

    public static Integer length() {
        int tempLength = 8;
        return tempLength += UnsignedShort.length();
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "TagSeenCount";
    }

    public String toString() {
        String result = "TagSeenCount: ";
        result = result + ", tagCount: ";
        result = result + this.tagCount;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

