/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.util;

import java.io.BufferedInputStream;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.DOMInputImpl;
import org.llrp.ltk.generated.LLRPConstants;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class LLRPExternalResourceResolver
implements LSResourceResolver {
    private static final Logger LOGGER = Logger.getLogger(LLRPExternalResourceResolver.class);

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        LOGGER.info("resolveResource(" + type + "," + namespaceURI + "," + publicId + "," + systemId + "," + baseURI + ")");
        if (LLRPConstants.REDIRECT_EXTERNAL_RESOURCES.booleanValue()) {
            String targetPath = null;
            if ("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0/llrp.xsd".equalsIgnoreCase(systemId)) {
                targetPath = "org/llrp/ltk/llrp-1x0.xsd";
            } else if ("http://www.llrp.org/ltk/schema/core/encoding/binary/1.0/llrpdef.xsd".equalsIgnoreCase(systemId)) {
                targetPath = "llrpdef.xsd";
            } else if ("http://developer.impinj.com/ltk/schema/encoding/xml/1.42".equalsIgnoreCase(namespaceURI) || systemId.toLowerCase().startsWith("http://developer.impinj.com/ltk/schema/encoding/xml/1.42")) {
                targetPath = "org/llrp/ltk/Impinj.xsd";
            }
            if (targetPath != null) {
                DOMInputImpl lsInput = new DOMInputImpl();
                ClassLoader cl = this.getClass().getClassLoader();
                LOGGER.info("Redirecting resource " + systemId + " to " + targetPath);
                BufferedInputStream s = new BufferedInputStream(cl.getResourceAsStream(targetPath));
                lsInput.setByteStream(s);
                return lsInput;
            }
        }
        return null;
    }
}

