/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class HoppingEvent
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(247);
    private static final Logger LOGGER = Logger.getLogger(HoppingEvent.class);
    protected UnsignedShort hopTableID;
    protected UnsignedShort nextChannelIndex;

    public HoppingEvent() {
    }

    public HoppingEvent(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public HoppingEvent(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public HoppingEvent(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.hopTableID == null) {
            LOGGER.warn(" hopTableID not set");
            throw new MissingParameterException(" hopTableID not set  for Parameter of Type HoppingEvent");
        }
        resultBits.append(this.hopTableID.encodeBinary());
        if (this.nextChannelIndex == null) {
            LOGGER.warn(" nextChannelIndex not set");
            throw new MissingParameterException(" nextChannelIndex not set  for Parameter of Type HoppingEvent");
        }
        resultBits.append(this.nextChannelIndex.encodeBinary());
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.hopTableID == null) {
            LOGGER.warn(" hopTableID not set");
            throw new MissingParameterException(" hopTableID not set");
        }
        element.addContent(this.hopTableID.encodeXML("HopTableID", ns));
        if (this.nextChannelIndex == null) {
            LOGGER.warn(" nextChannelIndex not set");
            throw new MissingParameterException(" nextChannelIndex not set");
        }
        element.addContent(this.nextChannelIndex.encodeXML("NextChannelIndex", ns));
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.hopTableID = new UnsignedShort(binary, position, UnsignedShort.length());
        this.nextChannelIndex = new UnsignedShort(binary, position += UnsignedShort.length(), UnsignedShort.length());
        position += UnsignedShort.length();
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("HopTableID", ns);
        if (temp != null) {
            this.hopTableID = new UnsignedShort(temp);
        }
        element.removeChild("HopTableID", ns);
        temp = element.getChild("NextChannelIndex", ns);
        if (temp != null) {
            this.nextChannelIndex = new UnsignedShort(temp);
        }
        element.removeChild("NextChannelIndex", ns);
        if (element.getChildren().size() > 0) {
            String message = "HoppingEvent has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setHopTableID(UnsignedShort hopTableID) {
        this.hopTableID = hopTableID;
    }

    public void setNextChannelIndex(UnsignedShort nextChannelIndex) {
        this.nextChannelIndex = nextChannelIndex;
    }

    public UnsignedShort getHopTableID() {
        return this.hopTableID;
    }

    public UnsignedShort getNextChannelIndex() {
        return this.nextChannelIndex;
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "HoppingEvent";
    }

    public String toString() {
        String result = "HoppingEvent: ";
        result = result + ", hopTableID: ";
        result = result + this.hopTableID;
        result = result + ", nextChannelIndex: ";
        result = result + this.nextChannelIndex;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

