/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.enumerations.ROSpecEventType;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedInteger;

public class ROSpecEvent
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(249);
    private static final Logger LOGGER = Logger.getLogger(ROSpecEvent.class);
    protected ROSpecEventType eventType;
    protected UnsignedInteger rOSpecID;
    protected UnsignedInteger preemptingROSpecID;

    public ROSpecEvent() {
    }

    public ROSpecEvent(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ROSpecEvent(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public ROSpecEvent(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.eventType == null) {
            LOGGER.warn(" eventType not set");
            throw new MissingParameterException(" eventType not set  for Parameter of Type ROSpecEvent");
        }
        resultBits.append(this.eventType.encodeBinary());
        if (this.rOSpecID == null) {
            LOGGER.warn(" rOSpecID not set");
            throw new MissingParameterException(" rOSpecID not set  for Parameter of Type ROSpecEvent");
        }
        resultBits.append(this.rOSpecID.encodeBinary());
        if (this.preemptingROSpecID == null) {
            LOGGER.warn(" preemptingROSpecID not set");
            throw new MissingParameterException(" preemptingROSpecID not set  for Parameter of Type ROSpecEvent");
        }
        resultBits.append(this.preemptingROSpecID.encodeBinary());
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.eventType == null) {
            LOGGER.warn(" eventType not set");
            throw new MissingParameterException(" eventType not set");
        }
        element.addContent(this.eventType.encodeXML("EventType", ns));
        if (this.rOSpecID == null) {
            LOGGER.warn(" rOSpecID not set");
            throw new MissingParameterException(" rOSpecID not set");
        }
        element.addContent(this.rOSpecID.encodeXML("ROSpecID", ns));
        if (this.preemptingROSpecID == null) {
            LOGGER.warn(" preemptingROSpecID not set");
            throw new MissingParameterException(" preemptingROSpecID not set");
        }
        element.addContent(this.preemptingROSpecID.encodeXML("PreemptingROSpecID", ns));
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.eventType = new ROSpecEventType(binary, position, ROSpecEventType.length());
        this.rOSpecID = new UnsignedInteger(binary, position += ROSpecEventType.length(), UnsignedInteger.length());
        this.preemptingROSpecID = new UnsignedInteger(binary, position += UnsignedInteger.length(), UnsignedInteger.length());
        position += UnsignedInteger.length();
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("EventType", ns);
        if (temp != null) {
            this.eventType = new ROSpecEventType(temp);
        }
        element.removeChild("EventType", ns);
        temp = element.getChild("ROSpecID", ns);
        if (temp != null) {
            this.rOSpecID = new UnsignedInteger(temp);
        }
        element.removeChild("ROSpecID", ns);
        temp = element.getChild("PreemptingROSpecID", ns);
        if (temp != null) {
            this.preemptingROSpecID = new UnsignedInteger(temp);
        }
        element.removeChild("PreemptingROSpecID", ns);
        if (element.getChildren().size() > 0) {
            String message = "ROSpecEvent has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setEventType(ROSpecEventType eventType) {
        this.eventType = eventType;
    }

    public void setROSpecID(UnsignedInteger rOSpecID) {
        this.rOSpecID = rOSpecID;
    }

    public void setPreemptingROSpecID(UnsignedInteger preemptingROSpecID) {
        this.preemptingROSpecID = preemptingROSpecID;
    }

    public ROSpecEventType getEventType() {
        return this.eventType;
    }

    public UnsignedInteger getROSpecID() {
        return this.rOSpecID;
    }

    public UnsignedInteger getPreemptingROSpecID() {
        return this.preemptingROSpecID;
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "ROSpecEvent";
    }

    public String toString() {
        String result = "ROSpecEvent: ";
        result = result + ", eventType: ";
        result = result + this.eventType;
        result = result + ", rOSpecID: ";
        result = result + this.rOSpecID;
        result = result + ", preemptingROSpecID: ";
        result = result + this.preemptingROSpecID;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

