/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.enumerations.ROSpecStartTriggerType;
import org.llrp.ltk.generated.parameters.GPITriggerValue;
import org.llrp.ltk.generated.parameters.PeriodicTriggerValue;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class ROSpecStartTrigger
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(179);
    private static final Logger LOGGER = Logger.getLogger(ROSpecStartTrigger.class);
    protected ROSpecStartTriggerType rOSpecStartTriggerType;
    protected PeriodicTriggerValue periodicTriggerValue;
    protected GPITriggerValue gPITriggerValue;

    public ROSpecStartTrigger() {
    }

    public ROSpecStartTrigger(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ROSpecStartTrigger(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public ROSpecStartTrigger(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.rOSpecStartTriggerType == null) {
            LOGGER.warn(" rOSpecStartTriggerType not set");
            throw new MissingParameterException(" rOSpecStartTriggerType not set  for Parameter of Type ROSpecStartTrigger");
        }
        resultBits.append(this.rOSpecStartTriggerType.encodeBinary());
        if (this.periodicTriggerValue == null) {
            LOGGER.info(" periodicTriggerValue not set");
        } else {
            resultBits.append(this.periodicTriggerValue.encodeBinary());
        }
        if (this.gPITriggerValue == null) {
            LOGGER.info(" gPITriggerValue not set");
        } else {
            resultBits.append(this.gPITriggerValue.encodeBinary());
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.rOSpecStartTriggerType == null) {
            LOGGER.warn(" rOSpecStartTriggerType not set");
            throw new MissingParameterException(" rOSpecStartTriggerType not set");
        }
        element.addContent(this.rOSpecStartTriggerType.encodeXML("ROSpecStartTriggerType", ns));
        if (this.periodicTriggerValue == null) {
            LOGGER.info("periodicTriggerValue not set");
        } else {
            element.addContent(this.periodicTriggerValue.encodeXML(this.periodicTriggerValue.getClass().getSimpleName(), ns));
        }
        if (this.gPITriggerValue == null) {
            LOGGER.info("gPITriggerValue not set");
        } else {
            element.addContent(this.gPITriggerValue.encodeXML(this.gPITriggerValue.getClass().getSimpleName(), ns));
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.rOSpecStartTriggerType = new ROSpecStartTriggerType(binary, position, ROSpecStartTriggerType.length());
        position += ROSpecStartTriggerType.length();
        SignedShort type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace("ROSpecStartTrigger misses optional parameter of type PeriodicTriggerValue");
        }
        if (binary.get(position)) {
            ROSpecStartTrigger rOSpecStartTrigger = this;
            tempLength = rOSpecStartTrigger.periodicTriggerValue.length();
        }
        if (type != null && type.equals(PeriodicTriggerValue.TYPENUM)) {
            this.periodicTriggerValue = new PeriodicTriggerValue(binary, position, tempLength);
            position += tempLength;
            LOGGER.trace(" periodicTriggerValue is instantiated with PeriodicTriggerValue with length" + tempLength);
        } else {
            LOGGER.trace("ROSpecStartTrigger misses optional parameter of type PeriodicTriggerValue");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace("ROSpecStartTrigger misses optional parameter of type GPITriggerValue");
        }
        if (binary.get(position)) {
            ROSpecStartTrigger rOSpecStartTrigger = this;
            tempLength = rOSpecStartTrigger.gPITriggerValue.length();
        }
        if (type != null && type.equals(GPITriggerValue.TYPENUM)) {
            this.gPITriggerValue = new GPITriggerValue(binary, position, tempLength);
            position += tempLength;
            LOGGER.trace(" gPITriggerValue is instantiated with GPITriggerValue with length" + tempLength);
        } else {
            LOGGER.trace("ROSpecStartTrigger misses optional parameter of type GPITriggerValue");
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("ROSpecStartTriggerType", ns);
        if (temp != null) {
            this.rOSpecStartTriggerType = new ROSpecStartTriggerType(temp);
        }
        element.removeChild("ROSpecStartTriggerType", ns);
        temp = element.getChild("PeriodicTriggerValue", ns);
        if (temp != null) {
            this.periodicTriggerValue = new PeriodicTriggerValue(temp);
            LOGGER.info("setting parameter periodicTriggerValue for parameter ROSpecStartTrigger");
        }
        if (temp == null) {
            LOGGER.trace("ROSpecStartTrigger misses optional parameter of type periodicTriggerValue");
        }
        element.removeChild("PeriodicTriggerValue", ns);
        temp = element.getChild("GPITriggerValue", ns);
        if (temp != null) {
            this.gPITriggerValue = new GPITriggerValue(temp);
            LOGGER.info("setting parameter gPITriggerValue for parameter ROSpecStartTrigger");
        }
        if (temp == null) {
            LOGGER.trace("ROSpecStartTrigger misses optional parameter of type gPITriggerValue");
        }
        element.removeChild("GPITriggerValue", ns);
        if (element.getChildren().size() > 0) {
            String message = "ROSpecStartTrigger has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setROSpecStartTriggerType(ROSpecStartTriggerType rOSpecStartTriggerType) {
        this.rOSpecStartTriggerType = rOSpecStartTriggerType;
    }

    public void setPeriodicTriggerValue(PeriodicTriggerValue periodicTriggerValue) {
        this.periodicTriggerValue = periodicTriggerValue;
    }

    public void setGPITriggerValue(GPITriggerValue gPITriggerValue) {
        this.gPITriggerValue = gPITriggerValue;
    }

    public ROSpecStartTriggerType getROSpecStartTriggerType() {
        return this.rOSpecStartTriggerType;
    }

    public PeriodicTriggerValue getPeriodicTriggerValue() {
        return this.periodicTriggerValue;
    }

    public GPITriggerValue getGPITriggerValue() {
        return this.gPITriggerValue;
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "ROSpecStartTrigger";
    }

    public String toString() {
        String result = "ROSpecStartTrigger: ";
        result = result + ", rOSpecStartTriggerType: ";
        result = result + this.rOSpecStartTriggerType;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

