/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import org.jdom.Content;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.Verifier;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPType;
import org.llrp.ltk.types.UnsignedShort;

public class UTF8String
extends LLRPType {
    protected static Integer LENGTH = 8;
    protected String string;

    protected UTF8String() {
        this.string = "";
    }

    public UTF8String(LLRPBitList subList) {
        this.decodeBinary(subList);
    }

    public UTF8String(Element element) {
        this.decodeXML(element);
    }

    public UTF8String(String string) {
        this.string = string;
    }

    public UTF8String(LLRPBitList bitList, int bitIndex, int length) {
        this(bitList.subList(bitIndex, length));
    }

    @Override
    public void decodeBinary(LLRPBitList list) {
        LLRPBitList subList = list.subList(UnsignedShort.length(), list.length() - UnsignedShort.length());
        byte[] bigBytes = subList.toByteArray();
        byte[] bytes = new byte[bigBytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = bigBytes[i];
        }
        this.string = new String(bytes);
    }

    public static int length() {
        return 8;
    }

    @Override
    public LLRPBitList encodeBinary() {
        LLRPBitList result = new LLRPBitList();
        result.append(new UnsignedShort(this.string.toCharArray().length).encodeBinary());
        byte[] bytes = this.string.getBytes();
        byte[] bigBytes = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            bigBytes[i] = bytes[i];
        }
        result.append(new LLRPBitList(bigBytes));
        return result;
    }

    public boolean equals(LLRPType other) {
        UTF8String u = (UTF8String)other;
        return this.string.equals(u.string);
    }

    public Integer getByteLength() {
        return this.string.length() / 8;
    }

    @Override
    public void decodeXML(Element element) {
        this.string = element.getText().trim();
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        try {
            element.setContent(new Text(this.string));
        }
        catch (IllegalDataException e) {
            StringBuffer buffer = new StringBuffer();
            int len = this.string.length();
            for (int i = 0; i < len; ++i) {
                char ch = this.string.charAt(i);
                if (!Verifier.isXMLCharacter(ch)) continue;
                buffer.append(this.string.charAt(i));
            }
            element.setContent(new Text(buffer.toString()));
        }
        return element;
    }

    @Override
    public String toString() {
        return this.string;
    }

    @Override
    public String toString(int radix) {
        return this.toString();
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    @Override
    public boolean inRange(String valueString) {
        return true;
    }
}

