/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPType;
import org.llrp.ltk.types.SignedInteger;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class UnsignedIntegerArray
extends LLRPType {
    private UnsignedInteger[] integers;

    public UnsignedIntegerArray(UnsignedInteger[] ints) {
        this.integers = (UnsignedInteger[])ints.clone();
    }

    public UnsignedIntegerArray(Element element) {
        this.decodeXML(element);
    }

    public UnsignedIntegerArray(int length) {
        this.integers = new UnsignedInteger[length];
    }

    public UnsignedIntegerArray(LLRPBitList bits) {
        this.decodeBinary(bits);
    }

    public UnsignedIntegerArray(LLRPBitList bitList, int bitIndex, int length) {
        this(bitList.subList(bitIndex, length));
    }

    public UnsignedIntegerArray(String string) {
        Element element = new Element("foo", "ns");
        element.setText(string);
        this.decodeXML(element);
    }

    public UnsignedIntegerArray() {
        this.integers = new UnsignedInteger[0];
    }

    @Override
    public LLRPBitList encodeBinary() {
        LLRPBitList result = new LLRPBitList();
        result.append(new UnsignedShort(this.integers.length).encodeBinary());
        for (int i = 0; i < this.integers.length; ++i) {
            result.append(this.integers[i].encodeBinary());
        }
        return result;
    }

    public int getByteLength() {
        return this.integers.length * 2;
    }

    public static int length() {
        return UnsignedInteger.length();
    }

    @Override
    public void decodeBinary(LLRPBitList list) {
        Integer length = new SignedShort(list.subList(0, SignedShort.length())).toInteger();
        this.integers = new UnsignedInteger[length.intValue()];
        for (int i = 0; i < length; ++i) {
            this.integers[i] = new UnsignedInteger(list.subList(i * UnsignedInteger.length() + SignedShort.length(), SignedInteger.length()));
        }
    }

    public UnsignedInteger get(int i) {
        return this.integers[i];
    }

    public void set(int i, UnsignedInteger b) {
        if (i < 0 || i > this.integers.length) {
            return;
        }
        this.integers[i] = b;
    }

    public int size() {
        return this.integers.length;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        element.setContent(new Text(this.toString()));
        return element;
    }

    @Override
    public void decodeXML(Element element) {
        String text = element.getText().trim();
        if (!text.equals("")) {
            String[] strings = text.split("\\s+");
            this.integers = new UnsignedInteger[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                this.integers[i] = new UnsignedInteger(strings[i]);
            }
        } else {
            this.integers = new UnsignedInteger[0];
        }
    }

    public void add(UnsignedInteger aInteger) {
        UnsignedInteger[] newIntegers = new UnsignedInteger[this.integers.length + 1];
        System.arraycopy(this.integers, 0, newIntegers, 0, this.integers.length);
        newIntegers[this.integers.length] = aInteger;
        this.integers = newIntegers;
    }

    @Override
    public String toString(int radix) {
        String s = "";
        for (UnsignedInteger b : this.integers) {
            s = s + b.toString(radix);
        }
        return s;
    }

    @Override
    public String toString() {
        String s = "";
        for (UnsignedInteger b : this.integers) {
            s = s + " ";
            s = s + b.toLong();
        }
        s = s.replaceFirst(" ", "");
        return s;
    }

    @Override
    public boolean inRange(String valueString) {
        String[] strings = valueString.trim().split("\\s+");
        for (int i = 0; i < strings.length; ++i) {
            try {
                new UnsignedInteger(strings[i]);
                continue;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(LLRPType other) {
        if (!(other instanceof UnsignedIntegerArray)) {
            throw new IllegalArgumentException("Argument not UnsignedIntegerArray");
        }
        UnsignedIntegerArray ba = (UnsignedIntegerArray)other;
        if (ba.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.integers.length; ++i) {
            if (ba.get(i).equals(this.get(i))) continue;
            return false;
        }
        return true;
    }
}

