/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.enumerations;

import java.math.BigInteger;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPEnumeration;

public class AccessSpecState
extends Bit
implements LLRPEnumeration {
    public static final int Disabled = 0;
    public static final int Active = 1;
    Logger logger = Logger.getLogger(AccessSpecState.class);

    public AccessSpecState() {
        super(0);
    }

    public AccessSpecState(int value) {
        super(value);
        if (!this.isValidValue(value)) {
            throw new IllegalArgumentException("Value not allowed");
        }
    }

    public AccessSpecState(Element element) {
        this(element.getText());
    }

    public AccessSpecState(String name) {
        if (!this.isValidName(name.trim())) {
            throw new IllegalArgumentException("Name not allowed");
        }
        this.value = this.getValue(name.trim()) != 0;
        this.signed = false;
    }

    public AccessSpecState(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public AccessSpecState(LLRPBitList list) {
        this.decodeBinary(list);
        if (!this.isValidValue(new Integer(this.toInteger()))) {
            throw new IllegalArgumentException("Value not allowed");
        }
    }

    @Override
    public final void set(String name) {
        if (!this.isValidName(name)) {
            throw new IllegalArgumentException("name not allowed");
        }
        this.value = this.getValue(name) != 0;
    }

    @Override
    public final void set(int value) {
        if (!this.isValidValue(value)) {
            throw new IllegalArgumentException("value not allowed");
        }
        this.value = value == 1;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        element.setContent((Content)new Text(this.toString()));
        return element;
    }

    @Override
    public String toString() {
        return this.getName(this.toInteger());
    }

    @Override
    public boolean isValidValue(int value) {
        switch (value) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final int getValue(String name) {
        if (name.equalsIgnoreCase("Disabled")) {
            return 0;
        }
        if (name.equalsIgnoreCase("Active")) {
            return 1;
        }
        return -1;
    }

    @Override
    public final String getName(int value) {
        if (0 == value) {
            return "Disabled";
        }
        if (1 == value) {
            return "Active";
        }
        return "";
    }

    @Override
    public boolean isValidName(String name) {
        if (name.equals("Disabled")) {
            return true;
        }
        return name.equals("Active");
    }

    public static int length() {
        return Bit.length();
    }

    private final String getName(BigInteger value) {
        this.logger.warn((Object)("AccessSpecState must convert BigInteger " + value + " to Integer value " + value.intValue()));
        return this.getName(value.intValue());
    }

    private final boolean isValidValue(BigInteger value) {
        this.logger.warn((Object)("AccessSpecState must convert BigInteger " + value + " to Integer value " + value.intValue()));
        return this.isValidValue(value.intValue());
    }
}

