/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.enumerations.AISpecEventType;
import org.llrp.ltk.generated.interfaces.AirProtocolSingulationDetails;
import org.llrp.ltk.generated.parameters.C1G2SingulationDetails;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class AISpecEvent
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(254);
    private static final Logger LOGGER = Logger.getLogger(AISpecEvent.class);
    protected AISpecEventType eventType;
    protected UnsignedInteger rOSpecID;
    protected UnsignedShort specIndex;
    protected AirProtocolSingulationDetails airProtocolSingulationDetails;

    public AISpecEvent() {
    }

    public AISpecEvent(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public AISpecEvent(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public AISpecEvent(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.eventType == null) {
            LOGGER.warn((Object)" eventType not set");
            throw new MissingParameterException(" eventType not set  for Parameter of Type AISpecEvent");
        }
        resultBits.append(this.eventType.encodeBinary());
        if (this.rOSpecID == null) {
            LOGGER.warn((Object)" rOSpecID not set");
            throw new MissingParameterException(" rOSpecID not set  for Parameter of Type AISpecEvent");
        }
        resultBits.append(this.rOSpecID.encodeBinary());
        if (this.specIndex == null) {
            LOGGER.warn((Object)" specIndex not set");
            throw new MissingParameterException(" specIndex not set  for Parameter of Type AISpecEvent");
        }
        resultBits.append(this.specIndex.encodeBinary());
        if (this.airProtocolSingulationDetails == null) {
            LOGGER.info((Object)" airProtocolSingulationDetails not set");
        } else {
            resultBits.append(this.airProtocolSingulationDetails.encodeBinary());
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.eventType == null) {
            LOGGER.warn((Object)" eventType not set");
            throw new MissingParameterException(" eventType not set");
        }
        element.addContent(this.eventType.encodeXML("EventType", ns));
        if (this.rOSpecID == null) {
            LOGGER.warn((Object)" rOSpecID not set");
            throw new MissingParameterException(" rOSpecID not set");
        }
        element.addContent(this.rOSpecID.encodeXML("ROSpecID", ns));
        if (this.specIndex == null) {
            LOGGER.warn((Object)" specIndex not set");
            throw new MissingParameterException(" specIndex not set");
        }
        element.addContent(this.specIndex.encodeXML("SpecIndex", ns));
        if (this.airProtocolSingulationDetails == null) {
            LOGGER.info((Object)"airProtocolSingulationDetails not set");
        } else {
            element.addContent(this.airProtocolSingulationDetails.encodeXML(this.airProtocolSingulationDetails.getClass().getSimpleName(), ns));
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.eventType = new AISpecEventType(binary, position, AISpecEventType.length());
        this.rOSpecID = new UnsignedInteger(binary, position += AISpecEventType.length(), UnsignedInteger.length());
        this.specIndex = new UnsignedShort(binary, position += UnsignedInteger.length(), UnsignedShort.length());
        position += UnsignedShort.length();
        SignedShort type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace((Object)"AISpecEvent misses optional parameter of type AirProtocolSingulationDetails");
        }
        boolean found = false;
        LOGGER.trace((Object)"decoding choice type AirProtocolSingulationDetails ");
        if (binary.get(position)) {
            tempLength = C1G2SingulationDetails.length();
        }
        if (type != null && type.equals(C1G2SingulationDetails.TYPENUM)) {
            this.airProtocolSingulationDetails = new C1G2SingulationDetails(binary, position, tempLength);
            LOGGER.trace((Object)(" airProtocolSingulationDetails instatiated to C1G2SingulationDetails with length " + tempLength));
            position += tempLength;
            found = true;
        }
        if (!found) {
            LOGGER.trace((Object)"AISpecEvent misses optional parameter of type AirProtocolSingulationDetails");
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("EventType", ns);
        if (temp != null) {
            this.eventType = new AISpecEventType(temp);
        }
        element.removeChild("EventType", ns);
        temp = element.getChild("ROSpecID", ns);
        if (temp != null) {
            this.rOSpecID = new UnsignedInteger(temp);
        }
        element.removeChild("ROSpecID", ns);
        temp = element.getChild("SpecIndex", ns);
        if (temp != null) {
            this.specIndex = new UnsignedShort(temp);
        }
        element.removeChild("SpecIndex", ns);
        boolean found = false;
        LOGGER.trace((Object)"decoding choice type AirProtocolSingulationDetails ");
        temp = element.getChild("C1G2SingulationDetails", ns);
        if (temp != null) {
            this.airProtocolSingulationDetails = new C1G2SingulationDetails(temp);
            LOGGER.trace((Object)" airProtocolSingulationDetails instatiated to C1G2SingulationDetails with");
            found = true;
        }
        element.removeChild("C1G2SingulationDetails", ns);
        if (!found) {
            LOGGER.trace((Object)"AISpecEvent misses optional parameter of type airProtocolSingulationDetailsList");
        }
        if (element.getChildren().size() > 0) {
            String message = "AISpecEvent has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setEventType(AISpecEventType eventType) {
        this.eventType = eventType;
    }

    public void setROSpecID(UnsignedInteger rOSpecID) {
        this.rOSpecID = rOSpecID;
    }

    public void setSpecIndex(UnsignedShort specIndex) {
        this.specIndex = specIndex;
    }

    public void setAirProtocolSingulationDetails(AirProtocolSingulationDetails airProtocolSingulationDetails) {
        this.airProtocolSingulationDetails = airProtocolSingulationDetails;
    }

    public AISpecEventType getEventType() {
        return this.eventType;
    }

    public UnsignedInteger getROSpecID() {
        return this.rOSpecID;
    }

    public UnsignedShort getSpecIndex() {
        return this.specIndex;
    }

    public AirProtocolSingulationDetails getAirProtocolSingulationDetails() {
        return this.airProtocolSingulationDetails;
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "AISpecEvent";
    }

    public String toString() {
        String result = "AISpecEvent: ";
        result = result + ", eventType: ";
        result = result + this.eventType;
        result = result + ", rOSpecID: ";
        result = result + this.rOSpecID;
        result = result + ", specIndex: ";
        result = result + this.specIndex;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

