/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedByte;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class LLRPCapabilities
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(142);
    private static final Logger LOGGER = Logger.getLogger(LLRPCapabilities.class);
    protected Bit canDoRFSurvey;
    protected Bit canReportBufferFillWarning;
    protected Bit supportsClientRequestOpSpec;
    protected Bit canDoTagInventoryStateAwareSingulation;
    protected Bit supportsEventAndReportHolding;
    protected BitList reserved0 = new BitList(3);
    protected UnsignedByte maxNumPriorityLevelsSupported;
    protected UnsignedShort clientRequestOpSpecTimeout;
    protected UnsignedInteger maxNumROSpecs;
    protected UnsignedInteger maxNumSpecsPerROSpec;
    protected UnsignedInteger maxNumInventoryParameterSpecsPerAISpec;
    protected UnsignedInteger maxNumAccessSpecs;
    protected UnsignedInteger maxNumOpSpecsPerAccessSpec;

    public LLRPCapabilities() {
    }

    public LLRPCapabilities(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public LLRPCapabilities(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public LLRPCapabilities(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.canDoRFSurvey == null) {
            LOGGER.warn((Object)" canDoRFSurvey not set");
            throw new MissingParameterException(" canDoRFSurvey not set  for Parameter of Type LLRPCapabilities");
        }
        resultBits.append(this.canDoRFSurvey.encodeBinary());
        if (this.canReportBufferFillWarning == null) {
            LOGGER.warn((Object)" canReportBufferFillWarning not set");
            throw new MissingParameterException(" canReportBufferFillWarning not set  for Parameter of Type LLRPCapabilities");
        }
        resultBits.append(this.canReportBufferFillWarning.encodeBinary());
        if (this.supportsClientRequestOpSpec == null) {
            LOGGER.warn((Object)" supportsClientRequestOpSpec not set");
            throw new MissingParameterException(" supportsClientRequestOpSpec not set  for Parameter of Type LLRPCapabilities");
        }
        resultBits.append(this.supportsClientRequestOpSpec.encodeBinary());
        if (this.canDoTagInventoryStateAwareSingulation == null) {
            LOGGER.warn((Object)" canDoTagInventoryStateAwareSingulation not set");
            throw new MissingParameterException(" canDoTagInventoryStateAwareSingulation not set  for Parameter of Type LLRPCapabilities");
        }
        resultBits.append(this.canDoTagInventoryStateAwareSingulation.encodeBinary());
        if (this.supportsEventAndReportHolding == null) {
            LOGGER.warn((Object)" supportsEventAndReportHolding not set");
            throw new MissingParameterException(" supportsEventAndReportHolding not set  for Parameter of Type LLRPCapabilities");
        }
        resultBits.append(this.supportsEventAndReportHolding.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        if (this.maxNumPriorityLevelsSupported == null) {
            LOGGER.warn((Object)" maxNumPriorityLevelsSupported not set");
            throw new MissingParameterException(" maxNumPriorityLevelsSupported not set  for Parameter of Type LLRPCapabilities");
        }
        resultBits.append(this.maxNumPriorityLevelsSupported.encodeBinary());
        if (this.clientRequestOpSpecTimeout == null) {
            LOGGER.warn((Object)" clientRequestOpSpecTimeout not set");
            throw new MissingParameterException(" clientRequestOpSpecTimeout not set  for Parameter of Type LLRPCapabilities");
        }
        resultBits.append(this.clientRequestOpSpecTimeout.encodeBinary());
        if (this.maxNumROSpecs == null) {
            LOGGER.warn((Object)" maxNumROSpecs not set");
            throw new MissingParameterException(" maxNumROSpecs not set  for Parameter of Type LLRPCapabilities");
        }
        resultBits.append(this.maxNumROSpecs.encodeBinary());
        if (this.maxNumSpecsPerROSpec == null) {
            LOGGER.warn((Object)" maxNumSpecsPerROSpec not set");
            throw new MissingParameterException(" maxNumSpecsPerROSpec not set  for Parameter of Type LLRPCapabilities");
        }
        resultBits.append(this.maxNumSpecsPerROSpec.encodeBinary());
        if (this.maxNumInventoryParameterSpecsPerAISpec == null) {
            LOGGER.warn((Object)" maxNumInventoryParameterSpecsPerAISpec not set");
            throw new MissingParameterException(" maxNumInventoryParameterSpecsPerAISpec not set  for Parameter of Type LLRPCapabilities");
        }
        resultBits.append(this.maxNumInventoryParameterSpecsPerAISpec.encodeBinary());
        if (this.maxNumAccessSpecs == null) {
            LOGGER.warn((Object)" maxNumAccessSpecs not set");
            throw new MissingParameterException(" maxNumAccessSpecs not set  for Parameter of Type LLRPCapabilities");
        }
        resultBits.append(this.maxNumAccessSpecs.encodeBinary());
        if (this.maxNumOpSpecsPerAccessSpec == null) {
            LOGGER.warn((Object)" maxNumOpSpecsPerAccessSpec not set");
            throw new MissingParameterException(" maxNumOpSpecsPerAccessSpec not set  for Parameter of Type LLRPCapabilities");
        }
        resultBits.append(this.maxNumOpSpecsPerAccessSpec.encodeBinary());
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.canDoRFSurvey == null) {
            LOGGER.warn((Object)" canDoRFSurvey not set");
            throw new MissingParameterException(" canDoRFSurvey not set");
        }
        element.addContent(this.canDoRFSurvey.encodeXML("CanDoRFSurvey", ns));
        if (this.canReportBufferFillWarning == null) {
            LOGGER.warn((Object)" canReportBufferFillWarning not set");
            throw new MissingParameterException(" canReportBufferFillWarning not set");
        }
        element.addContent(this.canReportBufferFillWarning.encodeXML("CanReportBufferFillWarning", ns));
        if (this.supportsClientRequestOpSpec == null) {
            LOGGER.warn((Object)" supportsClientRequestOpSpec not set");
            throw new MissingParameterException(" supportsClientRequestOpSpec not set");
        }
        element.addContent(this.supportsClientRequestOpSpec.encodeXML("SupportsClientRequestOpSpec", ns));
        if (this.canDoTagInventoryStateAwareSingulation == null) {
            LOGGER.warn((Object)" canDoTagInventoryStateAwareSingulation not set");
            throw new MissingParameterException(" canDoTagInventoryStateAwareSingulation not set");
        }
        element.addContent(this.canDoTagInventoryStateAwareSingulation.encodeXML("CanDoTagInventoryStateAwareSingulation", ns));
        if (this.supportsEventAndReportHolding == null) {
            LOGGER.warn((Object)" supportsEventAndReportHolding not set");
            throw new MissingParameterException(" supportsEventAndReportHolding not set");
        }
        element.addContent(this.supportsEventAndReportHolding.encodeXML("SupportsEventAndReportHolding", ns));
        if (this.maxNumPriorityLevelsSupported == null) {
            LOGGER.warn((Object)" maxNumPriorityLevelsSupported not set");
            throw new MissingParameterException(" maxNumPriorityLevelsSupported not set");
        }
        element.addContent(this.maxNumPriorityLevelsSupported.encodeXML("MaxNumPriorityLevelsSupported", ns));
        if (this.clientRequestOpSpecTimeout == null) {
            LOGGER.warn((Object)" clientRequestOpSpecTimeout not set");
            throw new MissingParameterException(" clientRequestOpSpecTimeout not set");
        }
        element.addContent(this.clientRequestOpSpecTimeout.encodeXML("ClientRequestOpSpecTimeout", ns));
        if (this.maxNumROSpecs == null) {
            LOGGER.warn((Object)" maxNumROSpecs not set");
            throw new MissingParameterException(" maxNumROSpecs not set");
        }
        element.addContent(this.maxNumROSpecs.encodeXML("MaxNumROSpecs", ns));
        if (this.maxNumSpecsPerROSpec == null) {
            LOGGER.warn((Object)" maxNumSpecsPerROSpec not set");
            throw new MissingParameterException(" maxNumSpecsPerROSpec not set");
        }
        element.addContent(this.maxNumSpecsPerROSpec.encodeXML("MaxNumSpecsPerROSpec", ns));
        if (this.maxNumInventoryParameterSpecsPerAISpec == null) {
            LOGGER.warn((Object)" maxNumInventoryParameterSpecsPerAISpec not set");
            throw new MissingParameterException(" maxNumInventoryParameterSpecsPerAISpec not set");
        }
        element.addContent(this.maxNumInventoryParameterSpecsPerAISpec.encodeXML("MaxNumInventoryParameterSpecsPerAISpec", ns));
        if (this.maxNumAccessSpecs == null) {
            LOGGER.warn((Object)" maxNumAccessSpecs not set");
            throw new MissingParameterException(" maxNumAccessSpecs not set");
        }
        element.addContent(this.maxNumAccessSpecs.encodeXML("MaxNumAccessSpecs", ns));
        if (this.maxNumOpSpecsPerAccessSpec == null) {
            LOGGER.warn((Object)" maxNumOpSpecsPerAccessSpec not set");
            throw new MissingParameterException(" maxNumOpSpecsPerAccessSpec not set");
        }
        element.addContent(this.maxNumOpSpecsPerAccessSpec.encodeXML("MaxNumOpSpecsPerAccessSpec", ns));
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.canDoRFSurvey = new Bit(binary, position, Bit.length());
        this.canReportBufferFillWarning = new Bit(binary, position += Bit.length(), Bit.length());
        this.supportsClientRequestOpSpec = new Bit(binary, position += Bit.length(), Bit.length());
        this.canDoTagInventoryStateAwareSingulation = new Bit(binary, position += Bit.length(), Bit.length());
        this.supportsEventAndReportHolding = new Bit(binary, position += Bit.length(), Bit.length());
        position += Bit.length();
        this.maxNumPriorityLevelsSupported = new UnsignedByte(binary, position += this.reserved0.length(), UnsignedByte.length());
        this.clientRequestOpSpecTimeout = new UnsignedShort(binary, position += UnsignedByte.length(), UnsignedShort.length());
        this.maxNumROSpecs = new UnsignedInteger(binary, position += UnsignedShort.length(), UnsignedInteger.length());
        this.maxNumSpecsPerROSpec = new UnsignedInteger(binary, position += UnsignedInteger.length(), UnsignedInteger.length());
        this.maxNumInventoryParameterSpecsPerAISpec = new UnsignedInteger(binary, position += UnsignedInteger.length(), UnsignedInteger.length());
        this.maxNumAccessSpecs = new UnsignedInteger(binary, position += UnsignedInteger.length(), UnsignedInteger.length());
        this.maxNumOpSpecsPerAccessSpec = new UnsignedInteger(binary, position += UnsignedInteger.length(), UnsignedInteger.length());
        position += UnsignedInteger.length();
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("CanDoRFSurvey", ns);
        if (temp != null) {
            this.canDoRFSurvey = new Bit(temp);
        }
        element.removeChild("CanDoRFSurvey", ns);
        temp = element.getChild("CanReportBufferFillWarning", ns);
        if (temp != null) {
            this.canReportBufferFillWarning = new Bit(temp);
        }
        element.removeChild("CanReportBufferFillWarning", ns);
        temp = element.getChild("SupportsClientRequestOpSpec", ns);
        if (temp != null) {
            this.supportsClientRequestOpSpec = new Bit(temp);
        }
        element.removeChild("SupportsClientRequestOpSpec", ns);
        temp = element.getChild("CanDoTagInventoryStateAwareSingulation", ns);
        if (temp != null) {
            this.canDoTagInventoryStateAwareSingulation = new Bit(temp);
        }
        element.removeChild("CanDoTagInventoryStateAwareSingulation", ns);
        temp = element.getChild("SupportsEventAndReportHolding", ns);
        if (temp != null) {
            this.supportsEventAndReportHolding = new Bit(temp);
        }
        element.removeChild("SupportsEventAndReportHolding", ns);
        temp = element.getChild("MaxNumPriorityLevelsSupported", ns);
        if (temp != null) {
            this.maxNumPriorityLevelsSupported = new UnsignedByte(temp);
        }
        element.removeChild("MaxNumPriorityLevelsSupported", ns);
        temp = element.getChild("ClientRequestOpSpecTimeout", ns);
        if (temp != null) {
            this.clientRequestOpSpecTimeout = new UnsignedShort(temp);
        }
        element.removeChild("ClientRequestOpSpecTimeout", ns);
        temp = element.getChild("MaxNumROSpecs", ns);
        if (temp != null) {
            this.maxNumROSpecs = new UnsignedInteger(temp);
        }
        element.removeChild("MaxNumROSpecs", ns);
        temp = element.getChild("MaxNumSpecsPerROSpec", ns);
        if (temp != null) {
            this.maxNumSpecsPerROSpec = new UnsignedInteger(temp);
        }
        element.removeChild("MaxNumSpecsPerROSpec", ns);
        temp = element.getChild("MaxNumInventoryParameterSpecsPerAISpec", ns);
        if (temp != null) {
            this.maxNumInventoryParameterSpecsPerAISpec = new UnsignedInteger(temp);
        }
        element.removeChild("MaxNumInventoryParameterSpecsPerAISpec", ns);
        temp = element.getChild("MaxNumAccessSpecs", ns);
        if (temp != null) {
            this.maxNumAccessSpecs = new UnsignedInteger(temp);
        }
        element.removeChild("MaxNumAccessSpecs", ns);
        temp = element.getChild("MaxNumOpSpecsPerAccessSpec", ns);
        if (temp != null) {
            this.maxNumOpSpecsPerAccessSpec = new UnsignedInteger(temp);
        }
        element.removeChild("MaxNumOpSpecsPerAccessSpec", ns);
        if (element.getChildren().size() > 0) {
            String message = "LLRPCapabilities has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setCanDoRFSurvey(Bit canDoRFSurvey) {
        this.canDoRFSurvey = canDoRFSurvey;
    }

    public void setCanReportBufferFillWarning(Bit canReportBufferFillWarning) {
        this.canReportBufferFillWarning = canReportBufferFillWarning;
    }

    public void setSupportsClientRequestOpSpec(Bit supportsClientRequestOpSpec) {
        this.supportsClientRequestOpSpec = supportsClientRequestOpSpec;
    }

    public void setCanDoTagInventoryStateAwareSingulation(Bit canDoTagInventoryStateAwareSingulation) {
        this.canDoTagInventoryStateAwareSingulation = canDoTagInventoryStateAwareSingulation;
    }

    public void setSupportsEventAndReportHolding(Bit supportsEventAndReportHolding) {
        this.supportsEventAndReportHolding = supportsEventAndReportHolding;
    }

    public void setMaxNumPriorityLevelsSupported(UnsignedByte maxNumPriorityLevelsSupported) {
        this.maxNumPriorityLevelsSupported = maxNumPriorityLevelsSupported;
    }

    public void setClientRequestOpSpecTimeout(UnsignedShort clientRequestOpSpecTimeout) {
        this.clientRequestOpSpecTimeout = clientRequestOpSpecTimeout;
    }

    public void setMaxNumROSpecs(UnsignedInteger maxNumROSpecs) {
        this.maxNumROSpecs = maxNumROSpecs;
    }

    public void setMaxNumSpecsPerROSpec(UnsignedInteger maxNumSpecsPerROSpec) {
        this.maxNumSpecsPerROSpec = maxNumSpecsPerROSpec;
    }

    public void setMaxNumInventoryParameterSpecsPerAISpec(UnsignedInteger maxNumInventoryParameterSpecsPerAISpec) {
        this.maxNumInventoryParameterSpecsPerAISpec = maxNumInventoryParameterSpecsPerAISpec;
    }

    public void setMaxNumAccessSpecs(UnsignedInteger maxNumAccessSpecs) {
        this.maxNumAccessSpecs = maxNumAccessSpecs;
    }

    public void setMaxNumOpSpecsPerAccessSpec(UnsignedInteger maxNumOpSpecsPerAccessSpec) {
        this.maxNumOpSpecsPerAccessSpec = maxNumOpSpecsPerAccessSpec;
    }

    public Bit getCanDoRFSurvey() {
        return this.canDoRFSurvey;
    }

    public Bit getCanReportBufferFillWarning() {
        return this.canReportBufferFillWarning;
    }

    public Bit getSupportsClientRequestOpSpec() {
        return this.supportsClientRequestOpSpec;
    }

    public Bit getCanDoTagInventoryStateAwareSingulation() {
        return this.canDoTagInventoryStateAwareSingulation;
    }

    public Bit getSupportsEventAndReportHolding() {
        return this.supportsEventAndReportHolding;
    }

    public UnsignedByte getMaxNumPriorityLevelsSupported() {
        return this.maxNumPriorityLevelsSupported;
    }

    public UnsignedShort getClientRequestOpSpecTimeout() {
        return this.clientRequestOpSpecTimeout;
    }

    public UnsignedInteger getMaxNumROSpecs() {
        return this.maxNumROSpecs;
    }

    public UnsignedInteger getMaxNumSpecsPerROSpec() {
        return this.maxNumSpecsPerROSpec;
    }

    public UnsignedInteger getMaxNumInventoryParameterSpecsPerAISpec() {
        return this.maxNumInventoryParameterSpecsPerAISpec;
    }

    public UnsignedInteger getMaxNumAccessSpecs() {
        return this.maxNumAccessSpecs;
    }

    public UnsignedInteger getMaxNumOpSpecsPerAccessSpec() {
        return this.maxNumOpSpecsPerAccessSpec;
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "LLRPCapabilities";
    }

    public String toString() {
        String result = "LLRPCapabilities: ";
        result = result + ", canDoRFSurvey: ";
        result = result + this.canDoRFSurvey;
        result = result + ", canReportBufferFillWarning: ";
        result = result + this.canReportBufferFillWarning;
        result = result + ", supportsClientRequestOpSpec: ";
        result = result + this.supportsClientRequestOpSpec;
        result = result + ", canDoTagInventoryStateAwareSingulation: ";
        result = result + this.canDoTagInventoryStateAwareSingulation;
        result = result + ", supportsEventAndReportHolding: ";
        result = result + this.supportsEventAndReportHolding;
        result = result + ", maxNumPriorityLevelsSupported: ";
        result = result + this.maxNumPriorityLevelsSupported;
        result = result + ", clientRequestOpSpecTimeout: ";
        result = result + this.clientRequestOpSpecTimeout;
        result = result + ", maxNumROSpecs: ";
        result = result + this.maxNumROSpecs;
        result = result + ", maxNumSpecsPerROSpec: ";
        result = result + this.maxNumSpecsPerROSpec;
        result = result + ", maxNumInventoryParameterSpecsPerAISpec: ";
        result = result + this.maxNumInventoryParameterSpecsPerAISpec;
        result = result + ", maxNumAccessSpecs: ";
        result = result + this.maxNumAccessSpecs;
        result = result + ", maxNumOpSpecsPerAccessSpec: ";
        result = result + this.maxNumOpSpecsPerAccessSpec;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

