/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import java.math.BigInteger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPNumberType;

public class UnsignedInteger
extends LLRPNumberType {
    private static final Integer LENGTH = 32;
    protected BigInteger value;

    public UnsignedInteger(LLRPBitList bitList, int bitIndex, int length) {
        this.decodeBinary(bitList.subList(bitIndex, length));
        this.signed = false;
    }

    public UnsignedInteger(Integer value) {
        this.value = new BigInteger(Integer.toBinaryString(value), 2);
        this.signed = false;
    }

    public UnsignedInteger(int value) {
        this(new Integer(value));
        if (!this.inRange(value)) {
            throw new IllegalArgumentException("value " + value + " not in range allowed for UnsignedByte");
        }
    }

    public UnsignedInteger(long value) {
        this.value = BigInteger.valueOf(value);
        this.signed = false;
        if (!this.inRange(value)) {
            throw new IllegalArgumentException("Illegal Argument: value " + value + " not in range allowed for UnsignedInteger");
        }
    }

    public UnsignedInteger(String valueString) {
        this.value = new BigInteger(valueString);
        if (!this.inRange(valueString)) {
            throw new IllegalArgumentException("value " + valueString + " not in range");
        }
    }

    public UnsignedInteger(String valueString, int radix) {
        this(new BigInteger(valueString, radix).intValue());
    }

    public UnsignedInteger() {
        this.value = new BigInteger("0");
        this.signed = false;
    }

    public UnsignedInteger(LLRPBitList bitList) {
        this.decodeBinary(bitList);
        this.signed = false;
    }

    public UnsignedInteger(Element element) {
        this.decodeXML(element);
    }

    @Override
    public void decodeBinary(LLRPBitList bitList) {
        long longValue = bitList.toLong();
        if (longValue < 0L) {
            longValue = 0x100000000L + longValue;
        }
        this.value = BigInteger.valueOf(longValue);
    }

    public static int length() {
        return LENGTH;
    }

    @Override
    public Integer toInteger() {
        return this.value.intValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    public Long toLong() {
        return this.value.longValue();
    }

    @Override
    public void decodeXML(Element element) {
        this.value = new BigInteger(element.getText().trim());
    }

    @Override
    public LLRPBitList encodeBinary() {
        LLRPBitList result = new LLRPBitList(this.value.toString(2));
        if (result.length() < LENGTH) {
            result.pad(LENGTH - result.length());
        }
        return result.subList(result.length() - LENGTH, LENGTH);
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        element.setContent((Content)new Text(this.value.toString()));
        return element;
    }

    @Override
    public String toString(int radix) {
        return this.value.toString(radix);
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public boolean inRange(long value) {
        return value >= 0L && value <= 0xFFFFFFFFL;
    }

    @Override
    public boolean inRange(String valueString) {
        return this.inRange(new BigInteger(valueString).longValue());
    }
}

