/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.custom.LLRPKnownCustom;
import org.llrp.ltk.generated.custom.parameters.ImpinjDISpec;
import org.llrp.ltk.generated.custom.parameters.ImpinjLISpec;
import org.llrp.ltk.generated.custom.parameters.ImpinjLoopSpec;
import org.llrp.ltk.generated.enumerations.ROSpecState;
import org.llrp.ltk.generated.interfaces.SpecParameter;
import org.llrp.ltk.generated.parameters.AISpec;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.generated.parameters.RFSurveySpec;
import org.llrp.ltk.generated.parameters.ROBoundarySpec;
import org.llrp.ltk.generated.parameters.ROReportSpec;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedByte;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class ROSpec
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(177);
    private static final Logger LOGGER = Logger.getLogger(ROSpec.class);
    protected UnsignedInteger rOSpecID;
    protected UnsignedByte priority;
    protected ROSpecState currentState;
    protected ROBoundarySpec rOBoundarySpec;
    protected List<SpecParameter> specParameterList = new LinkedList<SpecParameter>();
    protected ROReportSpec rOReportSpec;

    public ROSpec() {
    }

    public ROSpec(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ROSpec(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public ROSpec(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.rOSpecID == null) {
            LOGGER.warn((Object)" rOSpecID not set");
            throw new MissingParameterException(" rOSpecID not set  for Parameter of Type ROSpec");
        }
        resultBits.append(this.rOSpecID.encodeBinary());
        if (this.priority == null) {
            LOGGER.warn((Object)" priority not set");
            throw new MissingParameterException(" priority not set  for Parameter of Type ROSpec");
        }
        resultBits.append(this.priority.encodeBinary());
        if (this.currentState == null) {
            LOGGER.warn((Object)" currentState not set");
            throw new MissingParameterException(" currentState not set  for Parameter of Type ROSpec");
        }
        resultBits.append(this.currentState.encodeBinary());
        if (this.rOBoundarySpec == null) {
            LOGGER.warn((Object)" rOBoundarySpec not set");
            throw new MissingParameterException(" rOBoundarySpec not set");
        }
        resultBits.append(this.rOBoundarySpec.encodeBinary());
        if (this.specParameterList == null) {
            LOGGER.warn((Object)" specParameterList not set");
            throw new MissingParameterException(" specParameterList not set");
        }
        for (SpecParameter field : this.specParameterList) {
            resultBits.append(field.encodeBinary());
        }
        if (this.rOReportSpec == null) {
            LOGGER.info((Object)" rOReportSpec not set");
        } else {
            resultBits.append(this.rOReportSpec.encodeBinary());
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.rOSpecID == null) {
            LOGGER.warn((Object)" rOSpecID not set");
            throw new MissingParameterException(" rOSpecID not set");
        }
        element.addContent(this.rOSpecID.encodeXML("ROSpecID", ns));
        if (this.priority == null) {
            LOGGER.warn((Object)" priority not set");
            throw new MissingParameterException(" priority not set");
        }
        element.addContent(this.priority.encodeXML("Priority", ns));
        if (this.currentState == null) {
            LOGGER.warn((Object)" currentState not set");
            throw new MissingParameterException(" currentState not set");
        }
        element.addContent(this.currentState.encodeXML("CurrentState", ns));
        if (this.rOBoundarySpec == null) {
            LOGGER.info((Object)"rOBoundarySpec not set");
            throw new MissingParameterException("rOBoundarySpec not set");
        }
        element.addContent(this.rOBoundarySpec.encodeXML(this.rOBoundarySpec.getClass().getSimpleName(), ns));
        if (this.specParameterList == null) {
            LOGGER.warn((Object)" specParameterList not set");
            throw new MissingParameterException("  specParameterList not set");
        }
        for (SpecParameter field : this.specParameterList) {
            element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
        }
        if (this.rOReportSpec == null) {
            LOGGER.info((Object)"rOReportSpec not set");
        } else {
            element.addContent(this.rOReportSpec.encodeXML(this.rOReportSpec.getClass().getSimpleName(), ns));
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.rOSpecID = new UnsignedInteger(binary, position, UnsignedInteger.length());
        this.priority = new UnsignedByte(binary, position += UnsignedInteger.length(), UnsignedByte.length());
        this.currentState = new ROSpecState(binary, position += UnsignedByte.length(), ROSpecState.length());
        position += ROSpecState.length();
        SignedShort type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.warn((Object)"ROSpec misses non optional parameter of type ROBoundarySpec");
            throw new MissingParameterException("ROSpec misses non optional parameter of type ROBoundarySpec");
        }
        if (binary.get(position)) {
            ROSpec rOSpec = this;
            tempLength = rOSpec.rOBoundarySpec.length();
        }
        if (type != null && type.equals(ROBoundarySpec.TYPENUM)) {
            this.rOBoundarySpec = new ROBoundarySpec(binary, position, tempLength);
            position += tempLength;
        } else {
            LOGGER.warn((Object)"ROSpec misses non optional parameter of type ROBoundarySpec");
            throw new MissingParameterException("ROSpec misses non optional parameter of type ROBoundarySpec");
        }
        LOGGER.trace((Object)(" rOBoundarySpec is instantiated with ROBoundarySpec with length" + tempLength));
        this.specParameterList = new LinkedList<SpecParameter>();
        LOGGER.trace((Object)"decoding parameter specParameterList ");
        while (position < binary.length()) {
            boolean foundOne = false;
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(AISpec.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = AISpec.length();
                }
                this.specParameterList.add(new AISpec(binary, position, tempLength));
                LOGGER.trace((Object)"adding AISpec to specParameterList ");
                position += tempLength;
                foundOne = true;
                continue;
            }
            if (type != null && type.equals(RFSurveySpec.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = RFSurveySpec.length();
                }
                this.specParameterList.add(new RFSurveySpec(binary, position, tempLength));
                LOGGER.trace((Object)"adding RFSurveySpec to specParameterList ");
                position += tempLength;
                foundOne = true;
                continue;
            }
            if (type != null && type.equals(Custom.TYPENUM)) {
                Custom cus = new Custom(binary, position, tempLength);
                if (cus.getParameterSubtype().equals(ImpinjLoopSpec.PARAMETER_SUBTYPE)) {
                    this.specParameterList.add(new ImpinjLoopSpec(cus));
                    LOGGER.trace((Object)"adding ImpinjLoopSpec to specParameterList ");
                    position += tempLength;
                    foundOne = true;
                    continue;
                }
                if (cus.getParameterSubtype().equals(ImpinjLISpec.PARAMETER_SUBTYPE)) {
                    this.specParameterList.add(new ImpinjLISpec(cus));
                    LOGGER.trace((Object)"adding ImpinjLISpec to specParameterList ");
                    position += tempLength;
                    foundOne = true;
                    continue;
                }
                if (cus.getParameterSubtype().equals(ImpinjDISpec.PARAMETER_SUBTYPE)) {
                    this.specParameterList.add(new ImpinjDISpec(cus));
                    LOGGER.trace((Object)"adding ImpinjDISpec to specParameterList ");
                    position += tempLength;
                    foundOne = true;
                    continue;
                }
                if (!LLRPKnownCustom.isKnown(cus.getVendorIdentifier(), cus.getParameterSubtype())) {
                    this.specParameterList.add(cus);
                    LOGGER.trace((Object)"adding Custom to specParameterList ");
                    position += tempLength;
                    foundOne = true;
                    continue;
                }
            }
            if (foundOne) continue;
            break;
        }
        if (this.specParameterList.isEmpty()) {
            LOGGER.warn((Object)"encoded message does not contain parameter for non optional specParameterList");
            throw new MissingParameterException("ROSpec misses non optional parameter of type SpecParameter");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace((Object)"ROSpec misses optional parameter of type ROReportSpec");
        }
        if (binary.get(position)) {
            ROSpec rOSpec = this;
            tempLength = rOSpec.rOReportSpec.length();
        }
        if (type != null && type.equals(ROReportSpec.TYPENUM)) {
            this.rOReportSpec = new ROReportSpec(binary, position, tempLength);
            position += tempLength;
            LOGGER.trace((Object)(" rOReportSpec is instantiated with ROReportSpec with length" + tempLength));
        } else {
            LOGGER.trace((Object)"ROSpec misses optional parameter of type ROReportSpec");
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        List tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("ROSpecID", ns);
        if (temp != null) {
            this.rOSpecID = new UnsignedInteger(temp);
        }
        element.removeChild("ROSpecID", ns);
        temp = element.getChild("Priority", ns);
        if (temp != null) {
            this.priority = new UnsignedByte(temp);
        }
        element.removeChild("Priority", ns);
        temp = element.getChild("CurrentState", ns);
        if (temp != null) {
            this.currentState = new ROSpecState(temp);
        }
        element.removeChild("CurrentState", ns);
        temp = element.getChild("ROBoundarySpec", ns);
        if (temp != null) {
            this.rOBoundarySpec = new ROBoundarySpec(temp);
            LOGGER.info((Object)"setting parameter rOBoundarySpec for parameter ROSpec");
        }
        if (temp == null) {
            LOGGER.warn((Object)"ROSpec misses non optional parameter of type rOBoundarySpec");
            throw new MissingParameterException("ROSpec misses non optional parameter of type rOBoundarySpec");
        }
        element.removeChild("ROBoundarySpec", ns);
        this.specParameterList = new LinkedList<SpecParameter>();
        tempList = element.getChildren();
        Iterator i = tempList.iterator();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            String name = e.getName();
            if (name.equals("AISpec")) {
                this.specParameterList.add(new AISpec(e));
                LOGGER.trace((Object)"adding AISpec to specParameterList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("RFSurveySpec")) {
                this.specParameterList.add(new RFSurveySpec(e));
                LOGGER.trace((Object)"adding RFSurveySpec to specParameterList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("ImpinjLoopSpec")) {
                this.specParameterList.add(new ImpinjLoopSpec(e));
                LOGGER.trace((Object)"adding ImpinjLoopSpec to specParameterList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("ImpinjLISpec")) {
                this.specParameterList.add(new ImpinjLISpec(e));
                LOGGER.trace((Object)"adding ImpinjLISpec to specParameterList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("ImpinjDISpec")) {
                this.specParameterList.add(new ImpinjDISpec(e));
                LOGGER.trace((Object)"adding ImpinjDISpec to specParameterList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (!name.equals("Custom")) continue;
            this.specParameterList.add(new Custom(e));
            LOGGER.trace((Object)"adding Custom to specParameterList ");
            atLeastOnce = true;
            i.remove();
        }
        if (this.specParameterList.isEmpty()) {
            LOGGER.warn((Object)"Choice SpecParameter must contain at least one element");
            throw new MissingParameterException("Choice SpecParameter must contain at least one element");
        }
        temp = element.getChild("ROReportSpec", ns);
        if (temp != null) {
            this.rOReportSpec = new ROReportSpec(temp);
            LOGGER.info((Object)"setting parameter rOReportSpec for parameter ROSpec");
        }
        if (temp == null) {
            LOGGER.trace((Object)"ROSpec misses optional parameter of type rOReportSpec");
        }
        element.removeChild("ROReportSpec", ns);
        if (element.getChildren().size() > 0) {
            String message = "ROSpec has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setROSpecID(UnsignedInteger rOSpecID) {
        this.rOSpecID = rOSpecID;
    }

    public void setPriority(UnsignedByte priority) {
        this.priority = priority;
    }

    public void setCurrentState(ROSpecState currentState) {
        this.currentState = currentState;
    }

    public void setROBoundarySpec(ROBoundarySpec rOBoundarySpec) {
        this.rOBoundarySpec = rOBoundarySpec;
    }

    public void setSpecParameterList(List<SpecParameter> specParameterList) {
        this.specParameterList = specParameterList;
    }

    public void setROReportSpec(ROReportSpec rOReportSpec) {
        this.rOReportSpec = rOReportSpec;
    }

    public UnsignedInteger getROSpecID() {
        return this.rOSpecID;
    }

    public UnsignedByte getPriority() {
        return this.priority;
    }

    public ROSpecState getCurrentState() {
        return this.currentState;
    }

    public ROBoundarySpec getROBoundarySpec() {
        return this.rOBoundarySpec;
    }

    public List<SpecParameter> getSpecParameterList() {
        return this.specParameterList;
    }

    public ROReportSpec getROReportSpec() {
        return this.rOReportSpec;
    }

    public void addToSpecParameterList(SpecParameter specParameter) {
        if (this.specParameterList == null) {
            this.specParameterList = new LinkedList<SpecParameter>();
        }
        this.specParameterList.add(specParameter);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "ROSpec";
    }

    public String toString() {
        String result = "ROSpec: ";
        result = result + ", rOSpecID: ";
        result = result + this.rOSpecID;
        result = result + ", priority: ";
        result = result + this.priority;
        result = result + ", currentState: ";
        result = result + this.currentState;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

