/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.enumerations.ConnectionAttemptStatusType;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;

public class ConnectionAttemptEvent
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(256);
    private static final Logger LOGGER = Logger.getLogger(ConnectionAttemptEvent.class);
    protected ConnectionAttemptStatusType status;

    public ConnectionAttemptEvent() {
    }

    public ConnectionAttemptEvent(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ConnectionAttemptEvent(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public ConnectionAttemptEvent(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.status == null) {
            LOGGER.warn((Object)" status not set");
            throw new MissingParameterException(" status not set  for Parameter of Type ConnectionAttemptEvent");
        }
        resultBits.append(this.status.encodeBinary());
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.status == null) {
            LOGGER.warn((Object)" status not set");
            throw new MissingParameterException(" status not set");
        }
        element.addContent(this.status.encodeXML("Status", ns));
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.status = new ConnectionAttemptStatusType(binary, position, ConnectionAttemptStatusType.length());
        position += ConnectionAttemptStatusType.length();
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("Status", ns);
        if (temp != null) {
            this.status = new ConnectionAttemptStatusType(temp);
        }
        element.removeChild("Status", ns);
        if (element.getChildren().size() > 0) {
            String message = "ConnectionAttemptEvent has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setStatus(ConnectionAttemptStatusType status) {
        this.status = status;
    }

    public ConnectionAttemptStatusType getStatus() {
        return this.status;
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "ConnectionAttemptEvent";
    }

    public String toString() {
        String result = "ConnectionAttemptEvent: ";
        result = result + ", status: ";
        result = result + this.status;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

