/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import java.math.BigInteger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPNumberType;

public class SignedShort
extends LLRPNumberType {
    private static final Integer LENGTH = 16;
    protected short value;

    public SignedShort(LLRPBitList bitList, int bitIndex, int length) {
        if (bitIndex + 32 > bitList.length()) {
            this.decodeBinary(bitList.subList(bitIndex, length));
        } else {
            this.value = bitList.toShort(bitIndex, length);
        }
        this.signed = true;
    }

    public SignedShort(Short value) {
        this.value = value;
        this.signed = true;
    }

    public SignedShort(Element element) {
        this.decodeXML(element);
    }

    public SignedShort(Integer value) {
        this.value = value.shortValue();
        this.signed = true;
    }

    public SignedShort(String valueString, int radix) {
        this(new BigInteger(valueString, radix).intValue());
    }

    public SignedShort(int value) {
        this.value = (short)value;
        this.signed = true;
        if (!this.inRange(value)) {
            throw new IllegalArgumentException("value " + value + " not in range allowed for SignedShort");
        }
    }

    public SignedShort() {
        this.value = 0;
        this.signed = true;
    }

    public SignedShort(LLRPBitList bitList) {
        this.decodeBinary(bitList);
        this.signed = true;
    }

    public SignedShort(String valueString) {
        this(valueString, 10);
        if (!this.inRange(valueString)) {
            throw new IllegalArgumentException("value " + valueString + " not in range");
        }
    }

    @Override
    public void decodeBinary(LLRPBitList bitList) {
        this.value = bitList.toShort();
    }

    public static int length() {
        return LENGTH;
    }

    @Override
    public Integer toInteger() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    public short toShort() {
        return this.value;
    }

    @Override
    public void decodeXML(Element element) {
        this.value = (short)Integer.parseInt(element.getText().trim());
    }

    @Override
    public LLRPBitList encodeBinary() {
        LLRPBitList result = new LLRPBitList(Integer.toBinaryString(this.value));
        if (result.length() < LENGTH) {
            result.pad(LENGTH - result.length());
        }
        return result.subList(result.length() - LENGTH, LENGTH);
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        element.setContent((Content)new Text(Integer.valueOf(this.value).toString()));
        return element;
    }

    @Override
    public String toString() {
        return Integer.toString(this.value);
    }

    @Override
    public String toString(int radix) {
        return Integer.toString(this.value, radix);
    }

    @Override
    public boolean inRange(long value) {
        return value >= -32768L && value <= 32767L;
    }

    @Override
    public boolean inRange(String valueString) {
        return this.inRange(new BigInteger(valueString).longValue());
    }
}

