/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import java.math.BigInteger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPNumberType;

public class UnsignedByte
extends LLRPNumberType {
    private static final Integer LENGTH = 8;
    protected int value;

    public UnsignedByte(LLRPBitList bitList, int bitIndex, int length) {
        this(bitList.subList(bitIndex, length));
    }

    public UnsignedByte(int value) {
        this.value = value < 0 ? 254 + value + 2 : value;
        this.signed = false;
        if (!this.inRange(this.value)) {
            throw new IllegalArgumentException("value " + value + " not in range allowed for UnsignedByte");
        }
    }

    public UnsignedByte(byte value) {
        this((int)value);
    }

    public UnsignedByte(String valueString) {
        this(new Integer(valueString));
        if (!this.inRange(valueString)) {
            throw new IllegalArgumentException("value " + valueString + " not in range");
        }
    }

    public UnsignedByte(LLRPBitList bitList) {
        this.decodeBinary(bitList);
        this.signed = false;
    }

    public UnsignedByte() {
        this.value = 0;
        this.signed = false;
    }

    public UnsignedByte(String valueString, int radix) {
        this(new BigInteger(valueString, radix).intValue());
    }

    public UnsignedByte(Element element) {
        this.decodeXML(element);
    }

    public static int length() {
        return LENGTH;
    }

    public byte toByte() {
        return (byte)this.value;
    }

    @Override
    public Integer toInteger() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public void decodeBinary(LLRPBitList list) {
        this.value = Integer.parseInt(list.toString(), 2);
    }

    @Override
    public void decodeXML(Element element) {
        this.value = Integer.parseInt(element.getText().trim());
    }

    @Override
    public LLRPBitList encodeBinary() {
        LLRPBitList result = new LLRPBitList(Integer.toBinaryString(this.value));
        if (result.length() < LENGTH) {
            result.pad(LENGTH - result.length());
        }
        return result.subList(result.length() - LENGTH, LENGTH);
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        element.setContent((Content)new Text(Integer.toString(this.value)));
        return element;
    }

    @Override
    public String toString(int radix) {
        return Integer.toString(this.value, radix).replace("-", "");
    }

    @Override
    public String toString() {
        return this.toString(10);
    }

    @Override
    public boolean inRange(long value) {
        return value >= 0L && value <= 255L;
    }

    @Override
    public boolean inRange(String valueString) {
        return this.inRange(new BigInteger(valueString).longValue());
    }
}

