/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.custom.enumerations.ImpinjLowDutyCycleMode;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class ImpinjLowDutyCycle
extends Custom {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(28);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjLowDutyCycle.class);
    protected ImpinjLowDutyCycleMode lowDutyCycleMode;
    protected UnsignedShort emptyFieldTimeout;
    protected UnsignedShort fieldPingInterval;
    private List<Custom> customList = new LinkedList<Custom>();

    public ImpinjLowDutyCycle() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjLowDutyCycle(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjLowDutyCycle(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(28);
        this.decodeXML(element);
    }

    public ImpinjLowDutyCycle(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn(" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.lowDutyCycleMode == null) {
            LOGGER.warn(" lowDutyCycleMode not set");
        }
        resultBits.append(this.lowDutyCycleMode.encodeBinary());
        if (this.emptyFieldTimeout == null) {
            LOGGER.warn(" emptyFieldTimeout not set");
        }
        resultBits.append(this.emptyFieldTimeout.encodeBinary());
        if (this.fieldPingInterval == null) {
            LOGGER.warn(" fieldPingInterval not set");
        }
        resultBits.append(this.fieldPingInterval.encodeBinary());
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom field : this.customList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.30");
        Element element = new Element(name, ns);
        if (this.lowDutyCycleMode == null) {
            LOGGER.warn(" lowDutyCycleMode not set");
            throw new MissingParameterException(" lowDutyCycleMode not set");
        }
        element.addContent(this.lowDutyCycleMode.encodeXML("LowDutyCycleMode", ns));
        if (this.emptyFieldTimeout == null) {
            LOGGER.warn(" emptyFieldTimeout not set");
            throw new MissingParameterException(" emptyFieldTimeout not set");
        }
        element.addContent(this.emptyFieldTimeout.encodeXML("EmptyFieldTimeout", ns));
        if (this.fieldPingInterval == null) {
            LOGGER.warn(" fieldPingInterval not set");
            throw new MissingParameterException(" fieldPingInterval not set");
        }
        element.addContent(this.fieldPingInterval.encodeXML("FieldPingInterval", ns));
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom field : this.customList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-.");
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + ".");
        }
        this.lowDutyCycleMode = new ImpinjLowDutyCycleMode(binary.subList(position, ImpinjLowDutyCycleMode.length()));
        this.emptyFieldTimeout = new UnsignedShort(binary.subList(position += ImpinjLowDutyCycleMode.length(), UnsignedShort.length()));
        this.fieldPingInterval = new UnsignedShort(binary.subList(position += UnsignedShort.length(), UnsignedShort.length()));
        position += UnsignedShort.length();
        this.customList = new LinkedList<Custom>();
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            SignedShort _type = new SignedShort(binary.subList(position + 6, 10));
            short tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (_type == null || !_type.equals(Custom.TYPENUM)) continue;
            Custom cus = new Custom(binary.subList(position, tempLength));
            this.customList.add(cus);
            position += tempLength;
            atLeastOnce = true;
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Element temp = null;
        List tempList = null;
        boolean atLeastOnce = false;
        temp = element.getChild("LowDutyCycleMode", element.getNamespace());
        if (temp != null) {
            this.lowDutyCycleMode = new ImpinjLowDutyCycleMode(temp);
        }
        if ((temp = element.getChild("EmptyFieldTimeout", element.getNamespace())) != null) {
            this.emptyFieldTimeout = new UnsignedShort(temp);
        }
        if ((temp = element.getChild("FieldPingInterval", element.getNamespace())) != null) {
            this.fieldPingInterval = new UnsignedShort(temp);
        }
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            Namespace llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("Custom", llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjLowDutyCycle misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug("adding Custom to customList ");
            }
        }
    }

    public void setLowDutyCycleMode(ImpinjLowDutyCycleMode lowDutyCycleMode) {
        this.lowDutyCycleMode = lowDutyCycleMode;
    }

    public void setEmptyFieldTimeout(UnsignedShort emptyFieldTimeout) {
        this.emptyFieldTimeout = emptyFieldTimeout;
    }

    public void setFieldPingInterval(UnsignedShort fieldPingInterval) {
        this.fieldPingInterval = fieldPingInterval;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public ImpinjLowDutyCycleMode getLowDutyCycleMode() {
        return this.lowDutyCycleMode;
    }

    public UnsignedShort getEmptyFieldTimeout() {
        return this.emptyFieldTimeout;
    }

    public UnsignedShort getFieldPingInterval() {
        return this.fieldPingInterval;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

