/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import java.util.LinkedList;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.llrp.ltk.types.BytesToEnd;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedByte;

public class BytesToEnd_HEX
extends BytesToEnd {
    public BytesToEnd_HEX() {
    }

    public BytesToEnd_HEX(LLRPBitList list) {
        super(list);
    }

    public BytesToEnd_HEX(LLRPBitList bitList, int bitIndex, int length) {
        this(bitList.subList(bitIndex, length));
    }

    public BytesToEnd_HEX(Element element) {
        super(element);
    }

    public BytesToEnd_HEX(String hexString) {
        Element element = new Element("foo", "ns");
        element.setText(hexString);
        this.decodeXML(element);
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        element.setContent(new Text(this.toString()));
        return element;
    }

    @Override
    public void decodeXML(Element element) {
        String hexString = element.getText().replaceAll(" ", "").trim();
        this.bytes = new LinkedList();
        for (int a = 0; a < hexString.length(); a += 2) {
            String twoHexDigits = "";
            twoHexDigits = a + 2 <= hexString.length() ? hexString.substring(a, a + 2) : "0" + hexString.substring(a, a + 1);
            Integer hexInt = Integer.parseInt(twoHexDigits + "", 16);
            this.bytes.add(new SignedByte(hexInt));
        }
    }

    @Override
    public String toString() {
        String s = "";
        int i = 0;
        for (SignedByte b : this.bytes) {
            if (b == null) continue;
            String t = Integer.toHexString(b.value).toUpperCase();
            if (t.length() < 2) {
                t = "0" + t;
            }
            s = s + t.substring(t.length() - 2, t.length());
            ++i;
        }
        return s;
    }
}

