/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import java.math.BigInteger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPNumberType;

public class SignedInteger
extends LLRPNumberType {
    private static final Integer LENGTH = 32;
    protected int value;

    public SignedInteger() {
        this.value = 0;
        this.signed = true;
    }

    public SignedInteger(Integer value) {
        this.value = value;
        this.signed = true;
    }

    public SignedInteger(int value) {
        this(new Integer(value));
        if (!this.inRange(value)) {
            throw new IllegalArgumentException("value " + value + " not in range allowed for SignedInteger");
        }
    }

    public SignedInteger(LLRPBitList bitList) {
        this.decodeBinary(bitList);
    }

    public SignedInteger(LLRPBitList bitList, int bitIndex, int length) {
        this(bitList.subList(bitIndex, length));
    }

    public SignedInteger(String valueString) {
        this(valueString, 10);
        if (!this.inRange(valueString)) {
            throw new IllegalArgumentException("value " + valueString + " not in range");
        }
    }

    public SignedInteger(String valueString, int radix) {
        this(new BigInteger(valueString, radix).intValue());
    }

    public SignedInteger(Element element) {
        this.decodeXML(element);
    }

    @Override
    public void decodeBinary(LLRPBitList list) {
        this.value = list.toInt();
    }

    public static int length() {
        return LENGTH;
    }

    @Override
    public Integer toInteger() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public void decodeXML(Element element) {
        this.value = Integer.parseInt(element.getText().trim());
    }

    @Override
    public LLRPBitList encodeBinary() {
        LLRPBitList result = new LLRPBitList(Integer.toBinaryString(this.value));
        if (result.length() < LENGTH) {
            result.pad(LENGTH - result.length());
        }
        return result.subList(result.length() - LENGTH, LENGTH);
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        element.setContent(new Text(new Integer(this.value).toString()));
        return element;
    }

    @Override
    public String toString() {
        return Integer.toString(this.value);
    }

    @Override
    public String toString(int radix) {
        return Integer.toString(this.value, radix);
    }

    @Override
    public boolean inRange(long value) {
        return value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE;
    }

    @Override
    public boolean inRange(String valueString) {
        return this.inRange(new BigInteger(valueString).longValue());
    }
}

