/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import java.math.BigInteger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPNumberType;

public class UnsignedLong
extends LLRPNumberType {
    protected static final int LENGTH = 64;
    protected BigInteger value;

    public UnsignedLong() {
        this.value = BigInteger.ZERO;
    }

    public UnsignedLong(Long value) {
        this.value = new BigInteger(value.toString());
        this.signed = false;
    }

    public UnsignedLong(Element element) {
        this.decodeXML(element);
    }

    public UnsignedLong(String valueString, int radix) {
        this(new BigInteger(valueString, radix).longValue());
    }

    public UnsignedLong(String string) {
        this(string, 10);
        if (!this.inRange(string)) {
            throw new IllegalArgumentException("value " + string + " not in range allowed for UnsignedLong");
        }
    }

    public UnsignedLong(LLRPBitList bitList) {
        this.decodeBinary(bitList);
        this.signed = false;
    }

    public UnsignedLong(LLRPBitList bitList, int bitIndex, int length) {
        this.decodeBinary(bitList.subList(bitIndex, length));
        this.signed = false;
    }

    @Override
    public void decodeBinary(LLRPBitList bitList) {
        this.value = bitList.toBigInteger();
    }

    public boolean equals(LLRPNumberType other) {
        if (other instanceof UnsignedLong) {
            return this.toBigInteger().equals(((UnsignedLong)other).toBigInteger());
        }
        return this.toBigInteger().equals(new BigInteger(other.encodeBinary().toString(), 2));
    }

    public static int length() {
        return 64;
    }

    public BigInteger toBigInteger() {
        return this.value;
    }

    @Override
    public Integer toInteger() {
        return new Long(this.toLong()).intValue();
    }

    @Override
    public int intValue() {
        return new Long(this.toLong()).intValue();
    }

    public long toLong() {
        return this.value.longValue();
    }

    @Override
    public void decodeXML(Element element) {
        this.value = new BigInteger(element.getText().trim());
    }

    @Override
    public LLRPBitList encodeBinary() {
        LLRPBitList result = new LLRPBitList(this.value.toString(2));
        if (result.length() < 64) {
            result.pad(64 - result.length());
        }
        return result.subList(result.length() - 64, 64);
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        element.setContent(new Text(this.value.toString()));
        return element;
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public String toString(int radix) {
        return this.value.toString(radix);
    }

    @Override
    public boolean inRange(long value) {
        return value >= 0L;
    }

    @Override
    public boolean inRange(String valueString) {
        BigInteger b = new BigInteger(valueString);
        b = b.min(BigInteger.valueOf(Long.MAX_VALUE));
        return (b = b.min(BigInteger.valueOf(Long.MAX_VALUE))).intValue() > 0 && this.inRange(new BigInteger(valueString).longValue());
    }
}

