/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.enumerations.RFSurveyEventType;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class RFSurveyEvent
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(253);
    private static final Logger LOGGER = Logger.getLogger(RFSurveyEvent.class);
    protected RFSurveyEventType eventType;
    protected UnsignedInteger rOSpecID;
    protected UnsignedShort specIndex;

    public RFSurveyEvent() {
    }

    public RFSurveyEvent(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public RFSurveyEvent(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public RFSurveyEvent(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.eventType == null) {
            LOGGER.warn((Object)" eventType not set");
            throw new MissingParameterException(" eventType not set  for Parameter of Type RFSurveyEvent");
        }
        resultBits.append(this.eventType.encodeBinary());
        if (this.rOSpecID == null) {
            LOGGER.warn((Object)" rOSpecID not set");
            throw new MissingParameterException(" rOSpecID not set  for Parameter of Type RFSurveyEvent");
        }
        resultBits.append(this.rOSpecID.encodeBinary());
        if (this.specIndex == null) {
            LOGGER.warn((Object)" specIndex not set");
            throw new MissingParameterException(" specIndex not set  for Parameter of Type RFSurveyEvent");
        }
        resultBits.append(this.specIndex.encodeBinary());
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.eventType == null) {
            LOGGER.warn((Object)" eventType not set");
            throw new MissingParameterException(" eventType not set");
        }
        element.addContent(this.eventType.encodeXML("EventType", ns));
        if (this.rOSpecID == null) {
            LOGGER.warn((Object)" rOSpecID not set");
            throw new MissingParameterException(" rOSpecID not set");
        }
        element.addContent(this.rOSpecID.encodeXML("ROSpecID", ns));
        if (this.specIndex == null) {
            LOGGER.warn((Object)" specIndex not set");
            throw new MissingParameterException(" specIndex not set");
        }
        element.addContent(this.specIndex.encodeXML("SpecIndex", ns));
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.eventType = new RFSurveyEventType(binary, position, RFSurveyEventType.length());
        this.rOSpecID = new UnsignedInteger(binary, position += RFSurveyEventType.length(), UnsignedInteger.length());
        this.specIndex = new UnsignedShort(binary, position += UnsignedInteger.length(), UnsignedShort.length());
        position += UnsignedShort.length();
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("EventType", ns);
        if (temp != null) {
            this.eventType = new RFSurveyEventType(temp);
        }
        element.removeChild("EventType", ns);
        temp = element.getChild("ROSpecID", ns);
        if (temp != null) {
            this.rOSpecID = new UnsignedInteger(temp);
        }
        element.removeChild("ROSpecID", ns);
        temp = element.getChild("SpecIndex", ns);
        if (temp != null) {
            this.specIndex = new UnsignedShort(temp);
        }
        element.removeChild("SpecIndex", ns);
        if (element.getChildren().size() > 0) {
            String message = "RFSurveyEvent has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setEventType(RFSurveyEventType eventType) {
        this.eventType = eventType;
    }

    public void setROSpecID(UnsignedInteger rOSpecID) {
        this.rOSpecID = rOSpecID;
    }

    public void setSpecIndex(UnsignedShort specIndex) {
        this.specIndex = specIndex;
    }

    public RFSurveyEventType getEventType() {
        return this.eventType;
    }

    public UnsignedInteger getROSpecID() {
        return this.rOSpecID;
    }

    public UnsignedShort getSpecIndex() {
        return this.specIndex;
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "RFSurveyEvent";
    }

    public String toString() {
        String result = "RFSurveyEvent: ";
        result = result + ", eventType: ";
        result = result + this.eventType;
        result = result + ", rOSpecID: ";
        result = result + this.rOSpecID;
        result = result + ", specIndex: ";
        result = result + this.specIndex;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

