/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.net;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.IoSession;
import org.llrp.ltk.generated.enumerations.ConnectionAttemptStatusType;
import org.llrp.ltk.generated.parameters.ConnectionAttemptEvent;
import org.llrp.ltk.net.LLRPConnectionAttemptFailedException;
import org.llrp.ltk.net.LLRPEndpoint;
import org.llrp.ltk.net.LLRPIoHandlerAdapter;
import org.llrp.ltk.net.LLRPIoHandlerAdapterImpl;
import org.llrp.ltk.types.LLRPMessage;

public abstract class LLRPConnection {
    public static final int CONNECT_TIMEOUT = 10000;
    public static final String SYNC_MESSAGE_ANSWER = "synchronousMessageAnswer";
    protected LLRPEndpoint endpoint;
    protected LLRPIoHandlerAdapter handler;
    protected IoSession session;
    private Logger log = Logger.getLogger(LLRPConnection.class);

    public LLRPConnection() {
        this.handler = new LLRPIoHandlerAdapterImpl(this);
    }

    protected void checkLLRPConnectionAttemptStatus(long timeout) throws LLRPConnectionAttemptFailedException {
        try {
            ConnectionAttemptStatusType status;
            BlockingQueue<ConnectionAttemptEvent> connectionAttemptEventQueue = this.handler.getConnectionAttemptEventQueue();
            ConnectionAttemptEvent connectionAttemptEvent = connectionAttemptEventQueue.poll(timeout, TimeUnit.MILLISECONDS);
            if (connectionAttemptEvent != null) {
                status = connectionAttemptEvent.getStatus();
                if (status.intValue() != 0) {
                    this.log.info((Object)("LLRP reader reported failed connection attempt (ConnectionAttemptStatus = " + status.toString() + ")"));
                    throw new LLRPConnectionAttemptFailedException(status.toString());
                }
            } else {
                throw new LLRPConnectionAttemptFailedException("Connection request timed out after " + timeout + " ms.");
            }
            this.log.info((Object)("LLRP reader reported successfull connection attempt (ConnectionAttemptEvent.Status = " + status.toString() + ")"));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new LLRPConnectionAttemptFailedException(e.getMessage());
        }
    }

    public abstract boolean reconnect();

    public void send(LLRPMessage message) {
        if (this.session == null) {
            this.log.warn((Object)"session is not yet established");
            this.endpoint.errorOccured("session is not yet established");
            return;
        }
        if (!this.session.isConnected()) {
            if (this.reconnect()) {
                this.session.write((Object)message);
            } else {
                this.log.info((Object)"session is not yet connected");
                this.endpoint.errorOccured("session is not yet connected");
            }
        } else {
            this.session.write((Object)message);
        }
    }

    public LLRPMessage transact(LLRPMessage message) throws TimeoutException {
        return this.transact(message, 0L);
    }

    public LLRPMessage transact(LLRPMessage message, long transactionTimeout) throws TimeoutException {
        String returnMessageType = message.getResponseType();
        if (returnMessageType.equals("")) {
            this.endpoint.errorOccured("message does not expect return message");
            return null;
        }
        if (this.session == null) {
            this.log.warn((Object)"session is not yet established");
            this.endpoint.errorOccured("session is not yet established");
            return null;
        }
        LLRPMessage returnMessage = null;
        if (!this.session.isConnected() && !this.reconnect()) {
            this.log.info((Object)"session is not yet connected");
            this.endpoint.errorOccured("session is not yet connected");
            return null;
        }
        this.session.setAttribute((Object)SYNC_MESSAGE_ANSWER, (Object)returnMessageType);
        WriteFuture writeFuture = this.session.write((Object)message);
        this.log.info((Object)(message.getName() + " transact ...."));
        writeFuture.join();
        try {
            BlockingQueue<LLRPMessage> synMessageQueue = this.handler.getSynMessageQueue();
            LLRPMessage lLRPMessage = returnMessage = transactionTimeout == 0L ? synMessageQueue.take() : synMessageQueue.poll(transactionTimeout, TimeUnit.MILLISECONDS);
            while (returnMessage != null && !returnMessage.getName().equals(returnMessageType)) {
                returnMessage = transactionTimeout == 0L ? synMessageQueue.take() : synMessageQueue.poll(transactionTimeout, TimeUnit.MILLISECONDS);
            }
            this.session.removeAttribute((Object)SYNC_MESSAGE_ANSWER);
            if (returnMessage == null) {
                throw new TimeoutException("Request timed out after " + transactionTimeout + " ms.");
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return returnMessage;
    }

    public LLRPEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(LLRPEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public LLRPIoHandlerAdapter getHandler() {
        return this.handler;
    }

    public void setHandler(LLRPIoHandlerAdapter handler) {
        this.handler = handler;
    }
}

