/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.parameters.C1G2TagInventoryStateAwareSingulationAction;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.TwoBitField;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class C1G2SingulationControl
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(336);
    private static final Logger LOGGER = Logger.getLogger(C1G2SingulationControl.class);
    protected TwoBitField session;
    protected BitList reserved0 = new BitList(6);
    protected UnsignedShort tagPopulation;
    protected UnsignedInteger tagTransitTime;
    protected C1G2TagInventoryStateAwareSingulationAction c1G2TagInventoryStateAwareSingulationAction;

    public C1G2SingulationControl() {
    }

    public C1G2SingulationControl(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public C1G2SingulationControl(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public C1G2SingulationControl(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.session == null) {
            LOGGER.warn(" session not set");
            throw new MissingParameterException(" session not set  for Parameter of Type C1G2SingulationControl");
        }
        resultBits.append(this.session.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        if (this.tagPopulation == null) {
            LOGGER.warn(" tagPopulation not set");
            throw new MissingParameterException(" tagPopulation not set  for Parameter of Type C1G2SingulationControl");
        }
        resultBits.append(this.tagPopulation.encodeBinary());
        if (this.tagTransitTime == null) {
            LOGGER.warn(" tagTransitTime not set");
            throw new MissingParameterException(" tagTransitTime not set  for Parameter of Type C1G2SingulationControl");
        }
        resultBits.append(this.tagTransitTime.encodeBinary());
        if (this.c1G2TagInventoryStateAwareSingulationAction == null) {
            LOGGER.info(" c1G2TagInventoryStateAwareSingulationAction not set");
        } else {
            resultBits.append(this.c1G2TagInventoryStateAwareSingulationAction.encodeBinary());
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.session == null) {
            LOGGER.warn(" session not set");
            throw new MissingParameterException(" session not set");
        }
        element.addContent(this.session.encodeXML("Session", ns));
        if (this.tagPopulation == null) {
            LOGGER.warn(" tagPopulation not set");
            throw new MissingParameterException(" tagPopulation not set");
        }
        element.addContent(this.tagPopulation.encodeXML("TagPopulation", ns));
        if (this.tagTransitTime == null) {
            LOGGER.warn(" tagTransitTime not set");
            throw new MissingParameterException(" tagTransitTime not set");
        }
        element.addContent(this.tagTransitTime.encodeXML("TagTransitTime", ns));
        if (this.c1G2TagInventoryStateAwareSingulationAction == null) {
            LOGGER.info("c1G2TagInventoryStateAwareSingulationAction not set");
        } else {
            element.addContent(this.c1G2TagInventoryStateAwareSingulationAction.encodeXML(this.c1G2TagInventoryStateAwareSingulationAction.getClass().getSimpleName(), ns));
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.session = new TwoBitField(binary, position, TwoBitField.length());
        position += TwoBitField.length();
        this.tagPopulation = new UnsignedShort(binary, position += this.reserved0.length(), UnsignedShort.length());
        this.tagTransitTime = new UnsignedInteger(binary, position += UnsignedShort.length(), UnsignedInteger.length());
        position += UnsignedInteger.length();
        SignedShort type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace("C1G2SingulationControl misses optional parameter of type C1G2TagInventoryStateAwareSingulationAction");
        }
        if (binary.get(position)) {
            C1G2SingulationControl c1G2SingulationControl = this;
            tempLength = c1G2SingulationControl.c1G2TagInventoryStateAwareSingulationAction.length();
        }
        if (type != null && type.equals(C1G2TagInventoryStateAwareSingulationAction.TYPENUM)) {
            this.c1G2TagInventoryStateAwareSingulationAction = new C1G2TagInventoryStateAwareSingulationAction(binary, position, tempLength);
            position += tempLength;
            LOGGER.trace(" c1G2TagInventoryStateAwareSingulationAction is instantiated with C1G2TagInventoryStateAwareSingulationAction with length" + tempLength);
        } else {
            LOGGER.trace("C1G2SingulationControl misses optional parameter of type C1G2TagInventoryStateAwareSingulationAction");
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("Session", ns);
        if (temp != null) {
            this.session = new TwoBitField(temp);
        }
        element.removeChild("Session", ns);
        temp = element.getChild("TagPopulation", ns);
        if (temp != null) {
            this.tagPopulation = new UnsignedShort(temp);
        }
        element.removeChild("TagPopulation", ns);
        temp = element.getChild("TagTransitTime", ns);
        if (temp != null) {
            this.tagTransitTime = new UnsignedInteger(temp);
        }
        element.removeChild("TagTransitTime", ns);
        temp = element.getChild("C1G2TagInventoryStateAwareSingulationAction", ns);
        if (temp != null) {
            this.c1G2TagInventoryStateAwareSingulationAction = new C1G2TagInventoryStateAwareSingulationAction(temp);
            LOGGER.info("setting parameter c1G2TagInventoryStateAwareSingulationAction for parameter C1G2SingulationControl");
        }
        if (temp == null) {
            LOGGER.trace("C1G2SingulationControl misses optional parameter of type c1G2TagInventoryStateAwareSingulationAction");
        }
        element.removeChild("C1G2TagInventoryStateAwareSingulationAction", ns);
        if (element.getChildren().size() > 0) {
            String message = "C1G2SingulationControl has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setSession(TwoBitField session) {
        this.session = session;
    }

    public void setTagPopulation(UnsignedShort tagPopulation) {
        this.tagPopulation = tagPopulation;
    }

    public void setTagTransitTime(UnsignedInteger tagTransitTime) {
        this.tagTransitTime = tagTransitTime;
    }

    public void setC1G2TagInventoryStateAwareSingulationAction(C1G2TagInventoryStateAwareSingulationAction c1G2TagInventoryStateAwareSingulationAction) {
        this.c1G2TagInventoryStateAwareSingulationAction = c1G2TagInventoryStateAwareSingulationAction;
    }

    public TwoBitField getSession() {
        return this.session;
    }

    public UnsignedShort getTagPopulation() {
        return this.tagPopulation;
    }

    public UnsignedInteger getTagTransitTime() {
        return this.tagTransitTime;
    }

    public C1G2TagInventoryStateAwareSingulationAction getC1G2TagInventoryStateAwareSingulationAction() {
        return this.c1G2TagInventoryStateAwareSingulationAction;
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "C1G2SingulationControl";
    }

    public String toString() {
        String result = "C1G2SingulationControl: ";
        result = result + ", session: ";
        result = result + this.session;
        result = result + ", tagPopulation: ";
        result = result + this.tagPopulation;
        result = result + ", tagTransitTime: ";
        result = result + this.tagTransitTime;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

