/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.interfaces.EPCParameter;
import org.llrp.ltk.types.BitArray_HEX;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class EPCData
extends TLVParameter
implements EPCParameter {
    public static final SignedShort TYPENUM = new SignedShort(241);
    private static final Logger LOGGER = Logger.getLogger(EPCData.class);
    protected BitArray_HEX ePC;

    public EPCData() {
    }

    public EPCData(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public EPCData(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public EPCData(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.ePC == null) {
            LOGGER.warn(" ePC not set");
            throw new MissingParameterException(" ePC not set  for Parameter of Type EPCData");
        }
        resultBits.append(this.ePC.encodeBinary());
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.ePC == null) {
            LOGGER.warn(" ePC not set");
            throw new MissingParameterException(" ePC not set");
        }
        element.addContent(this.ePC.encodeXML("EPC", ns));
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        short fieldCount = new SignedShort(binary, position, UnsignedShort.length()).toShort();
        tempLength = BitArray_HEX.length() * fieldCount + UnsignedShort.length();
        if (tempLength % 8 > 0) {
            tempLength += 8 - tempLength % 8;
            LOGGER.info("padding needed for ePC ");
        }
        this.ePC = new BitArray_HEX(binary, position, tempLength);
        position += tempLength;
        LOGGER.trace("decoding array of type: BitArray_HEX with " + tempLength + " length");
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("EPC", ns);
        if (temp != null) {
            this.ePC = new BitArray_HEX(temp);
        }
        element.removeChild("EPC", ns);
        if (element.getChildren().size() > 0) {
            String message = "EPCData has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setEPC(BitArray_HEX ePC) {
        this.ePC = ePC;
    }

    public BitArray_HEX getEPC() {
        return this.ePC;
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "EPCData";
    }

    public String toString() {
        String result = "EPCData: ";
        result = result + ", ePC: ";
        result = result + this.ePC;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

