/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import java.util.LinkedList;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPType;
import org.llrp.ltk.types.SignedByte;

public class BytesToEnd
extends LLRPType {
    protected List<SignedByte> bytes = new LinkedList<SignedByte>();

    public BytesToEnd() {
        this.bytes = new LinkedList<SignedByte>();
    }

    public BytesToEnd(String hexString) {
        Element element = new Element("foo", "ns");
        element.setText(hexString);
        this.decodeXML(element);
    }

    public BytesToEnd(LLRPBitList bits) {
        this.decodeBinary(bits);
    }

    public BytesToEnd(LLRPBitList bitList, int bitIndex, int length) {
        this(bitList.subList(bitIndex, length));
    }

    public BytesToEnd(Element element) {
        this.decodeXML(element);
    }

    public void add(SignedByte aByte) {
        this.bytes.add(aByte);
    }

    @Override
    public void decodeBinary(LLRPBitList list) {
        int length = list.length();
        for (int i = 0; i < length; i += SignedByte.length()) {
            this.bytes.add(new SignedByte(list.subList(i, SignedByte.length())));
        }
    }

    @Override
    public LLRPBitList encodeBinary() {
        LLRPBitList result = new LLRPBitList();
        for (SignedByte u : this.bytes) {
            result.append(u.encodeBinary());
        }
        return result;
    }

    public SignedByte get(Integer i) {
        return this.bytes.get(i);
    }

    public int getByteLength() {
        return this.bytes.size();
    }

    public static int length() {
        return SignedByte.length();
    }

    public int size() {
        return this.bytes.size();
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        element.setContent(new Text(this.toString()));
        return element;
    }

    @Override
    public void decodeXML(Element element) {
        String byteString = element.getText().trim();
        this.bytes = new LinkedList<SignedByte>();
        int length = byteString.length();
        Integer i = 0;
        while (i < length) {
            this.bytes.add(new SignedByte(byteString.charAt(i)));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    @Override
    public String toString() {
        String s = "";
        for (SignedByte b : this.bytes) {
            s = s + b.toString();
        }
        return s;
    }

    @Override
    public String toString(int radix) {
        String s = "";
        for (SignedByte b : this.bytes) {
            s = s + b.toString(radix);
        }
        return s;
    }

    @Override
    public boolean inRange(String valueString) {
        String[] strings = valueString.split(" ");
        for (int i = 0; i < strings.length; ++i) {
            try {
                new SignedByte(strings[i]);
                continue;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return true;
    }
}

