/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.generated.LLRPMessageFactory;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPMessage;

public class Util {
    static final Logger LOGGER = Logger.getLogger("Util.class");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LLRPBitList loadBinaryFileContent(File file) throws IOException, FileNotFoundException {
        FileInputStream fis = new FileInputStream(file);
        byte[] buffer = new byte[2048];
        LLRPBitList bitlist = new LLRPBitList();
        try {
            int n = fis.read(buffer);
            while (n >= 0) {
                bitlist.append(new LLRPBitList(buffer, n));
                n = fis.read(buffer);
            }
        }
        finally {
            fis.close();
        }
        return bitlist;
    }

    public static String loadTextFileContent(File file) throws IOException, FileNotFoundException {
        FileReader fis = null;
        BufferedReader bis = null;
        StringBuffer buffer = new StringBuffer();
        fis = new FileReader(file);
        bis = new BufferedReader(fis);
        String line = bis.readLine();
        while (line != null) {
            buffer.append(line);
            line = bis.readLine();
        }
        return buffer.toString();
    }

    public static LLRPMessage loadBinaryLLRPMessage(File file) throws FileNotFoundException, IOException, InvalidLLRPMessageException {
        LLRPBitList bits = Util.loadBinaryFileContent(file);
        LOGGER.debug("Loaded binary message: " + bits.length());
        LLRPMessage message = LLRPMessageFactory.createLLRPMessage(bits);
        return message;
    }

    public static LLRPMessage loadXMLLLRPMessage(File file) throws FileNotFoundException, IOException, JDOMException, InvalidLLRPMessageException {
        Document doc = new SAXBuilder().build(new FileReader(file));
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        LOGGER.debug("Loaded XML Message: ");
        LLRPMessage message = LLRPMessageFactory.createLLRPMessage(doc);
        return message;
    }
}

