/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.enumerations;

import java.math.BigInteger;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPEnumeration;
import org.llrp.ltk.types.UnsignedByte;
import org.llrp.ltk.types.UnsignedByteArray;

public class AirProtocolsArray
extends UnsignedByteArray
implements LLRPEnumeration {
    public static final int Unspecified = 0;
    public static final int EPCGlobalClass1Gen2 = 1;
    Logger logger = Logger.getLogger(AirProtocolsArray.class);

    public AirProtocolsArray() {
        super(0);
    }

    public AirProtocolsArray(int value) {
        super(new Integer(value).toString());
        if (!this.isValidValue(value)) {
            throw new IllegalArgumentException("Value not allowed");
        }
    }

    public AirProtocolsArray(Element element) {
        String[] items = element.getText().split(" ");
        this.bytes = new UnsignedByte[items.length];
        for (int i = 0; i < items.length; ++i) {
            this.bytes[i] = new UnsignedByte(this.getValue(items[i]));
        }
    }

    public AirProtocolsArray(String element) {
        String[] items = element.split(" ");
        this.bytes = new UnsignedByte[items.length];
        for (int i = 0; i < items.length; ++i) {
            this.bytes[i] = new UnsignedByte(this.getValue(items[i]));
        }
    }

    public AirProtocolsArray(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public AirProtocolsArray(LLRPBitList list) {
        this.decodeBinary(list);
        if (!this.isValidValue(new Integer(this.toInteger()))) {
            throw new IllegalArgumentException("Value not allowed");
        }
    }

    public final void set(String name, int position) {
        if (!this.isValidName(name)) {
            throw new IllegalArgumentException("name not allowed");
        }
        if (position > this.bytes.length) {
            throw new IllegalArgumentException("position is bigger than array size");
        }
        this.bytes[position] = new UnsignedByte(this.getValue(name));
    }

    @Override
    public final void set(String name) {
        this.set(name, 0);
    }

    public final void set(int value, int position) {
        if (!this.isValidValue(value)) {
            throw new IllegalArgumentException("name not allowed");
        }
        if (position > this.bytes.length) {
            throw new IllegalArgumentException("position is bigger than array size");
        }
        this.bytes[position] = new UnsignedByte(value);
    }

    @Override
    public final void set(int value) {
        this.set(value, 0);
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        element.setContent((Content)new Text(this.toString()));
        return element;
    }

    @Override
    public String toString() {
        String s = "";
        for (UnsignedByte b : this.bytes) {
            s = s + " ";
            s = s + this.getName(b.toInteger());
        }
        return s.replaceFirst(" ", "");
    }

    @Override
    public int intValue() {
        return 0;
    }

    @Override
    public boolean isValidValue(int value) {
        switch (value) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final int getValue(String name) {
        if (name.equalsIgnoreCase("Unspecified")) {
            return 0;
        }
        if (name.equalsIgnoreCase("EPCGlobalClass1Gen2")) {
            return 1;
        }
        return -1;
    }

    @Override
    public final String getName(int value) {
        if (0 == value) {
            return "Unspecified";
        }
        if (1 == value) {
            return "EPCGlobalClass1Gen2";
        }
        return "";
    }

    @Override
    public boolean isValidName(String name) {
        if (name.equals("Unspecified")) {
            return true;
        }
        return name.equals("EPCGlobalClass1Gen2");
    }

    public static int length() {
        return UnsignedByteArray.length();
    }

    private final String getName(BigInteger value) {
        this.logger.warn((Object)("AirProtocolsArray must convert BigInteger " + value + " to Integer value " + value.intValue()));
        return this.getName(value.intValue());
    }

    private final boolean isValidValue(BigInteger value) {
        this.logger.warn((Object)("AirProtocolsArray must convert BigInteger " + value + " to Integer value " + value.intValue()));
        return this.isValidValue(value.intValue());
    }
}

