/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class GPITriggerValue
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(181);
    private static final Logger LOGGER = Logger.getLogger(GPITriggerValue.class);
    protected UnsignedShort gPIPortNum;
    protected Bit gPIEvent;
    protected BitList reserved0 = new BitList(7);
    protected UnsignedInteger timeout;

    public GPITriggerValue() {
    }

    public GPITriggerValue(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public GPITriggerValue(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public GPITriggerValue(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.gPIPortNum == null) {
            LOGGER.warn((Object)" gPIPortNum not set");
            throw new MissingParameterException(" gPIPortNum not set  for Parameter of Type GPITriggerValue");
        }
        resultBits.append(this.gPIPortNum.encodeBinary());
        if (this.gPIEvent == null) {
            LOGGER.warn((Object)" gPIEvent not set");
            throw new MissingParameterException(" gPIEvent not set  for Parameter of Type GPITriggerValue");
        }
        resultBits.append(this.gPIEvent.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        if (this.timeout == null) {
            LOGGER.warn((Object)" timeout not set");
            throw new MissingParameterException(" timeout not set  for Parameter of Type GPITriggerValue");
        }
        resultBits.append(this.timeout.encodeBinary());
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.gPIPortNum == null) {
            LOGGER.warn((Object)" gPIPortNum not set");
            throw new MissingParameterException(" gPIPortNum not set");
        }
        element.addContent(this.gPIPortNum.encodeXML("GPIPortNum", ns));
        if (this.gPIEvent == null) {
            LOGGER.warn((Object)" gPIEvent not set");
            throw new MissingParameterException(" gPIEvent not set");
        }
        element.addContent(this.gPIEvent.encodeXML("GPIEvent", ns));
        if (this.timeout == null) {
            LOGGER.warn((Object)" timeout not set");
            throw new MissingParameterException(" timeout not set");
        }
        element.addContent(this.timeout.encodeXML("Timeout", ns));
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.gPIPortNum = new UnsignedShort(binary, position, UnsignedShort.length());
        this.gPIEvent = new Bit(binary, position += UnsignedShort.length(), Bit.length());
        position += Bit.length();
        this.timeout = new UnsignedInteger(binary, position += this.reserved0.length(), UnsignedInteger.length());
        position += UnsignedInteger.length();
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("GPIPortNum", ns);
        if (temp != null) {
            this.gPIPortNum = new UnsignedShort(temp);
        }
        element.removeChild("GPIPortNum", ns);
        temp = element.getChild("GPIEvent", ns);
        if (temp != null) {
            this.gPIEvent = new Bit(temp);
        }
        element.removeChild("GPIEvent", ns);
        temp = element.getChild("Timeout", ns);
        if (temp != null) {
            this.timeout = new UnsignedInteger(temp);
        }
        element.removeChild("Timeout", ns);
        if (element.getChildren().size() > 0) {
            String message = "GPITriggerValue has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setGPIPortNum(UnsignedShort gPIPortNum) {
        this.gPIPortNum = gPIPortNum;
    }

    public void setGPIEvent(Bit gPIEvent) {
        this.gPIEvent = gPIEvent;
    }

    public void setTimeout(UnsignedInteger timeout) {
        this.timeout = timeout;
    }

    public UnsignedShort getGPIPortNum() {
        return this.gPIPortNum;
    }

    public Bit getGPIEvent() {
        return this.gPIEvent;
    }

    public UnsignedInteger getTimeout() {
        return this.timeout;
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "GPITriggerValue";
    }

    public String toString() {
        String result = "GPITriggerValue: ";
        result = result + ", gPIPortNum: ";
        result = result + this.gPIPortNum;
        result = result + ", gPIEvent: ";
        result = result + this.gPIEvent;
        result = result + ", timeout: ";
        result = result + this.timeout;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

