/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.parameters.ROSpecStartTrigger;
import org.llrp.ltk.generated.parameters.ROSpecStopTrigger;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class ROBoundarySpec
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(178);
    private static final Logger LOGGER = Logger.getLogger(ROBoundarySpec.class);
    protected ROSpecStartTrigger rOSpecStartTrigger;
    protected ROSpecStopTrigger rOSpecStopTrigger;

    public ROBoundarySpec() {
    }

    public ROBoundarySpec(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ROBoundarySpec(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public ROBoundarySpec(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.rOSpecStartTrigger == null) {
            LOGGER.warn((Object)" rOSpecStartTrigger not set");
            throw new MissingParameterException(" rOSpecStartTrigger not set");
        }
        resultBits.append(this.rOSpecStartTrigger.encodeBinary());
        if (this.rOSpecStopTrigger == null) {
            LOGGER.warn((Object)" rOSpecStopTrigger not set");
            throw new MissingParameterException(" rOSpecStopTrigger not set");
        }
        resultBits.append(this.rOSpecStopTrigger.encodeBinary());
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.rOSpecStartTrigger == null) {
            LOGGER.info((Object)"rOSpecStartTrigger not set");
            throw new MissingParameterException("rOSpecStartTrigger not set");
        }
        element.addContent(this.rOSpecStartTrigger.encodeXML(this.rOSpecStartTrigger.getClass().getSimpleName(), ns));
        if (this.rOSpecStopTrigger == null) {
            LOGGER.info((Object)"rOSpecStopTrigger not set");
            throw new MissingParameterException("rOSpecStopTrigger not set");
        }
        element.addContent(this.rOSpecStopTrigger.encodeXML(this.rOSpecStopTrigger.getClass().getSimpleName(), ns));
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        SignedShort type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.warn((Object)"ROBoundarySpec misses non optional parameter of type ROSpecStartTrigger");
            throw new MissingParameterException("ROBoundarySpec misses non optional parameter of type ROSpecStartTrigger");
        }
        if (binary.get(position)) {
            ROBoundarySpec rOBoundarySpec = this;
            tempLength = rOBoundarySpec.rOSpecStartTrigger.length();
        }
        if (type != null && type.equals(ROSpecStartTrigger.TYPENUM)) {
            this.rOSpecStartTrigger = new ROSpecStartTrigger(binary, position, tempLength);
            position += tempLength;
        } else {
            LOGGER.warn((Object)"ROBoundarySpec misses non optional parameter of type ROSpecStartTrigger");
            throw new MissingParameterException("ROBoundarySpec misses non optional parameter of type ROSpecStartTrigger");
        }
        LOGGER.trace((Object)(" rOSpecStartTrigger is instantiated with ROSpecStartTrigger with length" + tempLength));
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.warn((Object)"ROBoundarySpec misses non optional parameter of type ROSpecStopTrigger");
            throw new MissingParameterException("ROBoundarySpec misses non optional parameter of type ROSpecStopTrigger");
        }
        if (binary.get(position)) {
            ROBoundarySpec rOBoundarySpec = this;
            tempLength = rOBoundarySpec.rOSpecStopTrigger.length();
        }
        if (type != null && type.equals(ROSpecStopTrigger.TYPENUM)) {
            this.rOSpecStopTrigger = new ROSpecStopTrigger(binary, position, tempLength);
            position += tempLength;
        } else {
            LOGGER.warn((Object)"ROBoundarySpec misses non optional parameter of type ROSpecStopTrigger");
            throw new MissingParameterException("ROBoundarySpec misses non optional parameter of type ROSpecStopTrigger");
        }
        LOGGER.trace((Object)(" rOSpecStopTrigger is instantiated with ROSpecStopTrigger with length" + tempLength));
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("ROSpecStartTrigger", ns);
        if (temp != null) {
            this.rOSpecStartTrigger = new ROSpecStartTrigger(temp);
            LOGGER.info((Object)"setting parameter rOSpecStartTrigger for parameter ROBoundarySpec");
        }
        if (temp == null) {
            LOGGER.warn((Object)"ROBoundarySpec misses non optional parameter of type rOSpecStartTrigger");
            throw new MissingParameterException("ROBoundarySpec misses non optional parameter of type rOSpecStartTrigger");
        }
        element.removeChild("ROSpecStartTrigger", ns);
        temp = element.getChild("ROSpecStopTrigger", ns);
        if (temp != null) {
            this.rOSpecStopTrigger = new ROSpecStopTrigger(temp);
            LOGGER.info((Object)"setting parameter rOSpecStopTrigger for parameter ROBoundarySpec");
        }
        if (temp == null) {
            LOGGER.warn((Object)"ROBoundarySpec misses non optional parameter of type rOSpecStopTrigger");
            throw new MissingParameterException("ROBoundarySpec misses non optional parameter of type rOSpecStopTrigger");
        }
        element.removeChild("ROSpecStopTrigger", ns);
        if (element.getChildren().size() > 0) {
            String message = "ROBoundarySpec has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setROSpecStartTrigger(ROSpecStartTrigger rOSpecStartTrigger) {
        this.rOSpecStartTrigger = rOSpecStartTrigger;
    }

    public void setROSpecStopTrigger(ROSpecStopTrigger rOSpecStopTrigger) {
        this.rOSpecStopTrigger = rOSpecStopTrigger;
    }

    public ROSpecStartTrigger getROSpecStartTrigger() {
        return this.rOSpecStartTrigger;
    }

    public ROSpecStopTrigger getROSpecStopTrigger() {
        return this.rOSpecStopTrigger;
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "ROBoundarySpec";
    }

    public String toString() {
        String result = "ROBoundarySpec: ";
        result = result.replaceFirst(", ", "");
        return result;
    }
}

