/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPType;
import org.llrp.ltk.types.SignedShort;

public class SignedShortArray
extends LLRPType {
    protected SignedShort[] shorts;

    public SignedShortArray(SignedShort[] shorts) {
        this.shorts = (SignedShort[])shorts.clone();
    }

    public SignedShortArray(String shortString) {
        if (shortString.equals("")) {
            this.shorts = new SignedShort[0];
        } else {
            String[] strings = shortString.split(" ");
            this.shorts = new SignedShort[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                this.shorts[i] = new SignedShort(strings[i]);
            }
        }
    }

    public SignedShortArray(short[] data) {
        this.shorts = new SignedShort[data.length];
        for (int i = 0; i < data.length; ++i) {
            this.shorts[i] = new SignedShort((int)data[i]);
        }
    }

    public SignedShortArray(Element element) {
        this.decodeXML(element);
    }

    public SignedShortArray(int length) {
        this.shorts = new SignedShort[length];
    }

    public SignedShortArray(LLRPBitList bits) {
        this.decodeBinary(bits);
    }

    public SignedShortArray(LLRPBitList bitList, int bitIndex, int length) {
        this(bitList.subList(bitIndex, length));
    }

    public SignedShortArray() {
        this.shorts = new SignedShort[0];
    }

    @Override
    public void decodeBinary(LLRPBitList list) {
        Integer length = new SignedShort(list.subList(0, SignedShort.length())).toInteger();
        this.shorts = new SignedShort[length.intValue()];
        for (int i = 0; i < length; ++i) {
            this.shorts[i] = new SignedShort(list.subList(i * SignedShort.length() + SignedShort.length(), SignedShort.length()));
        }
    }

    @Override
    public LLRPBitList encodeBinary() {
        LLRPBitList result = new LLRPBitList();
        result.append(new SignedShort(this.shorts.length).encodeBinary());
        for (int i = 0; i < this.shorts.length; ++i) {
            result.append(this.shorts[i].encodeBinary());
        }
        return result;
    }

    public boolean equals(LLRPType other) {
        SignedShortArray ba = (SignedShortArray)other;
        if (ba.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.shorts.length; ++i) {
            if (ba.get(i).equals(this.get(i))) continue;
            return false;
        }
        return true;
    }

    public SignedShort get(int i) {
        return this.shorts[i];
    }

    public int getBitLength() {
        return this.shorts.length * SignedShort.length();
    }

    public int getByteLength() {
        return this.shorts.length * 2;
    }

    public static int length() {
        return SignedShort.length();
    }

    public void set(int i, SignedShort b) {
        if (i < 0 || i > this.shorts.length) {
            return;
        }
        this.shorts[i] = b;
    }

    public int size() {
        return this.shorts.length;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        element.setContent((Content)new Text(this.toString()));
        return element;
    }

    @Override
    public void decodeXML(Element element) {
        String text = element.getText().trim();
        if (text == null || text.equals("")) {
            this.shorts = new SignedShort[0];
            return;
        }
        String[] strings = text.split("\\s+");
        this.shorts = new SignedShort[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            this.shorts[i] = new SignedShort(strings[i]);
        }
    }

    public void add(SignedShort aShort) {
        SignedShort[] newShorts = new SignedShort[this.shorts.length + 1];
        System.arraycopy(this.shorts, 0, newShorts, 0, this.shorts.length);
        newShorts[this.shorts.length] = aShort;
        this.shorts = newShorts;
    }

    public int hashCode() {
        return this.shorts.hashCode();
    }

    public short[] toShortArray() {
        short[] result = new short[this.shorts.length];
        for (int i = 0; i < this.shorts.length; ++i) {
            result[i] = this.shorts[i].toShort();
        }
        return result;
    }

    @Override
    public String toString(int radix) {
        String s = "";
        for (SignedShort b : this.shorts) {
            if (b == null) continue;
            s = s + " " + b.toString(radix);
        }
        return s;
    }

    @Override
    public String toString() {
        String s = "";
        for (SignedShort b : this.shorts) {
            if (b == null) continue;
            s = s + " " + b.toInteger().toString();
        }
        s = s.replaceFirst(" ", "");
        return s;
    }

    @Override
    public boolean inRange(String valueString) {
        String[] strings = valueString.trim().split("\\s+");
        for (int i = 0; i < strings.length; ++i) {
            try {
                new SignedShort(strings[i]);
                continue;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return true;
    }
}

