/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.UnsignedLong;

public class UnsignedLong_DATETIME
extends UnsignedLong {
    public UnsignedLong_DATETIME(long aLong) {
        super(aLong);
    }

    public UnsignedLong_DATETIME() {
        this.value = BigInteger.ZERO;
    }

    public UnsignedLong_DATETIME(String string) {
        Element element = new Element("foo", "ns");
        element.setText(string);
        this.decodeXML(element);
    }

    public UnsignedLong_DATETIME(Element element) {
        super(element);
    }

    public UnsignedLong_DATETIME(LLRPBitList bitList) {
        super(bitList);
    }

    public UnsignedLong_DATETIME(LLRPBitList bitList, int bitIndex, int length) {
        super(bitList, bitIndex, length);
    }

    public static int length() {
        return 64;
    }

    @Override
    public void decodeXML(Element element) {
        try {
            DatatypeFactory df = DatatypeFactory.newInstance();
            XMLGregorianCalendar cal = df.newXMLGregorianCalendar(element.getText().trim());
            this.value = BigInteger.valueOf(cal.toGregorianCalendar().getTimeInMillis() * 1000L);
            BigDecimal millisec = cal.getFractionalSecond().setScale(3, 1);
            BigDecimal microsec = cal.getFractionalSecond().setScale(6, 1).subtract(millisec);
            this.value = this.value.add(microsec.movePointRight(6).toBigInteger());
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        GregorianCalendar cal = new GregorianCalendar();
        long milliseconds = this.value.divide(new BigInteger("1000")).longValue();
        cal.setTimeInMillis(milliseconds);
        StringBuffer sb = new StringBuffer();
        try {
            DatatypeFactory df = DatatypeFactory.newInstance();
            XMLGregorianCalendar xmlcal = df.newXMLGregorianCalendar(cal);
            sb.append(xmlcal.normalize().toXMLFormat());
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        int indexOfT = sb.indexOf("T");
        int l = this.value.toString().length();
        String microseconds = this.value.toString().substring(l - 3, l);
        sb.insert(indexOfT + 13, microseconds);
        Element element = new Element(name, ns);
        element.setContent((Content)new Text(sb.toString()));
        return element;
    }

    @Override
    public String toString() {
        return this.encodeXML("foo", Namespace.getNamespace((String)"foo")).getValue();
    }
}

