/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.interfaces.AccessCommandOpSpec;
import org.llrp.ltk.generated.interfaces.AirProtocolOpSpec;
import org.llrp.ltk.generated.interfaces.C1G2OpSpec;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.TwoBitField;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class C1G2Read
extends TLVParameter
implements AccessCommandOpSpec,
C1G2OpSpec,
AirProtocolOpSpec {
    public static final SignedShort TYPENUM = new SignedShort(341);
    private static final Logger LOGGER = Logger.getLogger(C1G2Read.class);
    protected UnsignedShort opSpecID;
    protected UnsignedInteger accessPassword;
    protected TwoBitField mB;
    protected BitList reserved0 = new BitList(6);
    protected UnsignedShort wordPointer;
    protected UnsignedShort wordCount;

    public C1G2Read() {
    }

    public C1G2Read(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public C1G2Read(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public C1G2Read(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.opSpecID == null) {
            LOGGER.warn((Object)" opSpecID not set");
            throw new MissingParameterException(" opSpecID not set  for Parameter of Type C1G2Read");
        }
        resultBits.append(this.opSpecID.encodeBinary());
        if (this.accessPassword == null) {
            LOGGER.warn((Object)" accessPassword not set");
            throw new MissingParameterException(" accessPassword not set  for Parameter of Type C1G2Read");
        }
        resultBits.append(this.accessPassword.encodeBinary());
        if (this.mB == null) {
            LOGGER.warn((Object)" mB not set");
            throw new MissingParameterException(" mB not set  for Parameter of Type C1G2Read");
        }
        resultBits.append(this.mB.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        if (this.wordPointer == null) {
            LOGGER.warn((Object)" wordPointer not set");
            throw new MissingParameterException(" wordPointer not set  for Parameter of Type C1G2Read");
        }
        resultBits.append(this.wordPointer.encodeBinary());
        if (this.wordCount == null) {
            LOGGER.warn((Object)" wordCount not set");
            throw new MissingParameterException(" wordCount not set  for Parameter of Type C1G2Read");
        }
        resultBits.append(this.wordCount.encodeBinary());
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.opSpecID == null) {
            LOGGER.warn((Object)" opSpecID not set");
            throw new MissingParameterException(" opSpecID not set");
        }
        element.addContent(this.opSpecID.encodeXML("OpSpecID", ns));
        if (this.accessPassword == null) {
            LOGGER.warn((Object)" accessPassword not set");
            throw new MissingParameterException(" accessPassword not set");
        }
        element.addContent(this.accessPassword.encodeXML("AccessPassword", ns));
        if (this.mB == null) {
            LOGGER.warn((Object)" mB not set");
            throw new MissingParameterException(" mB not set");
        }
        element.addContent(this.mB.encodeXML("MB", ns));
        if (this.wordPointer == null) {
            LOGGER.warn((Object)" wordPointer not set");
            throw new MissingParameterException(" wordPointer not set");
        }
        element.addContent(this.wordPointer.encodeXML("WordPointer", ns));
        if (this.wordCount == null) {
            LOGGER.warn((Object)" wordCount not set");
            throw new MissingParameterException(" wordCount not set");
        }
        element.addContent(this.wordCount.encodeXML("WordCount", ns));
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.opSpecID = new UnsignedShort(binary, position, UnsignedShort.length());
        this.accessPassword = new UnsignedInteger(binary, position += UnsignedShort.length(), UnsignedInteger.length());
        this.mB = new TwoBitField(binary, position += UnsignedInteger.length(), TwoBitField.length());
        position += TwoBitField.length();
        this.wordPointer = new UnsignedShort(binary, position += this.reserved0.length(), UnsignedShort.length());
        this.wordCount = new UnsignedShort(binary, position += UnsignedShort.length(), UnsignedShort.length());
        position += UnsignedShort.length();
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("OpSpecID", ns);
        if (temp != null) {
            this.opSpecID = new UnsignedShort(temp);
        }
        element.removeChild("OpSpecID", ns);
        temp = element.getChild("AccessPassword", ns);
        if (temp != null) {
            this.accessPassword = new UnsignedInteger(temp);
        }
        element.removeChild("AccessPassword", ns);
        temp = element.getChild("MB", ns);
        if (temp != null) {
            this.mB = new TwoBitField(temp);
        }
        element.removeChild("MB", ns);
        temp = element.getChild("WordPointer", ns);
        if (temp != null) {
            this.wordPointer = new UnsignedShort(temp);
        }
        element.removeChild("WordPointer", ns);
        temp = element.getChild("WordCount", ns);
        if (temp != null) {
            this.wordCount = new UnsignedShort(temp);
        }
        element.removeChild("WordCount", ns);
        if (element.getChildren().size() > 0) {
            String message = "C1G2Read has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setOpSpecID(UnsignedShort opSpecID) {
        this.opSpecID = opSpecID;
    }

    public void setAccessPassword(UnsignedInteger accessPassword) {
        this.accessPassword = accessPassword;
    }

    public void setMB(TwoBitField mB) {
        this.mB = mB;
    }

    public void setWordPointer(UnsignedShort wordPointer) {
        this.wordPointer = wordPointer;
    }

    public void setWordCount(UnsignedShort wordCount) {
        this.wordCount = wordCount;
    }

    public UnsignedShort getOpSpecID() {
        return this.opSpecID;
    }

    public UnsignedInteger getAccessPassword() {
        return this.accessPassword;
    }

    public TwoBitField getMB() {
        return this.mB;
    }

    public UnsignedShort getWordPointer() {
        return this.wordPointer;
    }

    public UnsignedShort getWordCount() {
        return this.wordCount;
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "C1G2Read";
    }

    public String toString() {
        String result = "C1G2Read: ";
        result = result + ", opSpecID: ";
        result = result + this.opSpecID;
        result = result + ", accessPassword: ";
        result = result + this.accessPassword;
        result = result + ", mB: ";
        result = result + this.mB;
        result = result + ", wordPointer: ";
        result = result + this.wordPointer;
        result = result + ", wordCount: ";
        result = result + this.wordCount;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

