/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.parameters.FixedFrequencyTable;
import org.llrp.ltk.generated.parameters.FrequencyHopTable;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class FrequencyInformation
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(146);
    private static final Logger LOGGER = Logger.getLogger(FrequencyInformation.class);
    protected Bit hopping;
    protected BitList reserved0 = new BitList(7);
    protected List<FrequencyHopTable> frequencyHopTableList = new LinkedList<FrequencyHopTable>();
    protected FixedFrequencyTable fixedFrequencyTable;

    public FrequencyInformation() {
    }

    public FrequencyInformation(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public FrequencyInformation(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public FrequencyInformation(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.hopping == null) {
            LOGGER.warn((Object)" hopping not set");
            throw new MissingParameterException(" hopping not set  for Parameter of Type FrequencyInformation");
        }
        resultBits.append(this.hopping.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        if (this.frequencyHopTableList == null) {
            LOGGER.info((Object)" frequencyHopTableList not set");
        } else {
            for (FrequencyHopTable field : this.frequencyHopTableList) {
                resultBits.append(field.encodeBinary());
            }
        }
        if (this.fixedFrequencyTable == null) {
            LOGGER.info((Object)" fixedFrequencyTable not set");
        } else {
            resultBits.append(this.fixedFrequencyTable.encodeBinary());
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.hopping == null) {
            LOGGER.warn((Object)" hopping not set");
            throw new MissingParameterException(" hopping not set");
        }
        element.addContent(this.hopping.encodeXML("Hopping", ns));
        if (this.frequencyHopTableList == null) {
            LOGGER.info((Object)"frequencyHopTableList not set");
        } else {
            for (FrequencyHopTable field : this.frequencyHopTableList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        if (this.fixedFrequencyTable == null) {
            LOGGER.info((Object)"fixedFrequencyTable not set");
        } else {
            element.addContent(this.fixedFrequencyTable.encodeXML(this.fixedFrequencyTable.getClass().getSimpleName(), ns));
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        short tempByteLength;
        SignedShort type;
        int position = 0;
        int tempLength = 0;
        this.hopping = new Bit(binary, position, Bit.length());
        position += Bit.length();
        position += this.reserved0.length();
        this.frequencyHopTableList = new LinkedList<FrequencyHopTable>();
        LOGGER.trace((Object)"decoding parameter frequencyHopTableList ");
        while (position < binary.length()) {
            boolean foundOne = false;
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(FrequencyHopTable.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = FrequencyHopTable.length();
                }
                this.frequencyHopTableList.add(new FrequencyHopTable(binary, position, tempLength));
                LOGGER.trace((Object)"adding FrequencyHopTable to frequencyHopTableList ");
                foundOne = true;
                position += tempLength;
            }
            if (foundOne) continue;
            break;
        }
        if (this.frequencyHopTableList.isEmpty()) {
            LOGGER.trace((Object)"FrequencyInformation misses optional parameter of type FrequencyHopTable");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace((Object)"FrequencyInformation misses optional parameter of type FixedFrequencyTable");
        }
        if (binary.get(position)) {
            FrequencyInformation frequencyInformation = this;
            tempLength = frequencyInformation.fixedFrequencyTable.length();
        }
        if (type != null && type.equals(FixedFrequencyTable.TYPENUM)) {
            this.fixedFrequencyTable = new FixedFrequencyTable(binary, position, tempLength);
            position += tempLength;
            LOGGER.trace((Object)(" fixedFrequencyTable is instantiated with FixedFrequencyTable with length" + tempLength));
        } else {
            LOGGER.trace((Object)"FrequencyInformation misses optional parameter of type FixedFrequencyTable");
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        List tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("Hopping", ns);
        if (temp != null) {
            this.hopping = new Bit(temp);
        }
        element.removeChild("Hopping", ns);
        this.frequencyHopTableList = new LinkedList<FrequencyHopTable>();
        tempList = element.getChildren("FrequencyHopTable", ns);
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.trace((Object)"FrequencyInformation misses optional parameter of type frequencyHopTableList");
        } else {
            for (Element e : tempList) {
                this.frequencyHopTableList.add(new FrequencyHopTable(e));
                LOGGER.trace((Object)"adding FrequencyHopTable to frequencyHopTableList ");
            }
        }
        element.removeChildren("FrequencyHopTable", ns);
        temp = element.getChild("FixedFrequencyTable", ns);
        if (temp != null) {
            this.fixedFrequencyTable = new FixedFrequencyTable(temp);
            LOGGER.info((Object)"setting parameter fixedFrequencyTable for parameter FrequencyInformation");
        }
        if (temp == null) {
            LOGGER.trace((Object)"FrequencyInformation misses optional parameter of type fixedFrequencyTable");
        }
        element.removeChild("FixedFrequencyTable", ns);
        if (element.getChildren().size() > 0) {
            String message = "FrequencyInformation has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setHopping(Bit hopping) {
        this.hopping = hopping;
    }

    public void setFrequencyHopTableList(List<FrequencyHopTable> frequencyHopTableList) {
        this.frequencyHopTableList = frequencyHopTableList;
    }

    public void setFixedFrequencyTable(FixedFrequencyTable fixedFrequencyTable) {
        this.fixedFrequencyTable = fixedFrequencyTable;
    }

    public Bit getHopping() {
        return this.hopping;
    }

    public List<FrequencyHopTable> getFrequencyHopTableList() {
        return this.frequencyHopTableList;
    }

    public FixedFrequencyTable getFixedFrequencyTable() {
        return this.fixedFrequencyTable;
    }

    public void addToFrequencyHopTableList(FrequencyHopTable frequencyHopTable) {
        if (this.frequencyHopTableList == null) {
            this.frequencyHopTableList = new LinkedList<FrequencyHopTable>();
        }
        this.frequencyHopTableList.add(frequencyHopTable);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "FrequencyInformation";
    }

    public String toString() {
        String result = "FrequencyInformation: ";
        result = result + ", hopping: ";
        result = result + this.hopping;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

