/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.custom.LLRPKnownCustom;
import org.llrp.ltk.generated.custom.parameters.ImpinjBlockPermalockOpSpecResult;
import org.llrp.ltk.generated.custom.parameters.ImpinjGPSCoordinates;
import org.llrp.ltk.generated.custom.parameters.ImpinjGetBlockPermalockStatusOpSpecResult;
import org.llrp.ltk.generated.custom.parameters.ImpinjGetQTConfigOpSpecResult;
import org.llrp.ltk.generated.custom.parameters.ImpinjMarginReadOpSpecResult;
import org.llrp.ltk.generated.custom.parameters.ImpinjPeakRSSI;
import org.llrp.ltk.generated.custom.parameters.ImpinjRFDopplerFrequency;
import org.llrp.ltk.generated.custom.parameters.ImpinjRFPhaseAngle;
import org.llrp.ltk.generated.custom.parameters.ImpinjSerializedTID;
import org.llrp.ltk.generated.custom.parameters.ImpinjSetQTConfigOpSpecResult;
import org.llrp.ltk.generated.custom.parameters.ImpinjTxPower;
import org.llrp.ltk.generated.interfaces.AccessCommandOpSpecResult;
import org.llrp.ltk.generated.interfaces.AirProtocolTagData;
import org.llrp.ltk.generated.interfaces.EPCParameter;
import org.llrp.ltk.generated.parameters.AccessSpecID;
import org.llrp.ltk.generated.parameters.AntennaID;
import org.llrp.ltk.generated.parameters.C1G2BlockEraseOpSpecResult;
import org.llrp.ltk.generated.parameters.C1G2BlockWriteOpSpecResult;
import org.llrp.ltk.generated.parameters.C1G2KillOpSpecResult;
import org.llrp.ltk.generated.parameters.C1G2LockOpSpecResult;
import org.llrp.ltk.generated.parameters.C1G2ReadOpSpecResult;
import org.llrp.ltk.generated.parameters.C1G2WriteOpSpecResult;
import org.llrp.ltk.generated.parameters.C1G2_CRC;
import org.llrp.ltk.generated.parameters.C1G2_PC;
import org.llrp.ltk.generated.parameters.ChannelIndex;
import org.llrp.ltk.generated.parameters.ClientRequestOpSpecResult;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.generated.parameters.EPCData;
import org.llrp.ltk.generated.parameters.EPC_96;
import org.llrp.ltk.generated.parameters.FirstSeenTimestampUTC;
import org.llrp.ltk.generated.parameters.FirstSeenTimestampUptime;
import org.llrp.ltk.generated.parameters.InventoryParameterSpecID;
import org.llrp.ltk.generated.parameters.LastSeenTimestampUTC;
import org.llrp.ltk.generated.parameters.LastSeenTimestampUptime;
import org.llrp.ltk.generated.parameters.PeakRSSI;
import org.llrp.ltk.generated.parameters.ROSpecID;
import org.llrp.ltk.generated.parameters.SpecIndex;
import org.llrp.ltk.generated.parameters.TagSeenCount;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class TagReportData
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(240);
    private static final Logger LOGGER = Logger.getLogger(TagReportData.class);
    protected EPCParameter ePCParameter;
    protected ROSpecID rOSpecID;
    protected SpecIndex specIndex;
    protected InventoryParameterSpecID inventoryParameterSpecID;
    protected AntennaID antennaID;
    protected PeakRSSI peakRSSI;
    protected ChannelIndex channelIndex;
    protected FirstSeenTimestampUTC firstSeenTimestampUTC;
    protected FirstSeenTimestampUptime firstSeenTimestampUptime;
    protected LastSeenTimestampUTC lastSeenTimestampUTC;
    protected LastSeenTimestampUptime lastSeenTimestampUptime;
    protected TagSeenCount tagSeenCount;
    protected List<AirProtocolTagData> airProtocolTagDataList = new LinkedList<AirProtocolTagData>();
    protected AccessSpecID accessSpecID;
    protected List<AccessCommandOpSpecResult> accessCommandOpSpecResultList = new LinkedList<AccessCommandOpSpecResult>();
    protected List<Custom> customList = new LinkedList<Custom>();

    public TagReportData() {
    }

    public TagReportData(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public TagReportData(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public TagReportData(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.ePCParameter == null) {
            LOGGER.warn((Object)" ePCParameter not set");
            throw new MissingParameterException(" ePCParameter not set");
        }
        resultBits.append(this.ePCParameter.encodeBinary());
        if (this.rOSpecID == null) {
            LOGGER.info((Object)" rOSpecID not set");
        } else {
            resultBits.append(this.rOSpecID.encodeBinary());
        }
        if (this.specIndex == null) {
            LOGGER.info((Object)" specIndex not set");
        } else {
            resultBits.append(this.specIndex.encodeBinary());
        }
        if (this.inventoryParameterSpecID == null) {
            LOGGER.info((Object)" inventoryParameterSpecID not set");
        } else {
            resultBits.append(this.inventoryParameterSpecID.encodeBinary());
        }
        if (this.antennaID == null) {
            LOGGER.info((Object)" antennaID not set");
        } else {
            resultBits.append(this.antennaID.encodeBinary());
        }
        if (this.peakRSSI == null) {
            LOGGER.info((Object)" peakRSSI not set");
        } else {
            resultBits.append(this.peakRSSI.encodeBinary());
        }
        if (this.channelIndex == null) {
            LOGGER.info((Object)" channelIndex not set");
        } else {
            resultBits.append(this.channelIndex.encodeBinary());
        }
        if (this.firstSeenTimestampUTC == null) {
            LOGGER.info((Object)" firstSeenTimestampUTC not set");
        } else {
            resultBits.append(this.firstSeenTimestampUTC.encodeBinary());
        }
        if (this.firstSeenTimestampUptime == null) {
            LOGGER.info((Object)" firstSeenTimestampUptime not set");
        } else {
            resultBits.append(this.firstSeenTimestampUptime.encodeBinary());
        }
        if (this.lastSeenTimestampUTC == null) {
            LOGGER.info((Object)" lastSeenTimestampUTC not set");
        } else {
            resultBits.append(this.lastSeenTimestampUTC.encodeBinary());
        }
        if (this.lastSeenTimestampUptime == null) {
            LOGGER.info((Object)" lastSeenTimestampUptime not set");
        } else {
            resultBits.append(this.lastSeenTimestampUptime.encodeBinary());
        }
        if (this.tagSeenCount == null) {
            LOGGER.info((Object)" tagSeenCount not set");
        } else {
            resultBits.append(this.tagSeenCount.encodeBinary());
        }
        if (this.airProtocolTagDataList == null) {
            LOGGER.info((Object)" airProtocolTagDataList not set");
        } else {
            for (AirProtocolTagData airProtocolTagData : this.airProtocolTagDataList) {
                resultBits.append(airProtocolTagData.encodeBinary());
            }
        }
        if (this.accessSpecID == null) {
            LOGGER.info((Object)" accessSpecID not set");
        } else {
            resultBits.append(this.accessSpecID.encodeBinary());
        }
        if (this.accessCommandOpSpecResultList == null) {
            LOGGER.info((Object)" accessCommandOpSpecResultList not set");
        } else {
            for (AccessCommandOpSpecResult accessCommandOpSpecResult : this.accessCommandOpSpecResultList) {
                resultBits.append(accessCommandOpSpecResult.encodeBinary());
            }
        }
        if (this.customList == null) {
            LOGGER.info((Object)" customList not set");
        } else {
            for (Custom custom : this.customList) {
                resultBits.append(custom.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace((String)"llrp", (String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.ePCParameter == null) {
            LOGGER.info((Object)"ePCParameter not set");
            throw new MissingParameterException("ePCParameter not set");
        }
        element.addContent(this.ePCParameter.encodeXML(this.ePCParameter.getClass().getSimpleName(), ns));
        if (this.rOSpecID == null) {
            LOGGER.info((Object)"rOSpecID not set");
        } else {
            element.addContent(this.rOSpecID.encodeXML(this.rOSpecID.getClass().getSimpleName(), ns));
        }
        if (this.specIndex == null) {
            LOGGER.info((Object)"specIndex not set");
        } else {
            element.addContent(this.specIndex.encodeXML(this.specIndex.getClass().getSimpleName(), ns));
        }
        if (this.inventoryParameterSpecID == null) {
            LOGGER.info((Object)"inventoryParameterSpecID not set");
        } else {
            element.addContent(this.inventoryParameterSpecID.encodeXML(this.inventoryParameterSpecID.getClass().getSimpleName(), ns));
        }
        if (this.antennaID == null) {
            LOGGER.info((Object)"antennaID not set");
        } else {
            element.addContent(this.antennaID.encodeXML(this.antennaID.getClass().getSimpleName(), ns));
        }
        if (this.peakRSSI == null) {
            LOGGER.info((Object)"peakRSSI not set");
        } else {
            element.addContent(this.peakRSSI.encodeXML(this.peakRSSI.getClass().getSimpleName(), ns));
        }
        if (this.channelIndex == null) {
            LOGGER.info((Object)"channelIndex not set");
        } else {
            element.addContent(this.channelIndex.encodeXML(this.channelIndex.getClass().getSimpleName(), ns));
        }
        if (this.firstSeenTimestampUTC == null) {
            LOGGER.info((Object)"firstSeenTimestampUTC not set");
        } else {
            element.addContent(this.firstSeenTimestampUTC.encodeXML(this.firstSeenTimestampUTC.getClass().getSimpleName(), ns));
        }
        if (this.firstSeenTimestampUptime == null) {
            LOGGER.info((Object)"firstSeenTimestampUptime not set");
        } else {
            element.addContent(this.firstSeenTimestampUptime.encodeXML(this.firstSeenTimestampUptime.getClass().getSimpleName(), ns));
        }
        if (this.lastSeenTimestampUTC == null) {
            LOGGER.info((Object)"lastSeenTimestampUTC not set");
        } else {
            element.addContent(this.lastSeenTimestampUTC.encodeXML(this.lastSeenTimestampUTC.getClass().getSimpleName(), ns));
        }
        if (this.lastSeenTimestampUptime == null) {
            LOGGER.info((Object)"lastSeenTimestampUptime not set");
        } else {
            element.addContent(this.lastSeenTimestampUptime.encodeXML(this.lastSeenTimestampUptime.getClass().getSimpleName(), ns));
        }
        if (this.tagSeenCount == null) {
            LOGGER.info((Object)"tagSeenCount not set");
        } else {
            element.addContent(this.tagSeenCount.encodeXML(this.tagSeenCount.getClass().getSimpleName(), ns));
        }
        if (this.airProtocolTagDataList == null) {
            LOGGER.info((Object)"airProtocolTagDataList not set");
        } else {
            for (AirProtocolTagData airProtocolTagData : this.airProtocolTagDataList) {
                element.addContent(airProtocolTagData.encodeXML(airProtocolTagData.getClass().getName().replaceAll(airProtocolTagData.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        if (this.accessSpecID == null) {
            LOGGER.info((Object)"accessSpecID not set");
        } else {
            element.addContent(this.accessSpecID.encodeXML(this.accessSpecID.getClass().getSimpleName(), ns));
        }
        if (this.accessCommandOpSpecResultList == null) {
            LOGGER.info((Object)"accessCommandOpSpecResultList not set");
        } else {
            for (AccessCommandOpSpecResult accessCommandOpSpecResult : this.accessCommandOpSpecResultList) {
                element.addContent(accessCommandOpSpecResult.encodeXML(accessCommandOpSpecResult.getClass().getName().replaceAll(accessCommandOpSpecResult.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        if (this.customList == null) {
            LOGGER.info((Object)"customList not set");
        } else {
            for (Custom custom : this.customList) {
                element.addContent(custom.encodeXML(custom.getClass().getName().replaceAll(custom.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        Custom cus;
        int position = 0;
        int tempLength = 0;
        SignedShort type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.warn((Object)"TagReportData misses non optional parameter of type EPCParameter");
            throw new MissingParameterException("TagReportData misses non optional parameter of type EPCParameter");
        }
        boolean found = false;
        LOGGER.trace((Object)"decoding choice type EPCParameter ");
        if (binary.get(position)) {
            tempLength = EPCData.length();
        }
        if (type != null && type.equals(EPCData.TYPENUM)) {
            this.ePCParameter = new EPCData(binary, position, tempLength);
            LOGGER.trace((Object)(" ePCParameter instatiated to EPCData with length " + tempLength));
            position += tempLength;
            found = true;
        }
        if (binary.get(position)) {
            tempLength = EPC_96.length();
        }
        if (type != null && type.equals(EPC_96.TYPENUM)) {
            this.ePCParameter = new EPC_96(binary, position, tempLength);
            LOGGER.trace((Object)(" ePCParameter instatiated to EPC_96 with length " + tempLength));
            position += tempLength;
            found = true;
        }
        if (!found) {
            LOGGER.warn((Object)"encoded message misses non optional parameter ePCParameter");
            throw new MissingParameterException("TagReportData misses non optional parameter of type EPCParameter");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type ROSpecID");
        }
        if (binary.get(position)) {
            TagReportData tagReportData = this;
            tempLength = tagReportData.rOSpecID.length();
        }
        if (type != null && type.equals(ROSpecID.TYPENUM)) {
            this.rOSpecID = new ROSpecID(binary, position, tempLength);
            position += tempLength;
            LOGGER.trace((Object)(" rOSpecID is instantiated with ROSpecID with length" + tempLength));
        } else {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type ROSpecID");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type SpecIndex");
        }
        if (binary.get(position)) {
            TagReportData tagReportData = this;
            tempLength = tagReportData.specIndex.length();
        }
        if (type != null && type.equals(SpecIndex.TYPENUM)) {
            this.specIndex = new SpecIndex(binary, position, tempLength);
            position += tempLength;
            LOGGER.trace((Object)(" specIndex is instantiated with SpecIndex with length" + tempLength));
        } else {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type SpecIndex");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type InventoryParameterSpecID");
        }
        if (binary.get(position)) {
            TagReportData tagReportData = this;
            tempLength = tagReportData.inventoryParameterSpecID.length();
        }
        if (type != null && type.equals(InventoryParameterSpecID.TYPENUM)) {
            this.inventoryParameterSpecID = new InventoryParameterSpecID(binary, position, tempLength);
            position += tempLength;
            LOGGER.trace((Object)(" inventoryParameterSpecID is instantiated with InventoryParameterSpecID with length" + tempLength));
        } else {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type InventoryParameterSpecID");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type AntennaID");
        }
        if (binary.get(position)) {
            TagReportData tagReportData = this;
            tempLength = tagReportData.antennaID.length();
        }
        if (type != null && type.equals(AntennaID.TYPENUM)) {
            this.antennaID = new AntennaID(binary, position, tempLength);
            position += tempLength;
            LOGGER.trace((Object)(" antennaID is instantiated with AntennaID with length" + tempLength));
        } else {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type AntennaID");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type PeakRSSI");
        }
        if (binary.get(position)) {
            TagReportData tagReportData = this;
            tempLength = tagReportData.peakRSSI.length();
        }
        if (type != null && type.equals(PeakRSSI.TYPENUM)) {
            this.peakRSSI = new PeakRSSI(binary, position, tempLength);
            position += tempLength;
            LOGGER.trace((Object)(" peakRSSI is instantiated with PeakRSSI with length" + tempLength));
        } else {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type PeakRSSI");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type ChannelIndex");
        }
        if (binary.get(position)) {
            TagReportData tagReportData = this;
            tempLength = tagReportData.channelIndex.length();
        }
        if (type != null && type.equals(ChannelIndex.TYPENUM)) {
            this.channelIndex = new ChannelIndex(binary, position, tempLength);
            position += tempLength;
            LOGGER.trace((Object)(" channelIndex is instantiated with ChannelIndex with length" + tempLength));
        } else {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type ChannelIndex");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type FirstSeenTimestampUTC");
        }
        if (binary.get(position)) {
            TagReportData tagReportData = this;
            tempLength = tagReportData.firstSeenTimestampUTC.length();
        }
        if (type != null && type.equals(FirstSeenTimestampUTC.TYPENUM)) {
            this.firstSeenTimestampUTC = new FirstSeenTimestampUTC(binary, position, tempLength);
            position += tempLength;
            LOGGER.trace((Object)(" firstSeenTimestampUTC is instantiated with FirstSeenTimestampUTC with length" + tempLength));
        } else {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type FirstSeenTimestampUTC");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type FirstSeenTimestampUptime");
        }
        if (binary.get(position)) {
            TagReportData tagReportData = this;
            tempLength = tagReportData.firstSeenTimestampUptime.length();
        }
        if (type != null && type.equals(FirstSeenTimestampUptime.TYPENUM)) {
            this.firstSeenTimestampUptime = new FirstSeenTimestampUptime(binary, position, tempLength);
            position += tempLength;
            LOGGER.trace((Object)(" firstSeenTimestampUptime is instantiated with FirstSeenTimestampUptime with length" + tempLength));
        } else {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type FirstSeenTimestampUptime");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type LastSeenTimestampUTC");
        }
        if (binary.get(position)) {
            TagReportData tagReportData = this;
            tempLength = tagReportData.lastSeenTimestampUTC.length();
        }
        if (type != null && type.equals(LastSeenTimestampUTC.TYPENUM)) {
            this.lastSeenTimestampUTC = new LastSeenTimestampUTC(binary, position, tempLength);
            position += tempLength;
            LOGGER.trace((Object)(" lastSeenTimestampUTC is instantiated with LastSeenTimestampUTC with length" + tempLength));
        } else {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type LastSeenTimestampUTC");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type LastSeenTimestampUptime");
        }
        if (binary.get(position)) {
            TagReportData tagReportData = this;
            tempLength = tagReportData.lastSeenTimestampUptime.length();
        }
        if (type != null && type.equals(LastSeenTimestampUptime.TYPENUM)) {
            this.lastSeenTimestampUptime = new LastSeenTimestampUptime(binary, position, tempLength);
            position += tempLength;
            LOGGER.trace((Object)(" lastSeenTimestampUptime is instantiated with LastSeenTimestampUptime with length" + tempLength));
        } else {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type LastSeenTimestampUptime");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type TagSeenCount");
        }
        if (binary.get(position)) {
            TagReportData tagReportData = this;
            tempLength = tagReportData.tagSeenCount.length();
        }
        if (type != null && type.equals(TagSeenCount.TYPENUM)) {
            this.tagSeenCount = new TagSeenCount(binary, position, tempLength);
            position += tempLength;
            LOGGER.trace((Object)(" tagSeenCount is instantiated with TagSeenCount with length" + tempLength));
        } else {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type TagSeenCount");
        }
        this.airProtocolTagDataList = new LinkedList<AirProtocolTagData>();
        LOGGER.trace((Object)"decoding parameter airProtocolTagDataList ");
        while (position < binary.length()) {
            boolean foundOne = false;
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(C1G2_PC.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2_PC.length();
                }
                this.airProtocolTagDataList.add(new C1G2_PC(binary, position, tempLength));
                LOGGER.trace((Object)"adding C1G2_PC to airProtocolTagDataList ");
                position += tempLength;
                foundOne = true;
                continue;
            }
            if (type != null && type.equals(C1G2_CRC.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2_CRC.length();
                }
                this.airProtocolTagDataList.add(new C1G2_CRC(binary, position, tempLength));
                LOGGER.trace((Object)"adding C1G2_CRC to airProtocolTagDataList ");
                position += tempLength;
                foundOne = true;
                continue;
            }
            if (foundOne) continue;
            break;
        }
        if (this.airProtocolTagDataList.isEmpty()) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type AirProtocolTagData");
        }
        type = null;
        tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type AccessSpecID");
        }
        if (binary.get(position)) {
            TagReportData tagReportData = this;
            tempLength = tagReportData.accessSpecID.length();
        }
        if (type != null && type.equals(AccessSpecID.TYPENUM)) {
            this.accessSpecID = new AccessSpecID(binary, position, tempLength);
            position += tempLength;
            LOGGER.trace((Object)(" accessSpecID is instantiated with AccessSpecID with length" + tempLength));
        } else {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type AccessSpecID");
        }
        this.accessCommandOpSpecResultList = new LinkedList<AccessCommandOpSpecResult>();
        LOGGER.trace((Object)"decoding parameter accessCommandOpSpecResultList ");
        while (position < binary.length()) {
            boolean foundOne = false;
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(C1G2ReadOpSpecResult.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2ReadOpSpecResult.length();
                }
                this.accessCommandOpSpecResultList.add(new C1G2ReadOpSpecResult(binary, position, tempLength));
                LOGGER.trace((Object)"adding C1G2ReadOpSpecResult to accessCommandOpSpecResultList ");
                position += tempLength;
                foundOne = true;
                continue;
            }
            if (type != null && type.equals(C1G2WriteOpSpecResult.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2WriteOpSpecResult.length();
                }
                this.accessCommandOpSpecResultList.add(new C1G2WriteOpSpecResult(binary, position, tempLength));
                LOGGER.trace((Object)"adding C1G2WriteOpSpecResult to accessCommandOpSpecResultList ");
                position += tempLength;
                foundOne = true;
                continue;
            }
            if (type != null && type.equals(C1G2KillOpSpecResult.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2KillOpSpecResult.length();
                }
                this.accessCommandOpSpecResultList.add(new C1G2KillOpSpecResult(binary, position, tempLength));
                LOGGER.trace((Object)"adding C1G2KillOpSpecResult to accessCommandOpSpecResultList ");
                position += tempLength;
                foundOne = true;
                continue;
            }
            if (type != null && type.equals(C1G2LockOpSpecResult.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2LockOpSpecResult.length();
                }
                this.accessCommandOpSpecResultList.add(new C1G2LockOpSpecResult(binary, position, tempLength));
                LOGGER.trace((Object)"adding C1G2LockOpSpecResult to accessCommandOpSpecResultList ");
                position += tempLength;
                foundOne = true;
                continue;
            }
            if (type != null && type.equals(C1G2BlockEraseOpSpecResult.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2BlockEraseOpSpecResult.length();
                }
                this.accessCommandOpSpecResultList.add(new C1G2BlockEraseOpSpecResult(binary, position, tempLength));
                LOGGER.trace((Object)"adding C1G2BlockEraseOpSpecResult to accessCommandOpSpecResultList ");
                position += tempLength;
                foundOne = true;
                continue;
            }
            if (type != null && type.equals(C1G2BlockWriteOpSpecResult.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2BlockWriteOpSpecResult.length();
                }
                this.accessCommandOpSpecResultList.add(new C1G2BlockWriteOpSpecResult(binary, position, tempLength));
                LOGGER.trace((Object)"adding C1G2BlockWriteOpSpecResult to accessCommandOpSpecResultList ");
                position += tempLength;
                foundOne = true;
                continue;
            }
            if (type != null && type.equals(ClientRequestOpSpecResult.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = ClientRequestOpSpecResult.length();
                }
                this.accessCommandOpSpecResultList.add(new ClientRequestOpSpecResult(binary, position, tempLength));
                LOGGER.trace((Object)"adding ClientRequestOpSpecResult to accessCommandOpSpecResultList ");
                position += tempLength;
                foundOne = true;
                continue;
            }
            if (type != null && type.equals(Custom.TYPENUM)) {
                cus = new Custom(binary, position, tempLength);
                if (cus.getParameterSubtype().equals(ImpinjBlockPermalockOpSpecResult.PARAMETER_SUBTYPE)) {
                    this.accessCommandOpSpecResultList.add(new ImpinjBlockPermalockOpSpecResult(cus));
                    LOGGER.trace((Object)"adding ImpinjBlockPermalockOpSpecResult to accessCommandOpSpecResultList ");
                    position += tempLength;
                    foundOne = true;
                    continue;
                }
                if (cus.getParameterSubtype().equals(ImpinjGetBlockPermalockStatusOpSpecResult.PARAMETER_SUBTYPE)) {
                    this.accessCommandOpSpecResultList.add(new ImpinjGetBlockPermalockStatusOpSpecResult(cus));
                    LOGGER.trace((Object)"adding ImpinjGetBlockPermalockStatusOpSpecResult to accessCommandOpSpecResultList ");
                    position += tempLength;
                    foundOne = true;
                    continue;
                }
                if (cus.getParameterSubtype().equals(ImpinjSetQTConfigOpSpecResult.PARAMETER_SUBTYPE)) {
                    this.accessCommandOpSpecResultList.add(new ImpinjSetQTConfigOpSpecResult(cus));
                    LOGGER.trace((Object)"adding ImpinjSetQTConfigOpSpecResult to accessCommandOpSpecResultList ");
                    position += tempLength;
                    foundOne = true;
                    continue;
                }
                if (cus.getParameterSubtype().equals(ImpinjGetQTConfigOpSpecResult.PARAMETER_SUBTYPE)) {
                    this.accessCommandOpSpecResultList.add(new ImpinjGetQTConfigOpSpecResult(cus));
                    LOGGER.trace((Object)"adding ImpinjGetQTConfigOpSpecResult to accessCommandOpSpecResultList ");
                    position += tempLength;
                    foundOne = true;
                    continue;
                }
                if (cus.getParameterSubtype().equals(ImpinjMarginReadOpSpecResult.PARAMETER_SUBTYPE)) {
                    this.accessCommandOpSpecResultList.add(new ImpinjMarginReadOpSpecResult(cus));
                    LOGGER.trace((Object)"adding ImpinjMarginReadOpSpecResult to accessCommandOpSpecResultList ");
                    position += tempLength;
                    foundOne = true;
                    continue;
                }
                if (!LLRPKnownCustom.isKnown(cus.getVendorIdentifier(), cus.getParameterSubtype())) {
                    this.accessCommandOpSpecResultList.add(cus);
                    LOGGER.trace((Object)"adding Custom to specParameterList ");
                    position += tempLength;
                    foundOne = true;
                    continue;
                }
            }
            if (foundOne) continue;
            break;
        }
        if (this.accessCommandOpSpecResultList.isEmpty()) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type AccessCommandOpSpecResult");
        }
        this.customList = new LinkedList<Custom>();
        LOGGER.trace((Object)"decoding parameter customList ");
        while (position < binary.length()) {
            boolean foundOne = false;
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(Custom.TYPENUM)) {
                cus = new Custom(binary, position, tempLength);
                if (cus.getParameterSubtype().equals(ImpinjSerializedTID.PARAMETER_SUBTYPE)) {
                    this.customList.add(new ImpinjSerializedTID(cus));
                    LOGGER.trace((Object)"adding ImpinjSerializedTID to customList ");
                    position += tempLength;
                    foundOne = true;
                    continue;
                }
                if (cus.getParameterSubtype().equals(ImpinjRFPhaseAngle.PARAMETER_SUBTYPE)) {
                    this.customList.add(new ImpinjRFPhaseAngle(cus));
                    LOGGER.trace((Object)"adding ImpinjRFPhaseAngle to customList ");
                    position += tempLength;
                    foundOne = true;
                    continue;
                }
                if (cus.getParameterSubtype().equals(ImpinjPeakRSSI.PARAMETER_SUBTYPE)) {
                    this.customList.add(new ImpinjPeakRSSI(cus));
                    LOGGER.trace((Object)"adding ImpinjPeakRSSI to customList ");
                    position += tempLength;
                    foundOne = true;
                    continue;
                }
                if (cus.getParameterSubtype().equals(ImpinjGPSCoordinates.PARAMETER_SUBTYPE)) {
                    this.customList.add(new ImpinjGPSCoordinates(cus));
                    LOGGER.trace((Object)"adding ImpinjGPSCoordinates to customList ");
                    position += tempLength;
                    foundOne = true;
                    continue;
                }
                if (cus.getParameterSubtype().equals(ImpinjRFDopplerFrequency.PARAMETER_SUBTYPE)) {
                    this.customList.add(new ImpinjRFDopplerFrequency(cus));
                    LOGGER.trace((Object)"adding ImpinjRFDopplerFrequency to customList ");
                    position += tempLength;
                    foundOne = true;
                    continue;
                }
                if (cus.getParameterSubtype().equals(ImpinjTxPower.PARAMETER_SUBTYPE)) {
                    this.customList.add(new ImpinjTxPower(cus));
                    LOGGER.trace((Object)"adding ImpinjTxPower to customList ");
                    position += tempLength;
                    foundOne = true;
                    continue;
                }
                this.customList.add(cus);
                position += tempLength;
                foundOne = true;
            }
            if (foundOne) continue;
            break;
        }
        if (this.customList.isEmpty()) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type Custom");
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        String name;
        Object e2;
        List tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace((String)"http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        boolean found = false;
        LOGGER.trace((Object)"decoding choice type EPCParameter ");
        temp = element.getChild("EPCData", ns);
        if (temp != null) {
            this.ePCParameter = new EPCData(temp);
            LOGGER.trace((Object)" ePCParameter instatiated to EPCData with");
            found = true;
        }
        element.removeChild("EPCData", ns);
        temp = element.getChild("EPC_96", ns);
        if (temp != null) {
            this.ePCParameter = new EPC_96(temp);
            LOGGER.trace((Object)" ePCParameter instatiated to EPC_96 with");
            found = true;
        }
        element.removeChild("EPC_96", ns);
        if (!found) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type ePCParameterList");
        }
        if ((temp = element.getChild("ROSpecID", ns)) != null) {
            this.rOSpecID = new ROSpecID(temp);
            LOGGER.info((Object)"setting parameter rOSpecID for parameter TagReportData");
        }
        if (temp == null) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type rOSpecID");
        }
        element.removeChild("ROSpecID", ns);
        temp = element.getChild("SpecIndex", ns);
        if (temp != null) {
            this.specIndex = new SpecIndex(temp);
            LOGGER.info((Object)"setting parameter specIndex for parameter TagReportData");
        }
        if (temp == null) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type specIndex");
        }
        element.removeChild("SpecIndex", ns);
        temp = element.getChild("InventoryParameterSpecID", ns);
        if (temp != null) {
            this.inventoryParameterSpecID = new InventoryParameterSpecID(temp);
            LOGGER.info((Object)"setting parameter inventoryParameterSpecID for parameter TagReportData");
        }
        if (temp == null) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type inventoryParameterSpecID");
        }
        element.removeChild("InventoryParameterSpecID", ns);
        temp = element.getChild("AntennaID", ns);
        if (temp != null) {
            this.antennaID = new AntennaID(temp);
            LOGGER.info((Object)"setting parameter antennaID for parameter TagReportData");
        }
        if (temp == null) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type antennaID");
        }
        element.removeChild("AntennaID", ns);
        temp = element.getChild("PeakRSSI", ns);
        if (temp != null) {
            this.peakRSSI = new PeakRSSI(temp);
            LOGGER.info((Object)"setting parameter peakRSSI for parameter TagReportData");
        }
        if (temp == null) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type peakRSSI");
        }
        element.removeChild("PeakRSSI", ns);
        temp = element.getChild("ChannelIndex", ns);
        if (temp != null) {
            this.channelIndex = new ChannelIndex(temp);
            LOGGER.info((Object)"setting parameter channelIndex for parameter TagReportData");
        }
        if (temp == null) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type channelIndex");
        }
        element.removeChild("ChannelIndex", ns);
        temp = element.getChild("FirstSeenTimestampUTC", ns);
        if (temp != null) {
            this.firstSeenTimestampUTC = new FirstSeenTimestampUTC(temp);
            LOGGER.info((Object)"setting parameter firstSeenTimestampUTC for parameter TagReportData");
        }
        if (temp == null) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type firstSeenTimestampUTC");
        }
        element.removeChild("FirstSeenTimestampUTC", ns);
        temp = element.getChild("FirstSeenTimestampUptime", ns);
        if (temp != null) {
            this.firstSeenTimestampUptime = new FirstSeenTimestampUptime(temp);
            LOGGER.info((Object)"setting parameter firstSeenTimestampUptime for parameter TagReportData");
        }
        if (temp == null) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type firstSeenTimestampUptime");
        }
        element.removeChild("FirstSeenTimestampUptime", ns);
        temp = element.getChild("LastSeenTimestampUTC", ns);
        if (temp != null) {
            this.lastSeenTimestampUTC = new LastSeenTimestampUTC(temp);
            LOGGER.info((Object)"setting parameter lastSeenTimestampUTC for parameter TagReportData");
        }
        if (temp == null) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type lastSeenTimestampUTC");
        }
        element.removeChild("LastSeenTimestampUTC", ns);
        temp = element.getChild("LastSeenTimestampUptime", ns);
        if (temp != null) {
            this.lastSeenTimestampUptime = new LastSeenTimestampUptime(temp);
            LOGGER.info((Object)"setting parameter lastSeenTimestampUptime for parameter TagReportData");
        }
        if (temp == null) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type lastSeenTimestampUptime");
        }
        element.removeChild("LastSeenTimestampUptime", ns);
        temp = element.getChild("TagSeenCount", ns);
        if (temp != null) {
            this.tagSeenCount = new TagSeenCount(temp);
            LOGGER.info((Object)"setting parameter tagSeenCount for parameter TagReportData");
        }
        if (temp == null) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type tagSeenCount");
        }
        element.removeChild("TagSeenCount", ns);
        this.airProtocolTagDataList = new LinkedList<AirProtocolTagData>();
        tempList = element.getChildren();
        Iterator i = tempList.iterator();
        while (i.hasNext()) {
            e2 = (Element)i.next();
            name = e2.getName();
            if (name.equals("C1G2_PC")) {
                this.airProtocolTagDataList.add(new C1G2_PC((Element)e2));
                LOGGER.trace((Object)"adding C1G2_PC to airProtocolTagDataList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (!name.equals("C1G2_CRC")) continue;
            this.airProtocolTagDataList.add(new C1G2_CRC((Element)e2));
            LOGGER.trace((Object)"adding C1G2_CRC to airProtocolTagDataList ");
            atLeastOnce = true;
            i.remove();
        }
        temp = element.getChild("AccessSpecID", ns);
        if (temp != null) {
            this.accessSpecID = new AccessSpecID(temp);
            LOGGER.info((Object)"setting parameter accessSpecID for parameter TagReportData");
        }
        if (temp == null) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type accessSpecID");
        }
        element.removeChild("AccessSpecID", ns);
        this.accessCommandOpSpecResultList = new LinkedList<AccessCommandOpSpecResult>();
        tempList = element.getChildren();
        i = tempList.iterator();
        while (i.hasNext()) {
            e2 = (Element)i.next();
            name = e2.getName();
            if (name.equals("C1G2ReadOpSpecResult")) {
                this.accessCommandOpSpecResultList.add(new C1G2ReadOpSpecResult((Element)e2));
                LOGGER.trace((Object)"adding C1G2ReadOpSpecResult to accessCommandOpSpecResultList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("C1G2WriteOpSpecResult")) {
                this.accessCommandOpSpecResultList.add(new C1G2WriteOpSpecResult((Element)e2));
                LOGGER.trace((Object)"adding C1G2WriteOpSpecResult to accessCommandOpSpecResultList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("C1G2KillOpSpecResult")) {
                this.accessCommandOpSpecResultList.add(new C1G2KillOpSpecResult((Element)e2));
                LOGGER.trace((Object)"adding C1G2KillOpSpecResult to accessCommandOpSpecResultList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("C1G2LockOpSpecResult")) {
                this.accessCommandOpSpecResultList.add(new C1G2LockOpSpecResult((Element)e2));
                LOGGER.trace((Object)"adding C1G2LockOpSpecResult to accessCommandOpSpecResultList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("C1G2BlockEraseOpSpecResult")) {
                this.accessCommandOpSpecResultList.add(new C1G2BlockEraseOpSpecResult((Element)e2));
                LOGGER.trace((Object)"adding C1G2BlockEraseOpSpecResult to accessCommandOpSpecResultList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("C1G2BlockWriteOpSpecResult")) {
                this.accessCommandOpSpecResultList.add(new C1G2BlockWriteOpSpecResult((Element)e2));
                LOGGER.trace((Object)"adding C1G2BlockWriteOpSpecResult to accessCommandOpSpecResultList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("ClientRequestOpSpecResult")) {
                this.accessCommandOpSpecResultList.add(new ClientRequestOpSpecResult((Element)e2));
                LOGGER.trace((Object)"adding ClientRequestOpSpecResult to accessCommandOpSpecResultList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("ImpinjBlockPermalockOpSpecResult")) {
                this.accessCommandOpSpecResultList.add(new ImpinjBlockPermalockOpSpecResult((Element)e2));
                LOGGER.trace((Object)"adding ImpinjBlockPermalockOpSpecResult to accessCommandOpSpecResultList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("ImpinjGetBlockPermalockStatusOpSpecResult")) {
                this.accessCommandOpSpecResultList.add(new ImpinjGetBlockPermalockStatusOpSpecResult((Element)e2));
                LOGGER.trace((Object)"adding ImpinjGetBlockPermalockStatusOpSpecResult to accessCommandOpSpecResultList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("ImpinjSetQTConfigOpSpecResult")) {
                this.accessCommandOpSpecResultList.add(new ImpinjSetQTConfigOpSpecResult((Element)e2));
                LOGGER.trace((Object)"adding ImpinjSetQTConfigOpSpecResult to accessCommandOpSpecResultList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("ImpinjGetQTConfigOpSpecResult")) {
                this.accessCommandOpSpecResultList.add(new ImpinjGetQTConfigOpSpecResult((Element)e2));
                LOGGER.trace((Object)"adding ImpinjGetQTConfigOpSpecResult to accessCommandOpSpecResultList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("ImpinjMarginReadOpSpecResult")) {
                this.accessCommandOpSpecResultList.add(new ImpinjMarginReadOpSpecResult((Element)e2));
                LOGGER.trace((Object)"adding ImpinjMarginReadOpSpecResult to accessCommandOpSpecResultList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (!name.equals("Custom")) continue;
            this.accessCommandOpSpecResultList.add(new Custom((Element)e2));
            LOGGER.trace((Object)"adding Custom to accessCommandOpSpecResultList ");
            atLeastOnce = true;
            i.remove();
        }
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", ns);
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.trace((Object)"TagReportData misses optional parameter of type customList");
        } else {
            for (Object e2 : tempList) {
                this.customList.add(new Custom((Element)e2));
                LOGGER.trace((Object)"adding Custom to customList ");
            }
        }
        element.removeChildren("Custom", ns);
        Namespace nsImpinjSerializedTID = Namespace.getNamespace((String)"Impinj", (String)"http://developer.impinj.com/ltk/schema/encoding/xml/1.30");
        tempList = element.getChildren("ImpinjSerializedTID", nsImpinjSerializedTID);
        for (Object e3 : tempList) {
            this.customList.add(new ImpinjSerializedTID((Element)e3));
            LOGGER.trace((Object)"adding ImpinjSerializedTID to customList ");
        }
        element.removeChildren("ImpinjSerializedTID", nsImpinjSerializedTID);
        Namespace nsImpinjRFPhaseAngle = Namespace.getNamespace((String)"Impinj", (String)"http://developer.impinj.com/ltk/schema/encoding/xml/1.30");
        tempList = element.getChildren("ImpinjRFPhaseAngle", nsImpinjRFPhaseAngle);
        for (Object e4 : tempList) {
            this.customList.add(new ImpinjRFPhaseAngle((Element)e4));
            LOGGER.trace((Object)"adding ImpinjRFPhaseAngle to customList ");
        }
        element.removeChildren("ImpinjRFPhaseAngle", nsImpinjRFPhaseAngle);
        Namespace nsImpinjPeakRSSI = Namespace.getNamespace((String)"Impinj", (String)"http://developer.impinj.com/ltk/schema/encoding/xml/1.30");
        tempList = element.getChildren("ImpinjPeakRSSI", nsImpinjPeakRSSI);
        for (Object e5 : tempList) {
            this.customList.add(new ImpinjPeakRSSI((Element)e5));
            LOGGER.trace((Object)"adding ImpinjPeakRSSI to customList ");
        }
        element.removeChildren("ImpinjPeakRSSI", nsImpinjPeakRSSI);
        Namespace nsImpinjGPSCoordinates = Namespace.getNamespace((String)"Impinj", (String)"http://developer.impinj.com/ltk/schema/encoding/xml/1.30");
        tempList = element.getChildren("ImpinjGPSCoordinates", nsImpinjGPSCoordinates);
        for (Object e6 : tempList) {
            this.customList.add(new ImpinjGPSCoordinates((Element)e6));
            LOGGER.trace((Object)"adding ImpinjGPSCoordinates to customList ");
        }
        element.removeChildren("ImpinjGPSCoordinates", nsImpinjGPSCoordinates);
        Namespace nsImpinjRFDopplerFrequency = Namespace.getNamespace((String)"Impinj", (String)"http://developer.impinj.com/ltk/schema/encoding/xml/1.30");
        tempList = element.getChildren("ImpinjRFDopplerFrequency", nsImpinjRFDopplerFrequency);
        for (Object e7 : tempList) {
            this.customList.add(new ImpinjRFDopplerFrequency((Element)e7));
            LOGGER.trace((Object)"adding ImpinjRFDopplerFrequency to customList ");
        }
        element.removeChildren("ImpinjRFDopplerFrequency", nsImpinjRFDopplerFrequency);
        Namespace nsImpinjTxPower = Namespace.getNamespace((String)"Impinj", (String)"http://developer.impinj.com/ltk/schema/encoding/xml/1.30");
        tempList = element.getChildren("ImpinjTxPower", nsImpinjTxPower);
        for (Element e8 : tempList) {
            this.customList.add(new ImpinjTxPower(e8));
            LOGGER.trace((Object)"adding ImpinjTxPower to customList ");
        }
        element.removeChildren("ImpinjTxPower", nsImpinjTxPower);
        tempList = element.getChildren("Custom", ns);
        for (Element e8 : tempList) {
            this.customList.add(new Custom(e8));
            atLeastOnce = true;
            LOGGER.trace((Object)"adding custom parameter");
        }
        element.removeChildren("Custom", ns);
        if (element.getChildren().size() > 0) {
            String message = "TagReportData has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setEPCParameter(EPCParameter ePCParameter) {
        this.ePCParameter = ePCParameter;
    }

    public void setROSpecID(ROSpecID rOSpecID) {
        this.rOSpecID = rOSpecID;
    }

    public void setSpecIndex(SpecIndex specIndex) {
        this.specIndex = specIndex;
    }

    public void setInventoryParameterSpecID(InventoryParameterSpecID inventoryParameterSpecID) {
        this.inventoryParameterSpecID = inventoryParameterSpecID;
    }

    public void setAntennaID(AntennaID antennaID) {
        this.antennaID = antennaID;
    }

    public void setPeakRSSI(PeakRSSI peakRSSI) {
        this.peakRSSI = peakRSSI;
    }

    public void setChannelIndex(ChannelIndex channelIndex) {
        this.channelIndex = channelIndex;
    }

    public void setFirstSeenTimestampUTC(FirstSeenTimestampUTC firstSeenTimestampUTC) {
        this.firstSeenTimestampUTC = firstSeenTimestampUTC;
    }

    public void setFirstSeenTimestampUptime(FirstSeenTimestampUptime firstSeenTimestampUptime) {
        this.firstSeenTimestampUptime = firstSeenTimestampUptime;
    }

    public void setLastSeenTimestampUTC(LastSeenTimestampUTC lastSeenTimestampUTC) {
        this.lastSeenTimestampUTC = lastSeenTimestampUTC;
    }

    public void setLastSeenTimestampUptime(LastSeenTimestampUptime lastSeenTimestampUptime) {
        this.lastSeenTimestampUptime = lastSeenTimestampUptime;
    }

    public void setTagSeenCount(TagSeenCount tagSeenCount) {
        this.tagSeenCount = tagSeenCount;
    }

    public void setAirProtocolTagDataList(List<AirProtocolTagData> airProtocolTagDataList) {
        this.airProtocolTagDataList = airProtocolTagDataList;
    }

    public void setAccessSpecID(AccessSpecID accessSpecID) {
        this.accessSpecID = accessSpecID;
    }

    public void setAccessCommandOpSpecResultList(List<AccessCommandOpSpecResult> accessCommandOpSpecResultList) {
        this.accessCommandOpSpecResultList = accessCommandOpSpecResultList;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public EPCParameter getEPCParameter() {
        return this.ePCParameter;
    }

    public ROSpecID getROSpecID() {
        return this.rOSpecID;
    }

    public SpecIndex getSpecIndex() {
        return this.specIndex;
    }

    public InventoryParameterSpecID getInventoryParameterSpecID() {
        return this.inventoryParameterSpecID;
    }

    public AntennaID getAntennaID() {
        return this.antennaID;
    }

    public PeakRSSI getPeakRSSI() {
        return this.peakRSSI;
    }

    public ChannelIndex getChannelIndex() {
        return this.channelIndex;
    }

    public FirstSeenTimestampUTC getFirstSeenTimestampUTC() {
        return this.firstSeenTimestampUTC;
    }

    public FirstSeenTimestampUptime getFirstSeenTimestampUptime() {
        return this.firstSeenTimestampUptime;
    }

    public LastSeenTimestampUTC getLastSeenTimestampUTC() {
        return this.lastSeenTimestampUTC;
    }

    public LastSeenTimestampUptime getLastSeenTimestampUptime() {
        return this.lastSeenTimestampUptime;
    }

    public TagSeenCount getTagSeenCount() {
        return this.tagSeenCount;
    }

    public List<AirProtocolTagData> getAirProtocolTagDataList() {
        return this.airProtocolTagDataList;
    }

    public AccessSpecID getAccessSpecID() {
        return this.accessSpecID;
    }

    public List<AccessCommandOpSpecResult> getAccessCommandOpSpecResultList() {
        return this.accessCommandOpSpecResultList;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToAirProtocolTagDataList(AirProtocolTagData airProtocolTagData) {
        if (this.airProtocolTagDataList == null) {
            this.airProtocolTagDataList = new LinkedList<AirProtocolTagData>();
        }
        this.airProtocolTagDataList.add(airProtocolTagData);
    }

    public void addToAccessCommandOpSpecResultList(AccessCommandOpSpecResult accessCommandOpSpecResult) {
        if (this.accessCommandOpSpecResultList == null) {
            this.accessCommandOpSpecResultList = new LinkedList<AccessCommandOpSpecResult>();
        }
        this.accessCommandOpSpecResultList.add(accessCommandOpSpecResult);
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "TagReportData";
    }

    public String toString() {
        String result = "TagReportData: ";
        result = result.replaceFirst(", ", "");
        return result;
    }
}

