/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.net;

import org.apache.log4j.Logger;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.types.LLRPMessage;

public class LLRPBinaryEncoder
implements ProtocolEncoder {
    Logger log = Logger.getLogger(LLRPBinaryEncoder.class);

    public void dispose(IoSession session) throws Exception {
    }

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        byte[] byteMsg;
        LLRPMessage llrp = (LLRPMessage)message;
        this.log.debug((Object)("encoding message " + llrp.getClass()));
        try {
            byteMsg = llrp.encodeBinary();
        }
        catch (InvalidLLRPMessageException me) {
            this.log.warn((Object)("no message written because error occured: " + me.getMessage()));
            return;
        }
        IoBuffer buffer = IoBuffer.allocate((int)byteMsg.length, (boolean)false);
        buffer.put(byteMsg);
        buffer.flip();
        out.write((Object)buffer);
    }
}

