/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import java.math.BigInteger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPNumberType;

public class UnsignedShort
extends LLRPNumberType {
    private static final Integer LENGTH = 16;
    protected Integer value;

    public UnsignedShort(LLRPBitList bitList, int bitIndex, int length) {
        this.decodeBinary(bitList.subList(bitIndex, length));
        this.signed = false;
    }

    public UnsignedShort(Short value) {
        this.value = value & 0xFFFFFFFF;
        this.signed = false;
    }

    public UnsignedShort(int value) {
        this.value = value;
        this.signed = false;
        if (!this.inRange(this.value.intValue())) {
            throw new IllegalArgumentException("value " + value + " not in range allowed for UnsignedShort");
        }
    }

    public UnsignedShort(Element element) {
        this.decodeXML(element);
    }

    public UnsignedShort() {
        this.value = 0;
        this.signed = false;
    }

    public UnsignedShort(String valueString, int radix) {
        this(new BigInteger(valueString, radix).intValue());
    }

    public UnsignedShort(Integer value) {
        this((int)value);
    }

    public UnsignedShort(String valueString) {
        this.value = new Integer(valueString);
        this.signed = false;
        if (!this.inRange(valueString)) {
            throw new IllegalArgumentException("value " + valueString + " not in range");
        }
    }

    public UnsignedShort(LLRPBitList bitList) {
        this.decodeBinary(bitList);
        this.signed = false;
    }

    @Override
    public LLRPBitList encodeBinary() {
        LLRPBitList result = new LLRPBitList(Integer.toBinaryString(this.value));
        if (result.length() < LENGTH) {
            result.pad(LENGTH - result.length());
        }
        return result.subList(result.length() - LENGTH, LENGTH);
    }

    public static int length() {
        return LENGTH;
    }

    @Override
    public Integer toInteger() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    public short toShort() {
        return this.value.shortValue();
    }

    @Override
    public void decodeBinary(LLRPBitList list) {
        this.value = list.toInt();
        if (this.value < 0) {
            this.value = 65536 + this.value;
        }
    }

    @Override
    public void decodeXML(Element element) {
        this.value = new Integer(element.getText().trim());
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        Element element = new Element(name, ns);
        element.setContent((Content)new Text(this.value.toString()));
        return element;
    }

    @Override
    public String toString(int radix) {
        return Integer.toString(this.value & 0xFFFF, radix);
    }

    @Override
    public boolean inRange(long value) {
        int max = 65535;
        return value >= 0L && value <= (long)max;
    }

    @Override
    public boolean inRange(String valueString) {
        return this.inRange(new BigInteger(valueString).longValue());
    }
}

