/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TVParameter;
import org.llrp.ltk.types.UnsignedInteger;

public class AccessSpecID
extends TVParameter {
    public static final SignedShort TYPENUM = new SignedShort(16);
    private static final Logger LOGGER = Logger.getLogger(AccessSpecID.class);
    protected UnsignedInteger accessSpecID;

    public AccessSpecID() {
    }

    public AccessSpecID(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public AccessSpecID(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public AccessSpecID(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.accessSpecID == null) {
            LOGGER.warn(" accessSpecID not set");
            throw new MissingParameterException(" accessSpecID not set  for Parameter of Type AccessSpecID");
        }
        resultBits.append(this.accessSpecID.encodeBinary());
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.accessSpecID == null) {
            LOGGER.warn(" accessSpecID not set");
            throw new MissingParameterException(" accessSpecID not set");
        }
        element.addContent(this.accessSpecID.encodeXML("AccessSpecID", ns));
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.accessSpecID = new UnsignedInteger(binary, position, UnsignedInteger.length());
        position += UnsignedInteger.length();
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("AccessSpecID", ns);
        if (temp != null) {
            this.accessSpecID = new UnsignedInteger(temp);
        }
        element.removeChild("AccessSpecID", ns);
        if (element.getChildren().size() > 0) {
            String message = "AccessSpecID has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setAccessSpecID(UnsignedInteger accessSpecID) {
        this.accessSpecID = accessSpecID;
    }

    public UnsignedInteger getAccessSpecID() {
        return this.accessSpecID;
    }

    public static Integer length() {
        int tempLength = 8;
        return tempLength += UnsignedInteger.length();
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "AccessSpecID";
    }

    public String toString() {
        String result = "AccessSpecID: ";
        result = result + ", accessSpecID: ";
        result = result + this.accessSpecID;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

