/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.log4j.Logger;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.llrp.ltk.net.LLRPConnection;
import org.llrp.ltk.net.LLRPConnectionAttemptFailedException;
import org.llrp.ltk.net.LLRPEndpoint;
import org.llrp.ltk.net.LLRPIoHandlerAdapter;
import org.llrp.ltk.net.LLRPProtocolCodecFactory;

public class LLRPAcceptor
extends LLRPConnection {
    public static final int IDLE_TIME = 20;
    private static final Logger log = Logger.getLogger(LLRPAcceptor.class);
    private int port = 5084;
    private NioSocketAcceptor acceptor;
    private InetSocketAddress socketAddress;

    public LLRPAcceptor() {
    }

    public LLRPAcceptor(LLRPEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public LLRPAcceptor(LLRPEndpoint endpoint, int port) {
        this.endpoint = endpoint;
        this.port = port;
    }

    public LLRPAcceptor(LLRPEndpoint endpoint, int port, LLRPIoHandlerAdapter handler) {
        this.endpoint = endpoint;
        this.port = port;
        this.handler = handler;
    }

    public LLRPAcceptor(LLRPEndpoint endpoint, LLRPIoHandlerAdapter handler) {
        this.endpoint = endpoint;
        this.handler = handler;
    }

    public void bind() throws LLRPConnectionAttemptFailedException {
        this.bind(0L);
    }

    public void bind(long timeout) throws LLRPConnectionAttemptFailedException {
        this.acceptor = new NioSocketAcceptor();
        this.acceptor.getFilterChain().addLast("logger", new LoggingFilter());
        this.acceptor.getFilterChain().addLast("codec", new ProtocolCodecFilter(new LLRPProtocolCodecFactory(1)));
        this.acceptor.setHandler(this.handler);
        this.acceptor.getSessionConfig().setReadBufferSize(2048);
        this.acceptor.getSessionConfig().setIdleTime(IdleStatus.BOTH_IDLE, 20);
        try {
            this.socketAddress = new InetSocketAddress(this.port);
            this.acceptor.setHandler(this.handler);
            this.acceptor.bind((SocketAddress)this.socketAddress);
            log.info("server listening on port " + this.port);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            throw new LLRPConnectionAttemptFailedException(e.getMessage());
        }
        if (timeout > 0L) {
            this.checkLLRPConnectionAttemptStatus(timeout);
        }
    }

    public void close() {
        this.acceptor.unbind(this.socketAddress);
    }

    @Override
    public boolean reconnect() {
        return false;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

